/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ListElement;
import algoanim.primitives.Primitive;
import algoanim.primitives.generators.Language;
import algoanim.primitives.generators.ListElementGenerator;
import algoanim.properties.ListElementProperties;
import algoanim.util.Node;
import algoanim.util.Timing;
import java.awt.Color;
import java.util.ListIterator;

public class AnimalListElementGenerator
extends AnimalGenerator
implements ListElementGenerator {
    private static int count = 1;

    public AnimalListElementGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(ListElement e) {
        if (this.isNameUsed(e.getName()) || e.getName() == "") {
            e.setName("ListElement" + count);
            ++count;
        }
        this.lang.addItem(e);
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("listelement \"" + e.getName() + "\"");
        def.append(" " + AnimalGenerator.makeNodeDef(e.getUpperLeft()));
        ListElementProperties props = e.getProperties();
        if (props.get("text") != null) {
            def.append(" text \"" + props.get("text").toString() + "\"");
        }
        def.append(" pointers " + e.getPointers());
        def.append(" position ");
        Integer o2 = (Integer)props.get("position");
        switch (o2) {
            case 0: {
                def.append("none");
                break;
            }
            case 1: {
                def.append("right");
                break;
            }
            case 2: {
                def.append("left");
                break;
            }
            case 3: {
                def.append("top");
                break;
            }
            default: {
                def.append("bottom");
            }
        }
        def.append(" ");
        if (e.getPointerLocations() != null) {
            int i = 1;
            ListIterator li = e.getPointerLocations().listIterator();
            int pointers = e.getPointers();
            while (i <= pointers && li.hasNext()) {
                Object o = li.next();
                if (o instanceof Node) {
                    def.append(" ptr").append(i).append(" ").append(AnimalGenerator.makeNodeDef((Node)o));
                } else if (o instanceof Primitive) {
                    def.append(" ptr").append(i).append(" to \"").append(((Primitive)o).getName()).append("\" ");
                }
                ++i;
            }
        }
        if (e.getPrev() != null) {
            def.append(" prev \"");
            def.append(e.getPrev().getName());
            def.append("\" ");
        }
        if (e.getNext() != null) {
            def.append(" next \"");
            def.append(e.getNext().getName());
            def.append("\" ");
        }
        if (props.get("color") != null) {
            def.append("color " + AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()) + " ");
        }
        if (props.get("boxFillColor") != null) {
            def.append("boxFillColor " + AnimalGenerator.makeColorDef(((Color)props.get("boxFillColor")).getRed(), ((Color)props.get("boxFillColor")).getGreen(), ((Color)props.get("boxFillColor")).getBlue()) + " ");
        }
        if (props.get("pointerAreaColor") != null) {
            def.append("pointerAreaColor " + AnimalGenerator.makeColorDef(((Color)props.get("pointerAreaColor")).getRed(), ((Color)props.get("pointerAreaColor")).getGreen(), ((Color)props.get("pointerAreaColor")).getBlue()) + " ");
        }
        if (props.get("pointerAreaFillColor") != null) {
            def.append("pointerAreaFillColor " + AnimalGenerator.makeColorDef(((Color)props.get("pointerAreaFillColor")).getRed(), ((Color)props.get("pointerAreaFillColor")).getGreen(), ((Color)props.get("pointerAreaFillColor")).getBlue()) + " ");
        }
        if (props.get("textColor") != null) {
            def.append("textColor " + AnimalGenerator.makeColorDef(((Color)props.get("textColor")).getRed(), ((Color)props.get("textColor")).getGreen(), ((Color)props.get("textColor")).getBlue()) + " ");
        }
        if (props.get("depth") != null) {
            def.append("depth " + props.get("depth") + " ");
        }
        def.append(AnimalGenerator.makeDisplayOptionsDef(e.getDisplayOptions(), props));
        this.lang.addLine(def);
    }

    @Override
    public void link(ListElement start, ListElement target, int linkno, Timing t, Timing d) {
        this.lang.addLine("setLink \"" + start.getName() + "\" link " + linkno + " to \"" + target.getName() + "\" " + AnimalGenerator.makeOffsetTimingDef(t) + " " + AnimalGenerator.makeDurationTimingDef(d));
    }

    @Override
    public void unlink(ListElement start, int linkno, Timing t, Timing d) {
        this.lang.addLine("clearLink \"" + start.getName() + "\" link " + linkno + AnimalGenerator.makeOffsetTimingDef(t) + " " + AnimalGenerator.makeDurationTimingDef(d));
    }
}

