/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.exceptions.IllegalDirectionException;
import algoanim.primitives.Group;
import algoanim.primitives.ListBasedQueue;
import algoanim.primitives.ListElement;
import algoanim.primitives.Primitive;
import algoanim.primitives.Rect;
import algoanim.primitives.generators.Language;
import algoanim.primitives.generators.ListBasedQueueGenerator;
import algoanim.properties.ListElementProperties;
import algoanim.properties.RectProperties;
import algoanim.util.Coordinates;
import algoanim.util.Hidden;
import algoanim.util.Node;
import algoanim.util.Offset;
import algoanim.util.Timing;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class AnimalListBasedQueueGenerator<T>
extends AnimalGenerator
implements ListBasedQueueGenerator<T> {
    private static int count = 1;
    private Node upperLeft;
    private ListElementProperties lp;
    private ListElement head;
    private ListElement tail;
    private Rect emptyQueue;
    private boolean hidden;
    private boolean hiddenProp;
    private boolean emptyHidden;
    private boolean highlightedTailCell;
    private boolean highlightedTailElem;
    private LinkedList<Primitive> list;
    private final int distance = 70;
    int ulx;
    int uly;

    public AnimalListBasedQueueGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(ListBasedQueue<T> lbq) {
        if (this.isNameUsed(lbq.getName()) || lbq.getName() == "") {
            lbq.setName("ListBasedQueue" + count);
            ++count;
        }
        this.upperLeft = lbq.getUpperLeft();
        if (this.upperLeft instanceof Coordinates) {
            this.ulx = ((Coordinates)this.upperLeft).getX();
            this.uly = ((Coordinates)this.upperLeft).getY();
        }
        Object queueColor = lbq.getProperties().get("color");
        this.hiddenProp = (Boolean)lbq.getProperties().get("hidden");
        this.hidden = lbq.getDisplayOptions() instanceof Hidden;
        RectProperties rp = new RectProperties();
        rp.set("hidden", this.hiddenProp);
        rp.set("color", queueColor);
        this.emptyQueue = this.lang.newRect(this.upperLeft, new Coordinates(this.ulx + 20, this.uly + 40), "", lbq.getDisplayOptions(), rp);
        this.lp = new ListElementProperties();
        this.lp.set("color", queueColor);
        this.lp.set("pointerAreaColor", queueColor);
        this.lp.set("position", 4);
        this.lp.set("textColor", lbq.getProperties().get("elementColor"));
        this.lp.set("boxFillColor", Color.WHITE);
        this.lp.set("pointerAreaFillColor", Color.WHITE);
        this.lp.set("depth", lbq.getProperties().get("depth"));
        this.lp.set("hidden", this.hiddenProp);
        this.list = new LinkedList();
        List content = lbq.getInitContent();
        if (content != null) {
            ListIterator li = content.listIterator();
            while (li.hasNext()) {
                this.enqueue(lbq, li.next(), null, null);
            }
        }
    }

    @Override
    public void dequeue(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.head.hide(delay);
        this.list.removeFirst();
        if (!this.list.isEmpty()) {
            this.head = (ListElement)this.list.getFirst();
            Group newQueue = this.lang.newGroup(this.list, "");
            try {
                this.lang.nextStep(0);
                newQueue.moveTo("NW", "translate", this.upperLeft, delay, duration);
            }
            catch (IllegalDirectionException e) {
                e.printStackTrace();
            }
        } else if (!this.hidden && !this.hiddenProp) {
            this.emptyQueue.show(delay);
            this.emptyHidden = false;
        }
    }

    @Override
    public void enqueue(ListBasedQueue<T> lbq, T elem, Timing delay, Timing duration) {
        if (!this.emptyHidden) {
            this.emptyQueue.hide(delay);
            this.emptyHidden = true;
        }
        if (this.tail != null && this.highlightedTailElem) {
            this.unhighlightTailElem(lbq, delay, duration);
        }
        if (this.tail != null && this.highlightedTailCell) {
            this.unhighlightTailCell(lbq, delay, duration);
        }
        String text = elem.toString();
        this.lp.set("text", text);
        Node newTailPosition = this.tail == null ? this.upperLeft : new Offset(70, 0, this.tail, "NE");
        this.lang.nextStep(0);
        ListElement le = this.lang.newListElement(newTailPosition, 1, null, null, "", this.hidden ? new Hidden() : null, this.lp);
        if (this.tail != null) {
            this.lang.nextStep(0);
            this.tail.link(le, 1, delay, duration);
        } else {
            this.head = le;
        }
        this.tail = le;
        this.list.add(le);
    }

    @Override
    public void front(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.highlightFrontCell(lbq, delay, duration);
        this.highlightFrontElem(lbq, delay, duration);
    }

    @Override
    public void highlightFrontCell(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.head.changeColor("fillColor", (Color)lbq.getProperties().get("cellHighlight"), delay, duration);
        this.head.changeColor("pointer background color", (Color)lbq.getProperties().get("cellHighlight"), delay, duration);
    }

    @Override
    public void highlightFrontElem(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.head.changeColor("textcolor", (Color)lbq.getProperties().get("elemHighlight"), delay, duration);
    }

    @Override
    public void highlightTailCell(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.tail.changeColor("fillColor", (Color)lbq.getProperties().get("cellHighlight"), delay, duration);
        this.tail.changeColor("pointer background color", (Color)lbq.getProperties().get("cellHighlight"), delay, duration);
        this.highlightedTailCell = true;
    }

    @Override
    public void highlightTailElem(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.tail.changeColor("textcolor", (Color)lbq.getProperties().get("elemHighlight"), delay, duration);
        this.highlightedTailElem = true;
    }

    @Override
    public void isEmpty(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
    }

    @Override
    public void tail(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.highlightTailCell(lbq, delay, duration);
        this.highlightTailElem(lbq, delay, duration);
    }

    @Override
    public void unhighlightFrontCell(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.head.changeColor("fillColor", Color.WHITE, delay, duration);
        this.head.changeColor("pointer background color", Color.WHITE, delay, duration);
    }

    @Override
    public void unhighlightFrontElem(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.head.changeColor("textcolor", (Color)this.lp.get("textColor"), delay, duration);
    }

    @Override
    public void unhighlightTailCell(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.tail.changeColor("fillColor", Color.WHITE, delay, duration);
        this.tail.changeColor("pointer background color", Color.WHITE, delay, duration);
        this.highlightedTailCell = false;
    }

    @Override
    public void unhighlightTailElem(ListBasedQueue<T> lbq, Timing delay, Timing duration) {
        this.tail.changeColor("textcolor", (Color)this.lp.get("textColor"), delay, duration);
        this.highlightedTailElem = true;
    }
}

