/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Ellipse;
import algoanim.primitives.generators.EllipseGenerator;
import algoanim.primitives.generators.Language;
import algoanim.properties.EllipseProperties;
import java.awt.Color;

public class AnimalEllipseGenerator
extends AnimalGenerator
implements EllipseGenerator {
    private static int count = 1;

    public AnimalEllipseGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(Ellipse aellipse) {
        if (this.isNameUsed(aellipse.getName()) || aellipse.getName() == "") {
            aellipse.setName("Ellipse" + count);
            ++count;
        }
        this.lang.addItem(aellipse);
        StringBuilder str = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        str.append("ellipse \"" + aellipse.getName() + "\" ");
        str.append(AnimalGenerator.makeNodeDef(aellipse.getCenter()));
        str.append(" radius " + AnimalGenerator.makeNodeDef(aellipse.getRadius()));
        EllipseProperties props = aellipse.getProperties();
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("filled") != null && ((Boolean)props.get("filled")).booleanValue()) {
            str.append(" filled");
            if (props.get("fillColor") != null) {
                str.append(" fillColor ");
                str.append(AnimalGenerator.makeColorDef(((Color)props.get("fillColor")).getRed(), ((Color)props.get("fillColor")).getGreen(), ((Color)props.get("fillColor")).getBlue()));
            }
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(aellipse.getDisplayOptions(), props));
        this.lang.addLine(str);
    }
}

