/*
 * Decompiled with CFR 0.152.
 */
package net.algoanim.aads;

import net.algoanim.aads.AnimatedIntArray;

public class AnimatedIntArrayMarker {
    private AnimatedIntArray animatedIntArray = null;
    private int currentIndex = -1;
    private String label = null;
    private String title = null;
    private StringBuilder buffer = null;

    public AnimatedIntArrayMarker(AnimatedIntArray theBaseArray, int thePosition, String theLabel, StringBuilder sbuf) {
        this(theBaseArray, thePosition, theLabel, sbuf, null);
    }

    public AnimatedIntArrayMarker(AnimatedIntArray theBaseArray, int thePosition, String theLabel, StringBuilder sbuf, String theTitle) {
        this(theBaseArray, thePosition, theLabel, sbuf, theTitle, "red");
    }

    public AnimatedIntArrayMarker(AnimatedIntArray theBaseArray, int thePosition, String theLabel, StringBuilder sbuf, String theTitle, String colorLabel) {
        this.animatedIntArray = theBaseArray;
        if (this.animatedIntArray != null) {
            this.buffer = sbuf != null ? sbuf : this.getLocalBuffer();
            int length = this.animatedIntArray.getLength();
            this.label = theLabel;
            this.title = theTitle;
            this.currentIndex = thePosition >= 0 && thePosition <= length ? thePosition : 0;
            this.installArrayIndex(colorLabel);
        }
    }

    private StringBuilder getLocalBuffer() {
        if (this.buffer == null) {
            this.buffer = new StringBuilder(Short.MAX_VALUE);
        }
        return this.buffer;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void installArrayIndex() {
        this.installArrayIndex("red");
    }

    public void installArrayIndex(String colorLabel) {
        if (this.animatedIntArray == null || this.currentIndex < 0 || this.currentIndex >= this.animatedIntArray.getLength()) {
            return;
        }
        StringBuilder sbuf = this.getLocalBuffer();
        sbuf.append("  arrayIndex \"").append(this.label).append("\" on \"");
        sbuf.append(this.animatedIntArray.getArrayName());
        sbuf.append("\" atIndex ").append(this.currentIndex);
        if (this.title != null) {
            sbuf.append(" label \"").append(this.title).append("\"");
        }
        sbuf.append(" color ").append(colorLabel).append("\n");
        this.animatedIntArray.incrementAssignments();
    }

    public void decrementArrayIndex() {
        this.moveArrayIndex(this.currentIndex - 1);
    }

    public void incrementArrayIndex() {
        this.moveArrayIndex(this.currentIndex + 1);
    }

    public void moveArrayIndex(String aLabel, int targetPosition) {
        if (this.animatedIntArray == null || targetPosition < 0 || targetPosition > this.animatedIntArray.getLength()) {
            return;
        }
        StringBuilder sbuf = this.getLocalBuffer();
        sbuf.append("  moveMarker \"").append(aLabel).append("\" to position ");
        sbuf.append(targetPosition).append(" within 5 ticks\n");
        this.currentIndex = targetPosition;
        this.animatedIntArray.incrementAssignments();
    }

    public void moveArrayIndex(int targetPosition) {
        this.moveArrayIndex(targetPosition, 0);
    }

    public void moveArrayIndex(int targetPosition, int delay) {
        if (this.animatedIntArray == null || targetPosition < -1 || targetPosition > this.animatedIntArray.getLength()) {
            return;
        }
        this.getLocalBuffer().append("  moveMarker \"").append(this.label).append("\" to ");
        if (targetPosition >= 0) {
            this.getLocalBuffer().append("position ").append(targetPosition);
        } else {
            this.getLocalBuffer().append("outside");
        }
        if (delay > 0) {
            this.getLocalBuffer().append(" after ").append(delay).append("ticks");
        }
        this.getLocalBuffer().append(" within 5 ticks");
        this.getLocalBuffer().append("\n");
        this.currentIndex = targetPosition;
        this.animatedIntArray.incrementAssignments();
    }
}

