/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.SortingAlgorithm;
import java.util.Hashtable;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionSort
extends SortingAlgorithm
implements Generator {
    private static final String DESCRIPTION = "Dieser Generator sortiert das vom Nutzer eingegebene Array mittels Selection Sort.\nUm ein Array der L\u2030nge n zu sortieren, wird das Minimum gesucht, also das Element mit dem kleinsten Sortierschl\u00b8ssel.\nDas Minimum wird dann mit dem ersten Element des Arrays vertauscht. Somit erh\u2030lt man links ein sortiertes Teilarray der L\u2030nge 1 und rechts ein unsortiertes der L\u2030nge n-1.\nAnschlie\ufb02end wird der Algorithmus auf das unsortierte Teilarray angewendet.";
    private static final String HEADER_TEXT = "\ntext \"f1-01\" \"Selection Sort\" at (120,50) color black font SansSerif size 32 bold\n{\ntext \"f1-02a\" \"Das naheliegendste Verfahren zur Sortierung\" at (20,100) color black font SansSerif size 24\ntext \"f1-02b\" \"ist Sortieren durch Auswahl, auch als\" at (20,130) color black font SansSerif size 24\ntext \"f1-02c\" \"Selection Sort bezeichnet.\" at (20,160) color black font SansSerif size 24\n}\nhideAll\ntext \"f2-01\" \"Der Algorithmus in Worten\" at (120,50) color black font SansSerif size 32 bold\ntext \"f2-02\" \"1. Setze i=0\" at (20,100) color black font SansSerif size 24\ntext \"f2-03\" \"2. Suche ab Position i das kleinste Element im Feld\" at (20,140) color black font SansSerif size 24\ntext \"f2-04\" \"3. Vertausche das kleinste Element mit dem Element ab Position i\" at (20,180) color black font SansSerif size 24\ntext \"f2-05\" \"4. Setze i=i+1 und fahre bei Schritt 2 fort bis i==n\" at (20,220) color black font SansSerif size 24\n";
    private static final String SOURCE_CODE = "public void selectionSort(int[] array)\n{\n  int i, j, minIndex;\n  for (i=0; i<array.length - 1; i++)\n  {\n    minIndex = i;\n    for (j=i+1; j<array.length; j++)\n      if (array[j] < array[minIndex])\n        minIndex = j;\n    swap(array, i, minIndex);\n  }\n}";

    @Override
    public void sort(int[] b) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        int nrElems = b.length;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Selection Sort Animation\"\n");
        this.sb.append("author \"Dr. Guido Roessling (roessling@acm.org>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.toggleStep();
        this.targetArray = this.createIntArray("array");
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.codeSupport.highlightCode(0);
        this.startStep();
        this.codeSupport.unhighlightCode(0);
        this.iMarker = this.createArrayMarker(this.targetArray, 0, "i");
        this.jMarker = this.createArrayMarker(this.targetArray, 0, "j");
        this.codeSupport.highlightCode(2);
        this.toggleStep();
        this.codeSupport.unhighlightCode(2);
        this.codeSupport.highlightCode(3);
        this.toggleStep();
        this.codeSupport.unhighlightCode(3);
        int i = 0;
        while (i < nrElems - 1) {
            if (i == 0) {
                this.iMarker.moveArrayIndex(i);
                this.codeSupport.highlightCode(4);
                this.endStep();
            } else {
                this.targetArray.highlightArrayCell(i - 1);
                this.iMarker.moveArrayIndex(i);
                this.codeSupport.highlightCode(4);
                this.endStep();
            }
            int minIndex = i;
            ++this.nrAssigns;
            this.startStep();
            this.codeSupport.unhighlightCode(4);
            this.targetArray.highlightArrayElement(minIndex);
            this.codeSupport.highlightCode(6);
            this.toggleStep();
            this.codeSupport.unhighlightCode(6);
            ++this.nrAssigns;
            int j = i + 1;
            while (j < nrElems) {
                ++this.nrAssigns;
                this.jMarker.moveArrayIndex(j);
                this.codeSupport.highlightCode(7);
                ++this.nrComparisons;
                this.toggleStep();
                this.codeSupport.unhighlightCode(7);
                this.codeSupport.highlightCode(9);
                this.toggleStep();
                this.codeSupport.unhighlightCode(9);
                if (this.targetArray.getElementAt(j) < this.targetArray.getElementAt(minIndex)) {
                    this.targetArray.unhighlightArrayElement(minIndex);
                    minIndex = j;
                    ++this.nrAssigns;
                    this.targetArray.highlightArrayElement(minIndex);
                    this.codeSupport.highlightCode(11);
                    this.toggleStep();
                    this.codeSupport.unhighlightCode(11);
                }
                ++j;
            }
            this.codeSupport.highlightCode(7);
            this.toggleStep();
            this.codeSupport.unhighlightCode(7);
            this.targetArray.highlightArrayElement(i);
            this.nrAssigns += 3;
            this.targetArray.swap(i, minIndex);
            this.codeSupport.highlightCode(14);
            this.toggleStep();
            this.targetArray.unhighlightArrayElement(i);
            this.targetArray.unhighlightArrayElement(minIndex);
            this.toggleStep();
            this.codeSupport.unhighlightCode(14);
            ++i;
        }
        this.codeSupport.highlightCode(4);
        this.toggleStep();
        this.codeSupport.unhighlightCode(4);
        this.targetArray.highlightArrayCell(nrElems - 1);
        this.targetArray.highlightArrayCell(nrElems - 2);
        this.toggleStep();
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00b8hrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    @Override
    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    @Override
    public String getName() {
        return "Selection Sort";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.setParameters(props, primitives);
        int[] theArray = (int[])primitives.get("array");
        this.sort(theArray);
        return this.sb.toString();
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

