/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.StringMatrix;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LZ78
extends CompressionAlgorithm
implements Generator {
    private static final int inputLimit = 26;
    private static final String DESCRIPTION = "LZ78 ist ein verlustfreies Kompressionsverfahren, welches eine Weiterentwicklung des LZ77 Verfahrens darstellt. In dem Verfahren werden durch das Scannen des Eingabestrings Dateien in einem W\u02c6rterbuch abgelegt.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 26 Buchstaben begrenzt.";

    public LZ78() {
        this(new AnimalScript("LZ78", "Florian Lindner", 800, 600));
    }

    public LZ78(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(text.length, 26)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "LZ78", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "1) Lege ein W\u02c6rterbuch an, das initial das Ende einer Datei (ferner EOF) mit 0 und", "line1", null, tpsteps);
        Text step12 = this.lang.newText(new Offset(0, 20, step1, "SW"), "     die Buchstaben von A bis Z mit den Zahlen 1 bis 26 kodiert.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 40, step12, "SW"), "2) Nun wird die Eingabe zeichenweise bis zum Ende des Textes eingelesen.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 40, step2, "SW"), "3) Das eingelesene Zeichen wird mit sovielen folgenden Buchstaben erg\u2030nzt,", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), "      bie die entstehende Kombination nicht mehr im W\u02c6rterbuch enthalten ist. ", "line3", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 40, step31, "SW"), "4)  Diese Kombination w\u2030re also ohne ihren letzten Buchstaben noch im W\u02c6rterbuch vorhanden.", "line3", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), "    Das Ergebnis wird um den passenden Schl\u00b8ssel dieser nicht vollst\u2030ndigen Kombination erweitert. F\u00b8r die", "line3", null, tpsteps);
        Text step42 = this.lang.newText(new Offset(0, 20, step41, "SW"), "    vollst\u2030ndige Kombination wird ein Eintrag an der n\u2030chsten freien Stelle im W\u02c6rterbuch angelegt.", "line3", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step1.hide();
        step12.hide();
        step2.hide();
        step3.hide();
        step31.hide();
        step4.hide();
        step41.hide();
        step42.hide();
        String input = "";
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        input = input.toUpperCase();
        StringArray strArray = this.lang.newStringArray(new Offset(0, 90, topic, "SW"), text, "text", null, ap);
        ArrayMarker marker = this.lang.newArrayMarker(strArray, 0, "marker", null, amp);
        Vector<String> dict = new Vector<String>(0, 1);
        dict.add("EOF");
        int i3 = 65;
        while (i3 < 91) {
            dict.add("" + (char)i3);
            ++i3;
        }
        String[][] dictData = new String[26][2];
        int i4 = 0;
        while (i4 < dictData.length) {
            dictData[i4][0] = "  ";
            dictData[i4][1] = "  ";
            ++i4;
        }
        dictData[0][0] = "0";
        dictData[0][1] = "EOF";
        dictData[1][0] = "1";
        dictData[1][1] = "A";
        dictData[2][0] = "...";
        dictData[2][1] = "...";
        dictData[3][0] = "26";
        dictData[3][1] = "Z";
        int matrixCounter = 4;
        StringMatrix dictMatrix = this.lang.newStringMatrix(new Offset(110, 0, strArray, "NE"), dictData, "dict", null, mp);
        this.lang.nextStep();
        String result = "";
        Text resultText = this.lang.newText(new Offset(0, 35, strArray, "SW"), "Ausgabe:  ", "result", null, tpsteps);
        Text resultText2 = this.lang.newText(new Offset(5, -5, resultText, "SE"), result, "result", null, tpsteps);
        resultText2.changeColor(null, Color.RED, null, null);
        this.lang.nextStep();
        int i5 = 0;
        while (i5 < input.length()) {
            marker.move(i5, null, null);
            String tmp = "" + input.charAt(i5);
            strArray.unhighlightCell(0, i5, null, null);
            strArray.highlightCell(i5, null, null);
            while (dict.contains(tmp) && i5 + 1 < input.length()) {
                if (dict.contains(String.valueOf(tmp) + input.charAt(i5 + 1))) {
                    tmp = String.valueOf(tmp) + input.charAt(i5 + 1);
                    strArray.highlightCell(++i5, null, null);
                    continue;
                }
                dict.add(String.valueOf(tmp) + input.charAt(i5 + 1));
                dictMatrix.put(matrixCounter, 0, "" + (matrixCounter + 23), null, null);
                dictMatrix.put(matrixCounter, 1, tmp + input.charAt(i5 + 1), null, null);
                dictMatrix.highlightCell(matrixCounter, 0, null, null);
                dictMatrix.highlightCell(matrixCounter, 1, null, null);
                if (matrixCounter > 0) {
                    dictMatrix.unhighlightCell(matrixCounter - 1, 0, null, null);
                    dictMatrix.unhighlightCell(matrixCounter - 1, 1, null, null);
                }
                ++matrixCounter;
                if (tmp.length() > 1) {
                    dictMatrix.highlightCell(dict.indexOf(tmp) - 23, 1, null, null);
                }
                this.lang.nextStep();
                if (tmp.length() <= 1) break;
                dictMatrix.unhighlightCell(dict.indexOf(tmp) - 23, 1, null, null);
                break;
            }
            result = String.valueOf(result) + dict.indexOf(tmp) + " ";
            resultText2.setText(result, null, null);
            this.lang.nextStep();
            ++i5;
        }
        Text fazit = this.lang.newText(new Offset(0, 90, resultText, "SW"), "Damit ergibt sich die Ausgabe:  ", "Ausgabe", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(0, 20, fazit, "SW"), result, "Ausgabe", null, tpsteps);
        fazit2.changeColor(null, Color.BLUE, null, null);
        Text fazit3 = this.lang.newText(new Offset(0, 20, fazit2, "SW"), "Die zus\u2030tzliche Ausgabe des W\u02c6rterbuchs ist nicht notwendig.", "fazit", null, tpsteps);
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "LZ78";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }
}

