/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.IntMatrix;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LZ77
extends CompressionAlgorithm
implements Generator {
    private static final int inputLimit = 11;
    private static final String DESCRIPTION = "Das LZ77 Verfahren ist ein verlustfreies Kompressionsverfahren. Es werden W\u02c6rter oder Teile davon, die in einem Text mehrmals auftauchen, durch einen Schl\u00b8ssel ersetzt.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 11 Buchstaben begrenzt.";

    public LZ77() {
        this(new AnimalScript("LZ77", "Florian Lindner", 800, 600));
    }

    public LZ77(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(text.length, 11)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "LZ77", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "1) Lege eine Tabelle mit 2 Spalten an: Textfenster und Puffer. Das Textfenster speichert", "line1", null, tpsteps);
        Text step12 = this.lang.newText(new Offset(0, 20, step1, "SW"), "     den zuletzt eingelesenen Text mit den Indizes von rechts nach links aufsteigend.", "line1", null, tpsteps);
        Text step13 = this.lang.newText(new Offset(0, 20, step12, "SW"), "     Der Puffer beinhaltet eingelesene Zeichen, die noch unkodiert sind.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 40, step13, "SW"), "2) Suche nun im Textfenster einen Substring, der durch den Anfang des Puffers gebildet wird.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 40, step2, "SW"), "3) Der entsprechende Anfang des Puffers wird in ein 3 Tupel (a,b,c) codiert.", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), "      a:    Indexstelle des Substrings im Textfenster", "line3", null, tpsteps);
        Text step32 = this.lang.newText(new Offset(0, 20, step31, "SW"), "      b:    L\u2030nge des Substrings", "line3", null, tpsteps);
        Text step33 = this.lang.newText(new Offset(0, 20, step32, "SW"), "      c:    Folgezeichen des Substring im Puffer", "line3", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 40, step33, "SW"), "4)  Shifte den Substring und das Folgezeichen iterativ nach links. Fahre bis zum Textende mit Schritt 2 fort.", "line3", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step1.hide();
        step12.hide();
        step13.hide();
        step2.hide();
        step3.hide();
        step31.hide();
        step32.hide();
        step33.hide();
        step4.hide();
        this.lang.nextStep();
        Text description = this.lang.newText(new Offset(0, 40, topic, "SW"), "Wir suchen also im Textfenster nach den ersten Zeichen im Puffer.", "desc", null, tpsteps);
        String input = "";
        int[][] ind = new int[1][text.length];
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ind[0][i2] = text.length - i2 - 1;
            ++i2;
        }
        IntMatrix index = this.lang.newIntMatrix(new Offset(5, 20, description, "SW"), ind, "index", null, mp);
        Text bufText = this.lang.newText(new Offset(60, 0, index, "SE"), "Puffer", "buftext", null, tpsteps);
        bufText.changeColor(null, Color.BLUE, null, null);
        String[] winContent = new String[input.length()];
        String[] bufContent = new String[input.length()];
        int i3 = 0;
        while (i3 < winContent.length) {
            winContent[i3] = "      ";
            bufContent[i3] = "  " + text[i3] + "  ";
            ++i3;
        }
        StringArray windowArray = this.lang.newStringArray(new Offset(-5, 15, index, "SW"), winContent, "window", null, ap);
        StringArray bufferArray = this.lang.newStringArray(new Offset(35, 0, windowArray, "NE"), bufContent, "buffer", null, ap);
        StringArray lastWindow = windowArray;
        StringArray lastBuffer = bufferArray;
        this.lang.nextStep();
        String window = "";
        String buffer = "";
        String result = "";
        int i4 = 0;
        while (i4 < text.length) {
            buffer = String.valueOf(buffer) + text[i4];
            ++i4;
        }
        while (buffer.length() != 0) {
            int i5;
            Text tupel;
            String tmp = "" + buffer.charAt(0);
            int cnt = 0;
            while (cnt < buffer.length() - 1 && window.contains(tmp)) {
                if (!window.contains(String.valueOf(tmp) + buffer.charAt(++cnt))) break;
                tmp = String.valueOf(tmp) + buffer.charAt(cnt);
            }
            if (!window.contains(tmp)) {
                result = String.valueOf(result) + "(0,0," + tmp + ") ";
                tupel = this.lang.newText(new Offset(10, 20, lastBuffer, "NE"), "(0,0," + tmp + ") ", "tupel", null, tpsteps);
                tupel.changeColor(null, Color.RED, null, null);
                bufferArray.highlightCell(0, tmp.length() - 1, null, null);
                this.lang.nextStep();
                window = String.valueOf(window) + buffer.substring(0, 1);
                buffer = buffer.substring(1, buffer.length());
                i5 = 0;
                while (i5 < winContent.length) {
                    winContent[i5] = "       ";
                    bufContent[i5] = "       ";
                    ++i5;
                }
                i5 = 0;
                while (i5 < winContent.length) {
                    winContent[winContent.length - i5 - 1] = i5 < window.length() ? "  " + window.charAt(window.length() - i5 - 1) + "  " : "      ";
                    ++i5;
                }
                i5 = 0;
                while (i5 < bufContent.length) {
                    bufContent[i5] = i5 > buffer.length() - 1 ? "      " : "  " + buffer.charAt(i5) + "  ";
                    ++i5;
                }
                windowArray = this.lang.newStringArray(new Offset(0, 20, lastWindow, "SW"), winContent, "window", null, ap);
                bufferArray = this.lang.newStringArray(new Offset(0, 20, lastBuffer, "SW"), bufContent, "buffer", null, ap);
                lastWindow = windowArray;
                lastBuffer = bufferArray;
                continue;
            }
            if (cnt + 1 < buffer.length()) {
                result = String.valueOf(result) + "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + buffer.charAt(cnt) + ") ";
                tupel = this.lang.newText(new Offset(10, 20, lastBuffer, "NE"), "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + buffer.charAt(cnt) + ") ", "tupel", null, tpsteps);
                tupel.changeColor(null, Color.RED, null, null);
                bufferArray.highlightCell(0, tmp.length() - 1, null, null);
                this.lang.nextStep();
                window = String.valueOf(window) + buffer.substring(0, tmp.length() + 1);
                buffer = buffer.substring(tmp.length() + 1, buffer.length());
                i5 = 0;
                while (i5 < winContent.length) {
                    winContent[i5] = "       ";
                    bufContent[i5] = "       ";
                    ++i5;
                }
                i5 = 0;
                while (i5 < winContent.length) {
                    winContent[winContent.length - i5 - 1] = i5 < window.length() ? "  " + window.charAt(window.length() - i5 - 1) + "  " : "      ";
                    ++i5;
                }
                i5 = 0;
                while (i5 < bufContent.length) {
                    bufContent[i5] = i5 > buffer.length() - 1 ? "      " : "  " + buffer.charAt(i5) + "  ";
                    ++i5;
                }
                windowArray = this.lang.newStringArray(new Offset(0, 20, lastWindow, "SW"), winContent, "window", null, ap);
                bufferArray = this.lang.newStringArray(new Offset(0, 20, lastBuffer, "SW"), bufContent, "buffer", null, ap);
                lastWindow = windowArray;
                lastBuffer = bufferArray;
                continue;
            }
            result = String.valueOf(result) + "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + "EOF)";
            tupel = this.lang.newText(new Offset(10, 20, lastBuffer, "NE"), "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + "EOF)", "tupel", null, tpsteps);
            tupel.changeColor(null, Color.RED, null, null);
            bufferArray.highlightCell(0, tmp.length() - 1, null, null);
            break;
        }
        Text fazit = this.lang.newText(new Offset(0, 90, lastWindow, "SW"), "Ausgabe:  ", "Ausgabe", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(15, -5, fazit, "SE"), result, "Ausgabe", null, tpsteps);
        fazit2.changeColor(null, Color.BLUE, null, null);
        Text fazit3 = this.lang.newText(new Offset(0, 20, fazit2, "SW"), "Diese Ausgabe kann nun durch Huffman komprimiert werden.", "fazit", null, tpsteps);
        Text fazit4 = this.lang.newText(new Offset(0, 20, fazit3, "SW"), "Eine Kombination wird z.B. in Deflate verwendet.", "fazit", null, tpsteps);
    }

    public static String getDESCRIPTION() {
        return DESCRIPTION;
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "LZ77";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }
}

