/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.util.Locale;

public class InsertionSortPseudoCode2
extends SortingAlgorithm
implements Generator {
    private static final String DESCRIPTION = "Dieser Generator sortiert das vom Nutzer eingegebene Array mittels Insertion Sort.Der Algorithmus entnimmt der unsortierten Eingabemenge ein beliebiges (z.B. das erste) Element und f\u00b8gt es an richtiger Stelle in die (anfangs leere) Ausgabemenge ein. Das Verfahren arbeitet also in-place. Geht man in der Reihenfolge der urspr\u00b8nglichen Menge vor, so ist es jedoch (etwa im Gegensatz zu Selection Sort) stabil. Wird auf einem Array gearbeitet, so m\u00b8ssen die Elemente nach dem neu eingef\u00b8gten Element verschoben werden. Dies ist die eigentlich teure Operation von Insertionsort, da das Finden der richtigen Einf\u00b8geposition \u00b8ber eine bin\u2030re Suche vergleichsweise effizient erfolgen kann.";
    private static final String HEADER_TEXT = "text \"f1-01\" \"Insertion Sort\" at (120,50) color black font SansSerif size 32 bold\n{\n \ttext \"f1-02a\" \"Sortieren durch Einf\u00b8gen, auch als Insertion Sort bezeichnet, f\u00b8gt\" at (20,100) color black font SansSerif size 24\n  text \"f1-02b\" \"der Reihe nach Elemente in eine bereits sortierte (Teil-)Liste ein,\" at (20,130) color black font SansSerif size 24\n  text \"f1-02c\" \"die anfangs leer ist.\" at (20,160) color black font SansSerif size 24\n}\n{\n  text \"f1-03a\" \"Damit ist das Vorgehen dem Sortieren von Spielkarten aehnlich: in\" at (20,200) color black font SansSerif size 24\n  text \"f1-03b\" \"jedem Schritt wird eine neue Spielkarte zwischen die bereits\" at (20,230) color black font SansSerif size 24\n  text \"f1-03c\" \"sortierten Karten einf\u00b8gt.\" at (20,260) color black font SansSerif size 24\n}\nhideAll\ntext \"f2-01\" \"Der Algorithmus in Worten\" at (120,50) color black font SansSerif size 32 bold\ntext \"f2-02\" \"1. Setze i=1\" at (20,100) color black font SansSerif size 24\ntext \"f2-03\" \"2. Speichere a[i] in einer Variablen v und setze j=i\" at (20,140) color black font SansSerif size 24\n{\n  text \"f2-04a\" \"3. Solange j>0 und v kleiner als a[j-1] is, kopiere\" at (20,180) color black font SansSerif size 24\n  text \"f2-04b\" \"    a[j-1] an Position a[j] und setze j=j-1\" at (20,210) color black font SansSerif size 24\n}\ntext \"f2-05\" \"4. F\u00b8ge Element v an die Position j ein\" at (20,250) color black font SansSerif size 24\n{\n  text \"f2-06a\" \"5. Falls i kleiner als n ist, erh\u02c6he i um eins und fahre\" at (20,290) color black font SansSerif size 24\n  text \"f2-06b\" \"    fort mit Schritt 2\" at (20,320) color black font SansSerif size 24\n}\n";
    private static final String SOURCE_CODE = "InsertionSort(int[] array)\n  Deklariere int-Variablen currentPos, insertPos, currentVal;\n  currentPos = 1;\n  Solange currentPos < Feldl\u00e4nge:  \n    currentVal = array[i];\n    insertPos = currentPos;\n    Solange insertPos > 0 und currentVal < array[insertPos - 1]:\n      array[insertPos] = array[insertPos - 1];\n      insertPos = insertPos - 1;\n    array[insertPos] = currentVal;\n    currentPos = currentPos + 1;";

    public void sort(int[] a) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        boolean jDefined = false;
        boolean enteredLoop = false;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0");
        this.sb.append("\ntitle \"Insertion Sort with Pseudo Code Animation\"");
        this.sb.append("\nauthor \"Dr. Guido R\u00f6\u00dfling (roessling@acm.org>\"");
        this.sb.append(HEADER_TEXT);
        this.sb.append("\nhideAll\n");
        this.targetArray = this.createIntArray("array");
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.toggleStep();
        this.codeSupport.highlightCode(0);
        this.toggleStep();
        this.codeSupport.highlightCode(0, true, true);
        this.codeSupport.highlightCode(1);
        this.sb.append("\n  text \"currentVal\" \"currentVal: \" offset (20, 0) from \"array\" SE");
        this.toggleStep();
        this.codeSupport.switchCodeLine(1, 2);
        int i = 1;
        ++this.nrAssigns;
        this.iMarker = this.createArrayMarker(this.targetArray, i, "i");
        this.toggleStep();
        this.codeSupport.switchCodeLine(2, 3);
        while (i < this.targetArray.getLength()) {
            this.toggleStep();
            this.codeSupport.highlightCode(3, true, true);
            this.codeSupport.switchCodeLine(10, 4);
            this.targetArray.highlightArrayElement(i);
            int v = this.targetArray.getElementAt(i);
            ++this.nrAssigns;
            if (i > 1) {
                this.sb.append("\n hide \"cVal").append(i - 1).append("\"");
                this.codeSupport.unhighlightCode(10);
            }
            this.sb.append("\n  text \"cVal").append(i).append("\" \"").append(v);
            this.sb.append("\" offset (20, 0) from \"currentVal\" baseline after 5 ticks");
            this.toggleStep();
            this.codeSupport.switchCodeLine(4, 5);
            this.targetArray.unhighlightArrayElement(i);
            int j = i;
            if (!jDefined) {
                this.jMarker = this.createArrayMarker(this.targetArray, i, "j");
                jDefined = true;
            } else {
                this.jMarker.moveArrayIndex(j);
            }
            this.toggleStep();
            this.codeSupport.switchCodeLine(5, 6);
            enteredLoop = false;
            while (j > 0 && v < this.targetArray.getElementAt(j - 1)) {
                this.toggleStep();
                if (!enteredLoop) {
                    this.codeSupport.highlightCode(6, true, true);
                    enteredLoop = true;
                } else {
                    this.codeSupport.unhighlightCode(8);
                }
                this.nrComparisons += 2;
                this.codeSupport.highlightCode(7);
                this.targetArray.putElement(this.targetArray.getElementAt(j - 1), j);
                this.targetArray.highlightArrayCell(j);
                ++this.nrAssigns;
                this.toggleStep();
                this.codeSupport.switchCodeLine(7, 8);
                this.jMarker.moveArrayIndex(--j);
                this.targetArray.unhighlightArrayCell(j + 1);
            }
            if (enteredLoop) {
                this.endStep();
                this.codeSupport.unhighlightCode(8);
            }
            this.toggleStep();
            this.codeSupport.switchCodeLine(6, 9);
            this.targetArray.putElement(v, j);
            this.targetArray.highlightArrayCell(j);
            this.endStep();
            ++this.nrAssigns;
            this.toggleStep();
            this.codeSupport.switchCodeLine(9, 10);
            this.targetArray.unhighlightArrayCell(j);
            this.iMarker.moveArrayIndex(++i);
        }
        this.codeSupport.unhighlightCode(3);
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00b8hrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Insertion Sort (Pseudo Code 2)";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

