/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.util.Locale;

public class InsertionSort
extends SortingAlgorithm
implements Generator {
    private static final String DESCRIPTION = "Dieser Generator sortiert das vom Nutzer eingegebene Array mittels Insertion Sort.Der Algorithmus entnimmt der unsortierten Eingabemenge ein beliebiges (z.B. das erste) Element und f\u00b8gt es an richtiger Stelle in die (anfangs leere) Ausgabemenge ein. Das Verfahren arbeitet also in-place. Geht man in der Reihenfolge der urspr\u00b8nglichen Menge vor, so ist es jedoch (etwa im Gegensatz zu Selection Sort) stabil. Wird auf einem Array gearbeitet, so m\u00b8ssen die Elemente nach dem neu eingef\u00b8gten Element verschoben werden. Dies ist die eigentlich teure Operation von Insertionsort, da das Finden der richtigen Einf\u00b8geposition \u00b8ber eine bin\u2030re Suche vergleichsweise effizient erfolgen kann.";
    private static final String HEADER_TEXT = "text \"f1-01\" \"Insertion Sort\" at (120,50) color black font SansSerif size 32 bold\n{\n \ttext \"f1-02a\" \"Sortieren durch Einf\u00b8gen, auch als Insertion Sort bezeichnet, f\u00b8gt\" at (20,100) color black font SansSerif size 24\n  text \"f1-02b\" \"der Reihe nach Elemente in eine bereits sortierte (Teil-)Liste ein,\" at (20,130) color black font SansSerif size 24\n  text \"f1-02c\" \"die anfangs leer ist.\" at (20,160) color black font SansSerif size 24\n}\n{\n  text \"f1-03a\" \"Damit ist das Vorgehen dem Sortieren von Spielkarten \u2030hnlich: in\" at (20,200) color black font SansSerif size 24\n  text \"f1-03b\" \"jedem Schritt wird eine neue Spielkarte zwischen die bereits\" at (20,230) color black font SansSerif size 24\n  text \"f1-03c\" \"sortierten Karten einf\u00b8gt.\" at (20,260) color black font SansSerif size 24\n}\nhideAll\ntext \"f2-01\" \"Der Algorithmus in Worten\" at (120,50) color black font SansSerif size 32 bold\ntext \"f2-02\" \"1. Setze i=1\" at (20,100) color black font SansSerif size 24\ntext \"f2-03\" \"2. Speichere a[i] in einer Variablen v und setze j=i\" at (20,140) color black font SansSerif size 24\n{\n  text \"f2-04a\" \"3. Solange j>0 und v kleiner als a[j-1] is, kopiere\" at (20,180) color black font SansSerif size 24\n  text \"f2-04b\" \"    a[j-1] an Position a[j] und setze j=j-1\" at (20,210) color black font SansSerif size 24\n}\ntext \"f2-05\" \"4. F\u00b8ge Element v an die Position j ein\" at (20,250) color black font SansSerif size 24\n{\n  text \"f2-06a\" \"5. Falls i kleiner als n ist, erh\u02c6he i um eins und fahre\" at (20,290) color black font SansSerif size 24\n  text \"f2-06b\" \"    fort mit Schritt 2\" at (20,320) color black font SansSerif size 24\n}\n";
    private static final String SOURCE_CODE = "public void insertionSort(int[] array)\n{\n  int i, j, v;\n  for (i=1; i<array.length; i++)\n  {\n    v = array[i];\n    for (j=i; j>0 && v<array[j-1]; j--)\n      array[j] = array[j-1];\n    array[j] = v;\n  }\n}";

    public void sort(int[] a) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Insertion Sort Animation\"\n");
        this.sb.append("author \"Dr. Guido Roessling (roessling@acm.org>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.targetArray = this.createIntArray("array");
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.toggleStep();
        this.codeSupport.highlightCode(0);
        this.toggleStep();
        this.codeSupport.switchCodeLine(0, 2);
        this.iMarker = this.createArrayMarker(this.targetArray, 0, "i");
        this.jMarker = this.createArrayMarker(this.targetArray, 0, "j");
        this.toggleStep();
        this.codeSupport.switchCodeLine(2, 3);
        this.toggleStep();
        this.codeSupport.unhighlightCode(3);
        int i = 1;
        while (i < a.length) {
            this.codeSupport.highlightCode(4);
            this.targetArray.highlightArrayCell(i - 1);
            this.iMarker.moveArrayIndex(i);
            this.toggleStep();
            this.codeSupport.switchCodeLine(4, 6);
            this.targetArray.highlightArrayCell(i);
            ++this.nrAssigns;
            int v = a[i];
            this.toggleStep();
            this.codeSupport.unhighlightCode(6);
            this.targetArray.unhighlightArrayElement(i);
            int j = i;
            while (j > 0 && v < a[j - 1]) {
                ++this.nrComparisons;
                this.jMarker.moveArrayIndex(j);
                this.codeSupport.highlightCode(7);
                this.toggleStep();
                ++this.nrAssigns;
                a[j] = a[j - 1];
                this.codeSupport.switchCodeLine(7, 9);
                this.targetArray.putElement(this.targetArray.getElementAt(j - 1), j);
                this.targetArray.highlightArrayCell(j);
                this.targetArray.unhighlightArrayCell(j - 1);
                this.toggleStep();
                this.codeSupport.unhighlightCode(9);
                --j;
            }
            this.codeSupport.highlightCode(7);
            ++this.nrAssigns;
            a[j] = v;
            this.toggleStep();
            this.codeSupport.switchCodeLine(7, 11);
            this.targetArray.putElement(v, j);
            this.targetArray.highlightArrayElement(j);
            this.toggleStep();
            this.targetArray.highlightArrayCell(j);
            this.targetArray.unhighlightArrayElement(j);
            this.toggleStep();
            this.codeSupport.unhighlightCode(11);
            ++i;
        }
        this.codeSupport.highlightCode(4);
        this.endStep();
        this.codeSupport.unhighlightCode(4);
        this.startStep();
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00b8hrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Insertion Sort";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

