/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.StringMatrix;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.RectProperties;
import animalscriptapi.properties.TextProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithmeticEncoding
extends CompressionAlgorithm
implements Generator {
    private float startSubInterval;
    private float endSubInterval;
    private static Vector<Rect> rects;
    private static final int inputLimit = 6;
    private static final String DESCRIPTION = "Die arithmetische Kodierung ist ein verlustfreies Kompressionsverfahren. Der Eingabestring wird in eine Gleitkommazahl umgewandelt, wobei eine Einteilung der Gleitkommazahlen durch eine H\u2030ufigkeitsverteilung erfolgt.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 6 Buchstaben begrenzt.";

    public ArithmeticEncoding() {
        this(new AnimalScript("Arithmetic Encoding", "Florian Lindner", 1000, 1000));
    }

    public ArithmeticEncoding(Language language) {
        this.lang = language;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) {
        String ein = "";
        String[] t = new String[Math.min(text.length, 6)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        String input = "";
        int i2 = 0;
        while (i2 < Math.min(6, text.length)) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        Text topic = this.lang.newText(new Coordinates(20, 50), "Arithmetic Encoding", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(10, 0, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Offset(0, 35, topic, "SW"), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "1) Berechne die absoluten H\u2030ufigkeiten jedes Buchstabens.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 30, step1, "SW"), "2) Ordne jedem Buchstaben ein Teilintervall zwischen 0 und 1 zu, abh\u2030ngig von seiner H\u2030ufigkeit.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 30, step2, "SW"), "3)  Um einen String zu kodieren, iteriere buchstabenweise \u00b8ber den String und bestimme sukzessive ein", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 30, step3, "SW"), "      neues Intervall. Das Subintervall, das dem n\u2030chsten Zeichen der Eingabe entspricht, wird zum", "line31", null, tpsteps);
        Text step32 = this.lang.newText(new Offset(0, 30, step31, "SW"), "      aktuellen Intervall, welches im n\u2030chsten Schritt unterteilt wird.", "line32", null, tpsteps);
        Text step4 = this.lang.newText(new Offset(0, 30, step32, "SW"), "4) Sind noch weitere Zeichen zu kodieren, dann fahr fort bei Schritt 2.", "line4", null, tpsteps);
        this.lang.nextStep();
        Text step5 = this.lang.newText(new Offset(0, 30, step4, "SW"), "5) Eine beliebige Zahl innerhalb des letzten Intervalls stellt das Ergebnis dar.", "line4", null, tpsteps);
        this.lang.nextStep();
        algoinWords.setText("Eingabe:", null, null);
        Text eingabe = this.lang.newText(new Offset(-120, -5, algoinWords, "SE"), input, "eingabe", null, tpsteps);
        eingabe.changeColor(null, Color.RED, null, null);
        step1.changeColor(null, Color.RED, null, null);
        step2.hide();
        step3.hide();
        step3.hide();
        step31.hide();
        step32.hide();
        step4.hide();
        step5.hide();
        rects = new Vector();
        this.startSubInterval = 0.0f;
        this.endSubInterval = 1.0f;
        float[] letters = new float[256];
        int i3 = 0;
        while (i3 < text.length) {
            int n = new Integer(text[i3].charAt(0));
            letters[n] = letters[n] + 1.0f;
            ++i3;
        }
        float[] frequency = new float[256];
        int i4 = 0;
        while (i4 < letters.length) {
            frequency[i4] = letters[i4] / (float)text.length;
            ++i4;
        }
        float big = 0.0f;
        int index = 0;
        Vector<Range> ranges = new Vector<Range>(0, 1);
        int i5 = 0;
        while (i5 < text.length) {
            int j = 0;
            while (j < frequency.length) {
                if (frequency[j] > big) {
                    big = frequency[j];
                    index = j;
                }
                ++j;
            }
            if (!ranges.isEmpty() && big > 0.0f) {
                ranges.add(new Range((char)index, ((Range)ranges.lastElement()).getEnd(), ((Range)ranges.lastElement()).getEnd() + big, letters[index]));
            } else if (big > 0.0f) {
                ranges.add(new Range((char)index, 0.0f, big, letters[index]));
            }
            frequency[index] = -1.0f;
            big = 0.0f;
            index = 0;
            ++i5;
        }
        String[][] freqPrint = new String[ranges.size()][2];
        int i6 = 0;
        while (i6 < ranges.size()) {
            freqPrint[i6][0] = String.valueOf(((Range)ranges.elementAt(i6)).getLetter()) + ": ";
            freqPrint[i6][1] = new Integer(new Float(((Range)ranges.elementAt(i6)).getFrequency()).intValue()).toString();
            ++i6;
        }
        StringMatrix strMatrix = this.lang.newStringMatrix(new Offset(0, 30, step1, "SW"), freqPrint, "matrix", null, mp);
        this.lang.nextStep();
        strMatrix.hide();
        step1.setText(step2.getText(), null, null);
        step2.setText(step3.getText(), null, null);
        step3.setText(step31.getText(), null, null);
        step31.setText(step32.getText(), null, null);
        step32.setText("Aktueller Buchstabe:  ", null, null);
        step32.changeColor(null, Color.BLUE, null, null);
        step2.changeColor(null, Color.RED, null, null);
        step3.changeColor(null, Color.RED, null, null);
        step31.changeColor(null, Color.RED, null, null);
        step2.show();
        step3.show();
        step31.show();
        step32.show();
        this.lang.nextStep();
        TextProperties tpend = new TextProperties();
        tpend.set("color", Color.BLACK);
        tpend.set("font", new Font("SansSerif", 0, 10));
        Rect actualRect = null;
        int i7 = 0;
        while (i7 < ranges.size()) {
            if (i7 == 0) {
                actualRect = this.printRange((Range)ranges.elementAt(i7), step31);
            } else {
                this.printRange((Range)ranges.elementAt(i7), step31);
            }
            if (i7 == ranges.size() - 1) {
                Text text2 = this.lang.newText(new Offset(685, 10, actualRect, "SW"), new Float(this.endSubInterval).toString(), "text", null, tpend);
            }
            ++i7;
        }
        this.lang.nextStep();
        int i8 = 0;
        while (i8 < text.length) {
            char tmp = text[i8].charAt(0);
            step32.setText("Aktueller Buchstabe:  " + tmp + " aus " + input + " an Stelle " + (i8 + 1), null, null);
            RectProperties rctpHighlight = new RectProperties();
            rctpHighlight.set("color", Color.BLACK);
            rctpHighlight.set("fillColor", Color.YELLOW);
            rctpHighlight.set("filled", Boolean.TRUE);
            rctpHighlight.set("depth", 2);
            int j = 0;
            while (j < ranges.size()) {
                if (((Range)ranges.elementAt(j)).getLetter() == tmp) {
                    Rect rhigh = this.lang.newRect(rects.elementAt(j).getUpperLeft(), rects.elementAt(j).getLowerRight(), "rect", null, rctpHighlight);
                    rects.elementAt(j).hide();
                    rects = new Vector();
                    break;
                }
                ++j;
            }
            this.lang.nextStep();
            j = 0;
            while (j < ranges.size()) {
                if (tmp == ((Range)ranges.elementAt(j)).getLetter()) {
                    float foo = this.startSubInterval + (this.endSubInterval - this.startSubInterval) * ((Range)ranges.elementAt(j)).getStart();
                    this.endSubInterval = foo + (this.endSubInterval - this.startSubInterval) * (((Range)ranges.elementAt(j)).getEnd() - ((Range)ranges.elementAt(j)).getStart());
                    this.startSubInterval = foo;
                }
                ++j;
            }
            Rect tmpRect = actualRect;
            int k = 0;
            while (k < ranges.size()) {
                if (k == 0) {
                    actualRect = this.printRange((Range)ranges.elementAt(k), actualRect);
                } else {
                    this.printRange((Range)ranges.elementAt(k), tmpRect);
                }
                if (k == ranges.size() - 1) {
                    Text text3 = this.lang.newText(new Offset(685, 10, actualRect, "SW"), new Float(this.endSubInterval).toString(), "text", null, tpend);
                }
                ++k;
            }
            this.lang.nextStep();
            ++i8;
        }
        tpsteps.set("color", Color.BLACK);
        tpsteps.set("font", new Font("SansSerif", 0, 16));
        Text fazit = this.lang.newText(new Offset(0, 50, actualRect, "SW"), "Das letzte Subintervall stellt den Ergebnis-Bereich dar. Um nun die Eingabe zu", "text", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(0, 20, fazit, "SW"), "kodieren, wird eine beliebige Zahl in diesem Intervall gew\u2030hlt, die sich mit", "text2", null, tpsteps);
        Text fazit3 = this.lang.newText(new Offset(0, 20, fazit2, "SW"), "m\u02c6glichst wenigen Bits darstellen l\u2030sst. Beispielsweise: ", "text3", null, tpsteps);
        Text fazit4 = this.lang.newText(new Offset(20, -4, fazit3, "SE"), new Float(this.startSubInterval).toString(), "text3", null, tpsteps);
        fazit4.changeColor(null, Color.BLUE, null, null);
    }

    private Rect printRange(Range r, Primitive prim) {
        int s = new Float(700.0f * r.getStart()).intValue();
        int e = new Float(700.0f * r.getEnd()).intValue();
        RectProperties recIntervalProp = new RectProperties();
        recIntervalProp.set("color", Color.BLACK);
        Rect rect = this.lang.newRect(new Offset(s, 40, prim, "SW"), new Offset(e, 65, prim, "SW"), "rectangle", null, recIntervalProp);
        rects.add(rect);
        tpsteps.set("font", new Font("SansSerif", 0, 10));
        Text t = this.lang.newText(new Offset((e - s) / 2, 20, rect, "M"), "" + r.getLetter(), "text", null, tpsteps);
        Text startNode = this.lang.newText(new Offset(2, 9, rect, "SW"), new Float(this.startSubInterval + r.getStart() * (this.endSubInterval - this.startSubInterval)).toString(), "startValue", null, tpsteps);
        return rect;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        this.compress(strArray);
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }

    @Override
    public String getName() {
        return "Arithmetic Encoding";
    }

    @Override
    public String getAlgorithmName() {
        return "Arithmetic Encoding";
    }

    public static class Range {
        private char letter;
        private float start;
        private float end;
        private float frequency;

        public Range(char letterIn, float startIn, float endIn, float frequencyIn) {
            this.letter = letterIn;
            this.start = startIn;
            this.end = endIn;
            this.frequency = frequencyIn;
        }

        public float getEnd() {
            return this.end;
        }

        public char getLetter() {
            return this.letter;
        }

        public float getStart() {
            return this.start;
        }

        public float getFrequency() {
            return this.frequency;
        }
    }
}

