/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.Text;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.AnimatedIntArrayAlgorithm;
import java.util.Hashtable;
import java.util.Locale;
import translator.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractShellSort
extends AnimatedIntArrayAlgorithm
implements Generator {
    protected Text swapLabel;
    protected Text swapPerf;
    protected Locale contentLocale = null;

    public AbstractShellSort(String resourceName, Locale locale) {
        this.translator = new Translator(resourceName, locale);
        this.primitiveProps = new Hashtable(59);
        this.localType = new GeneratorType(1);
        this.contentLocale = locale;
    }

    @Override
    protected void hideNrStepsArrayCode() {
        super.hideNrStepsArrayCode();
        if (this.array != null) {
            this.array.hide();
        }
    }

    public void sort() {
        ArrayMarker iMarker = null;
        ArrayMarker jMarker = null;
        this.code.highlight("header");
        this.lang.nextStep();
        this.code.toggleHighlight("header", "variables");
        this.lang.nextStep();
        this.code.toggleHighlight("variables", "initDist");
        this.lang.nextStep();
        int dist = 1;
        while (dist < this.array.getLength() / 9) {
            dist = dist * 3 + 1;
        }
        this.code.toggleHighlight("initDist", "loop1");
        this.lang.nextStep();
        while (dist > 0) {
            this.code.toggleHighlight("loop1", "loop2");
            this.lang.nextStep();
            int i = dist;
            while (i < this.array.getLength()) {
                this.array.unhighlightCell(0, this.array.getLength() - 1, null, null);
                int cntr = i;
                while (cntr >= 0) {
                    this.array.highlightCell(cntr, null, null);
                    cntr -= dist;
                }
                if (iMarker == null) {
                    iMarker = this.installArrayMarker("iMarker", this.array, i);
                } else {
                    iMarker.move(i, null, null);
                }
                this.code.toggleHighlight("loop2", "takeOut");
                this.lang.nextStep();
                int v = this.array.getData(i);
                this.incrementNrAssignments();
                this.array.highlightElem(i, null, null);
                this.code.toggleHighlight("takeOut", "setJ");
                this.lang.nextStep();
                int j = i;
                this.code.toggleHighlight("setJ", "loop3");
                this.lang.nextStep();
                while (j >= dist && v < this.array.getData(j - dist)) {
                    this.incrementNrComparisons();
                    if (jMarker == null) {
                        jMarker = this.installArrayMarker("jMarker", this.array, j);
                    } else {
                        jMarker.move(j, null, null);
                    }
                    this.code.toggleHighlight("loop3", "moveForward");
                    this.lang.nextStep();
                    this.array.put(j, this.array.getData(j - dist), null, null);
                    this.incrementNrAssignments();
                    this.code.toggleHighlight("moveForward", "decrementJ");
                    this.lang.nextStep();
                    j -= dist;
                    this.code.toggleHighlight("decrementJ", "loop3");
                    this.lang.nextStep();
                }
                this.code.toggleHighlight("loop3", "insert");
                this.lang.nextStep();
                this.array.put(j, v, null, null);
                this.incrementNrAssignments();
                this.array.unhighlightElem(i, null, null);
                this.code.toggleHighlight("insert", "loop2");
                this.lang.nextStep();
                ++i;
            }
            this.code.toggleHighlight("loop2", "loop1");
            dist /= 3;
        }
        this.code.unhighlight("loop1");
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "array", "code", "code", 0, 20);
        this.sort();
        if (this.swapPerf != null) {
            this.swapPerf.hide();
        }
        if (this.swapLabel != null) {
            this.swapLabel.hide();
        }
        this.wrapUpAnimation();
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Shell Sort";
    }

    @Override
    public Locale getContentLocale() {
        return this.contentLocale;
    }
}

