/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.Text;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.AnimatedIntArrayAlgorithm;
import java.util.Hashtable;
import java.util.Locale;
import translator.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractQuickSort
extends AnimatedIntArrayAlgorithm
implements Generator {
    protected Text swapLabel;
    protected Text swapPerf;
    protected Locale contentLocale = null;
    protected ArrayMarker iMarker = null;
    protected ArrayMarker jMarker = null;

    public AbstractQuickSort(String resourceName, Locale locale) {
        this.translator = new Translator(resourceName, locale);
        this.primitiveProps = new Hashtable(59);
        this.localType = new GeneratorType(1);
        this.contentLocale = locale;
    }

    @Override
    protected void hideNrStepsArrayCode() {
        super.hideNrStepsArrayCode();
        if (this.array != null) {
            this.array.hide();
        }
    }

    public void sort() {
        this.quickSort(0, this.array.getLength() - 1);
    }

    public void quickSort(int l, int r) {
        this.code.highlight("header");
        this.array.highlightCell(l, r, null, null);
        this.lang.nextStep();
        this.code.toggleHighlight("header", "variables");
        this.lang.nextStep();
        this.code.toggleHighlight("variables", "check1");
        this.lang.nextStep();
        if (r > l) {
            this.incrementNrComparisons();
            this.code.toggleHighlight("check1", "setPivot");
            this.lang.nextStep();
            int pivot = this.array.getData(r);
            this.incrementNrAssignments();
            this.code.toggleHighlight("setPivot", "loop");
            this.lang.nextStep();
            this.incrementNrAssignments(2);
            int i = l;
            int j = r - 1;
            while (i < j) {
                if (this.iMarker == null) {
                    this.iMarker = this.installArrayMarker("iMarker", this.array, i);
                } else {
                    this.iMarker.move(i, null, null);
                }
                if (this.jMarker == null) {
                    this.jMarker = this.installArrayMarker("jMarker", this.array, j);
                } else {
                    this.jMarker.move(j, null, null);
                }
                this.incrementNrComparisons();
                this.code.toggleHighlight("loop", "loopI");
                this.lang.nextStep();
                this.incrementNrComparisons(2);
                while (this.array.getData(i) <= pivot && j > i) {
                    this.code.toggleHighlight("loopI", "incrementI");
                    this.lang.nextStep();
                    this.incrementNrAssignments();
                    this.iMarker.move(++i, null, null);
                    this.code.toggleHighlight("incrementI", "loopI");
                    this.lang.nextStep();
                    this.incrementNrComparisons(2);
                }
                this.code.toggleHighlight("loopI", "loopJ");
                this.lang.nextStep();
                this.incrementNrComparisons(2);
                while (pivot < this.array.getData(j) && j > i) {
                    this.code.toggleHighlight("loopJ", "decrementJ");
                    this.lang.nextStep();
                    this.incrementNrAssignments();
                    this.jMarker.move(--j, null, null);
                    this.code.toggleHighlight("decrementJ", "loopJ");
                    this.lang.nextStep();
                    this.incrementNrComparisons(2);
                }
                this.code.toggleHighlight("loopJ", "check2");
                this.lang.nextStep();
                this.incrementNrComparisons();
                if (i < j) {
                    this.code.toggleHighlight("check2", "swapIJ");
                    this.lang.nextStep();
                    this.array.swap(i, j, null, null);
                    this.incrementNrAssignments(2);
                    this.code.toggleHighlight("swapIJ", "loop");
                    this.lang.nextStep();
                    continue;
                }
                this.code.toggleHighlight("check2", "loop");
                this.lang.nextStep();
            }
            this.code.toggleHighlight("loop", "check3");
            this.lang.nextStep();
            this.incrementNrComparisons();
            if (pivot < this.array.getData(i)) {
                this.code.toggleHighlight("check3", "swapIR");
                this.lang.nextStep();
                this.incrementNrAssignments(2);
                this.array.swap(i, r, null, null);
                this.code.toggleHighlight("swapIR", "sortLeft");
                this.lang.nextStep();
            } else {
                this.code.toggleHighlight("check3", "setItoR");
                this.lang.nextStep();
                i = r;
                this.incrementNrAssignments();
                this.code.toggleHighlight("setItoR", "sortLeft");
                this.lang.nextStep();
            }
            this.code.unhighlight("sortLeft");
            this.array.unhighlightCell(l, r, null, null);
            this.quickSort(l, i - 1);
            this.code.highlight("sortRight");
            this.lang.nextStep();
            this.code.unhighlight("sortRight");
            this.quickSort(i + 1, r);
            this.array.highlightCell(l, r, null, null);
        } else {
            this.code.unhighlight("check1");
        }
        this.array.unhighlightCell(l, r, null, null);
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "array", "code", "code", 0, 20);
        this.sort();
        if (this.swapPerf != null) {
            this.swapPerf.hide();
        }
        if (this.swapLabel != null) {
            this.swapLabel.hide();
        }
        this.wrapUpAnimation();
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Quicksort";
    }

    @Override
    public Locale getContentLocale() {
        return this.contentLocale;
    }
}

