/*
 * Decompiled with CFR 0.152.
 */
package generator.properties.tree;

import animalscriptapi.properties.AnimationProperties;
import animalscriptapi.properties.CallMethodProperties;
import javax.swing.tree.DefaultMutableTreeNode;

public class PropertiesTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 4051045280801764915L;
    private transient AnimationProperties prop = null;
    private String name = null;
    private String label = null;
    private Object value = null;
    private int iState = -1;
    private boolean showItems = true;
    private boolean showHiddenItems = true;

    public PropertiesTreeNode(String folderLabel) {
        if (folderLabel == null || folderLabel.length() < 1) {
            return;
        }
        this.iState = 0;
        this.label = folderLabel;
    }

    public PropertiesTreeNode(AnimationProperties p) {
        if (p == null) {
            return;
        }
        this.iState = 1;
        this.setAnimationProperties(p);
    }

    public PropertiesTreeNode(String itemLabel, String itemName) {
        if (itemLabel == null || itemName == null || itemName.length() < 1) {
            return;
        }
        this.iState = 2;
        this.label = itemLabel;
        this.name = itemName;
    }

    public PropertiesTreeNode(String primitiveName, Object primitive) {
        if (primitive == null || primitiveName == null || primitiveName.length() < 1) {
            return;
        }
        this.iState = 3;
        this.name = primitiveName;
        this.value = primitive;
    }

    public AnimationProperties getAnimationProperties() {
        if (this.iState != 1) {
            return null;
        }
        return this.prop;
    }

    private void setAnimationProperties(AnimationProperties p) {
        this.prop = p;
        this.removeAllChildren();
        if (p == null || !this.showItems || p instanceof CallMethodProperties) {
            return;
        }
        for (String itemName : p.getAllPropertyNames()) {
            if (itemName.equals("name")) continue;
            if (this.showHiddenItems) {
                this.add(new PropertiesTreeNode(itemName, itemName));
                continue;
            }
            if (!p.getIsEditable(itemName)) continue;
            this.add(new PropertiesTreeNode(p.getLabel(itemName), itemName));
        }
    }

    public boolean getShowItems() {
        return this.showItems;
    }

    public void setShowItems(boolean b) {
        this.showItems = b;
        if (this.iState == 1) {
            this.setAnimationProperties(this.prop);
        }
    }

    public boolean getShowHiddenItems() {
        return this.showHiddenItems;
    }

    public void setShowHiddenItems(boolean b) {
        this.showHiddenItems = b;
        if (this.iState == 1) {
            this.setAnimationProperties(this.prop);
        }
    }

    public boolean isFolder() {
        return this.iState == 0;
    }

    public boolean isProperty() {
        return this.iState == 1;
    }

    public boolean isItem() {
        return this.iState == 2;
    }

    public boolean isPrimitive() {
        return this.iState == 3;
    }

    public String getName() {
        if (this.iState != 2 && this.iState != 3) {
            return null;
        }
        return this.name;
    }

    public void setName(String newName) {
        if (this.iState != 3 && newName != null && newName.length() > 0) {
            return;
        }
        this.name = newName;
    }

    public String getLabel() {
        if (this.iState != 0 && this.iState != 2) {
            return null;
        }
        return this.label;
    }

    public void setLabel(String newLabel) {
        if (this.iState != 0 && this.iState != 2 && newLabel != null && newLabel.length() > 0) {
            return;
        }
        this.label = newLabel;
    }

    public Object getValue() {
        if (this.iState != 3) {
            return null;
        }
        return this.value;
    }

    public void setValue(Object obj) {
        if (this.iState != 3 && obj != null) {
            return;
        }
        this.value = obj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        switch (this.iState) {
            case 0: {
                sb.append("/").append(this.getName());
                break;
            }
            case 1: {
                sb.append("[P] ").append(this.prop.toString());
                break;
            }
            case 2: {
                sb.append(this.getLabel()).append(" -> ").append(this.getName());
                break;
            }
            case 3: {
                sb.append(this.getName()).append(" -> ").append(this.getValue());
            }
        }
        return sb.toString();
    }
}

