/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.generatorgui;

import components.ColorChooserComboBox;
import components.FontChooserComboBox;
import de.ahrgr.animal.kohnert.asugen.Font;
import de.ahrgr.animal.kohnert.asugen.property.FontProperty;
import de.ahrgr.animal.kohnert.asugen.property.Property;
import de.ahrgr.animal.kohnert.generatorgui.PropertyEdit;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FontPropertyEdit
extends PropertyEdit {
    private static final long serialVersionUID = 1842895057191650052L;
    protected FontProperty property;
    protected JTextField textField;
    protected FontChooserComboBox fontCombo;
    protected ColorChooserComboBox colorCombo;
    protected JComboBox sizeCombo;
    protected JCheckBox boldCheckBox;
    protected JCheckBox italicCheckBox;

    public FontPropertyEdit() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(8, 1));
        p.add((Component)new JLabel("font:"), 0);
        this.fontCombo = new FontChooserComboBox();
        p.add((Component)this.fontCombo, 1);
        p.add((Component)new JLabel("font size:"), 2);
        String[] sizes = new String[]{"0", "6", "8", "12", "16", "20", "22"};
        this.sizeCombo = new JComboBox<String>(sizes);
        p.add((Component)this.sizeCombo, 3);
        this.boldCheckBox = new JCheckBox("bold");
        p.add((Component)this.boldCheckBox, 4);
        this.italicCheckBox = new JCheckBox("italic");
        p.add((Component)this.italicCheckBox, 5);
        p.add((Component)new JLabel("font color:"), 6);
        this.colorCombo = new ColorChooserComboBox();
        p.add((Component)this.colorCombo, 7);
        this.add((Component)p, "North");
        p.validate();
        this.validate();
    }

    public void setProperty(FontProperty p) {
        this.property = p;
        Font f = p.getFont();
        this.fontCombo.setFontSelected(p.getFont().toString());
        this.boldCheckBox.setSelected(f.getIsBold());
        this.italicCheckBox.setSelected(f.getIsItalic());
        this.sizeCombo.setSelectedItem("" + f.getSize());
        this.colorCombo.setColorSelected(p.getColor().toString());
    }

    public Property getProperty() {
        return this.property;
    }

    public void writeProperty() {
        Font f = Font.createFromString(this.fontCombo.getFontSelectedAsString());
        f = f.deriveBold(this.boldCheckBox.isSelected());
        f = f.deriveItalic(this.italicCheckBox.isSelected());
        int size = Integer.parseInt((String)this.sizeCombo.getSelectedItem());
        f = f.deriveSize(size);
        this.property.setFont(f);
        this.property.setColor(this.colorCombo.getColorSelectedAsString());
    }

    public void reloadProperty() {
        this.setProperty(this.property);
    }
}

