/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen;

import de.ahrgr.animal.kohnert.asugen.AbsoluteNode;
import de.ahrgr.animal.kohnert.asugen.AnimalObject;
import de.ahrgr.animal.kohnert.asugen.AnimalScriptWriter;
import de.ahrgr.animal.kohnert.asugen.Node;
import java.util.ArrayList;

public class PolyLine
extends AnimalObject {
    public static final int ARROW_NONE = 0;
    public static final int ARROW_FORWARD = 1;
    public static final int ARROW_BACKWARD = 2;
    protected ArrayList<Node> nodes;
    protected int arrowType = 0;

    public PolyLine(AnimalScriptWriter writer) {
        super(writer);
        this.name = "polyline" + this.instance_index;
        this.nodes = new ArrayList();
    }

    public void addNode(Node node) {
        if (!this.registered) {
            this.nodes.add(node);
        }
    }

    public void addNodeRel(int dx, int dy) {
        if (this.nodes.size() < 1) {
            this.nodes.add(new AbsoluteNode(this.scriptwriter, dx, dy));
        } else {
            Node last = this.nodes.get(this.nodes.size() - 1);
            this.nodes.add(last.createOffset(dx, dy));
        }
    }

    public void setArrow(int arrow_type) {
        if (!this.registered) {
            this.arrowType = arrow_type;
        }
    }

    public void register() {
        super.register();
        if (!this.registered) {
            this.out.print("polyLine \"");
            this.out.print(this.name);
            this.out.print("\"");
            for (Node n : this.nodes) {
                n.print();
            }
            switch (this.arrowType) {
                case 1: {
                    this.out.print(" fwArrow");
                    break;
                }
                case 2: {
                    this.out.print("bwArrow");
                }
            }
            this.printDisplayOptions();
            this.out.println();
            this.registered = true;
        }
    }
}

