/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.IntegerTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class ArrayInputTable
extends JScrollPane {
    public static final char ARRAY_TYPE_INTEGER = '\u0001';
    public static final char ARRAY_TYPE_STRING = '\u0002';
    private static final long serialVersionUID = -6548779207990710834L;
    private JTable myTable;
    private String strLocalHeader = "Element";
    private char arrayType = '\u0001';
    private int iNumberOfElements = 3;

    public ArrayInputTable() {
        this.iNumberOfElements = 3;
        this.arrayType = '\u0001';
        this.init();
    }

    public ArrayInputTable(int numElements) {
        if (numElements < 1) {
            numElements = 3;
        }
        this.iNumberOfElements = numElements;
        this.arrayType = '\u0001';
        this.init();
    }

    public ArrayInputTable(int[] newValues) {
        this.iNumberOfElements = 3;
        this.arrayType = '\u0001';
        this.init();
        this.setValues(newValues);
    }

    public ArrayInputTable(String[] newValues) {
        this.iNumberOfElements = 3;
        this.arrayType = (char)2;
        this.init();
        this.setValues(newValues);
    }

    public void setArrayType(char newArrayType) {
        if (newArrayType != '\u0001' && newArrayType != '\u0002') {
            return;
        }
        if (newArrayType == this.arrayType) {
            return;
        }
        this.arrayType = newArrayType;
        this.init();
    }

    public char getArrayType() {
        return this.arrayType;
    }

    public int[] getIntValues() {
        int[] retval = new int[this.iNumberOfElements];
        int j = 0;
        while (j < this.iNumberOfElements) {
            retval[j] = this.arrayType == '\u0001' ? (Integer)this.myTable.getValueAt(0, j) : 0;
            ++j;
        }
        return retval;
    }

    public void setLocalHeaderString(String strNewLocalHeader) {
        if (strNewLocalHeader == null) {
            return;
        }
        if (this.strLocalHeader.equals(strNewLocalHeader = strNewLocalHeader.trim())) {
            return;
        }
        this.strLocalHeader = strNewLocalHeader;
        int i = 0;
        while (i < this.myTable.getColumnCount()) {
            TableColumn column = this.myTable.getColumnModel().getColumn(i);
            column.setHeaderValue((String.valueOf(strNewLocalHeader) + " " + Integer.toString(i)).trim());
            ++i;
        }
    }

    public String getLocalHeaderString() {
        return this.strLocalHeader;
    }

    public void setNumberOfElements(int numElements) {
        if (numElements < 1) {
            return;
        }
        this.changeDimensions(numElements);
    }

    public int getNumberOfElements() {
        return this.iNumberOfElements;
    }

    public String[] getStringValues() {
        String[] retval = new String[this.iNumberOfElements];
        int j = 0;
        while (j < this.iNumberOfElements) {
            retval[j] = this.arrayType == '\u0002' ? (String)this.myTable.getValueAt(0, j) : "A";
            ++j;
        }
        return retval;
    }

    public void setValues(int[] newValues) {
        if (newValues == null) {
            return;
        }
        int iNewColumns = newValues.length;
        if (iNewColumns == 0) {
            return;
        }
        this.changeDimensions(iNewColumns);
        int j = 0;
        while (j < iNewColumns) {
            if (newValues.length >= j - 1) {
                Integer intObj = new Integer(newValues[j]);
                this.myTable.setValueAt(intObj, 0, j);
            } else {
                this.myTable.setValueAt(new Integer(0), 0, j);
            }
            ++j;
        }
    }

    public void setValues(String[] newValues) {
        if (newValues == null) {
            return;
        }
        int iNewColumns = newValues.length;
        if (iNewColumns == 0) {
            return;
        }
        this.changeDimensions(iNewColumns);
        int j = 0;
        while (j < iNewColumns) {
            if (newValues.length >= j - 1) {
                this.myTable.setValueAt(newValues[j], 0, j);
            } else {
                this.myTable.setValueAt("A", 0, j);
            }
            ++j;
        }
    }

    private void changeDimensions(int numColumns) {
        if (numColumns < 1) {
            return;
        }
        int iOldCols = this.iNumberOfElements;
        Object[] oldData = new Object[numColumns];
        int j = 0;
        while (j < numColumns) {
            oldData[j] = j >= iOldCols ? (this.arrayType == '\u0001' ? new Integer(0) : "A") : this.myTable.getValueAt(0, j);
            ++j;
        }
        this.iNumberOfElements = numColumns;
        this.init();
        j = 0;
        while (j < numColumns) {
            this.myTable.setValueAt(oldData[j], 0, j);
            ++j;
        }
    }

    private void init() {
        int i;
        int j;
        Object[] columnNames = new String[this.iNumberOfElements];
        Object[][] data = new Object[1][this.iNumberOfElements];
        this.myTable = new JTable();
        this.myTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (this.arrayType == '\u0001') {
            data[0] = new Integer[this.iNumberOfElements];
            j = 0;
            while (j < this.iNumberOfElements) {
                columnNames[j] = (String.valueOf(this.strLocalHeader) + " " + Integer.toString(j)).trim();
                data[0][j] = new Integer(0);
                ++j;
            }
            this.myTable.setModel(new IntegerTableModel(data, columnNames));
            i = 0;
            while (i < this.myTable.getColumnCount()) {
                TableColumn column = this.myTable.getColumnModel().getColumn(i);
                IntegerCellEditor editor = new IntegerCellEditor();
                column.setCellEditor(editor);
                ++i;
            }
        } else {
            data[0] = new String[this.iNumberOfElements];
            j = 0;
            while (j < this.iNumberOfElements) {
                columnNames[j] = "Element " + Integer.toString(j);
                data[0][j] = "A";
                ++j;
            }
            this.myTable.setModel(new DefaultTableModel(data, columnNames));
            i = 0;
            while (i < this.myTable.getColumnCount()) {
                TableColumn column = this.myTable.getColumnModel().getColumn(i);
                StringCellEditor editor = new StringCellEditor(new JTextField());
                column.setCellEditor(editor);
                ++i;
            }
        }
        int iNewHeight = (int)this.getHorizontalScrollBar().getPreferredSize().getHeight();
        iNewHeight = (int)((double)iNewHeight + this.myTable.getPreferredSize().getHeight());
        this.setMinimumSize(new Dimension(100, iNewHeight += 24));
        this.setPreferredSize(new Dimension(200, iNewHeight));
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.setAutoResizeMode(0);
        this.setViewportView(this.myTable);
    }

    static class IntegerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -6725001766631532850L;
        private IntegerTextField textField = new IntegerTextField();

        IntegerCellEditor() {
        }

        public Object getCellEditorValue() {
            return this.textField.getValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (table == null || row < 0 || column < 0) {
                return null;
            }
            if (value instanceof Integer && (Integer)value != null) {
                this.textField.setText(((Integer)value).toString());
                this.textField.setDefaultValue((Integer)value);
            } else {
                this.textField.setText("0");
                this.textField.setDefaultValue(new Integer(0));
            }
            if (isSelected || !isSelected) {
                this.textField.setBackground(new Color(255, 255, 128));
            }
            this.textField.setBorder(BorderFactory.createEmptyBorder());
            return this.textField;
        }

        public boolean stopCellEditing() {
            super.stopCellEditing();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 4270055943157017558L;

        public IntegerTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public Class<Integer> getColumnClass(int column) {
            return Integer.class;
        }
    }

    private static class StringCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 8203744556751380673L;
        private JTextField textField = new JTextField();

        public StringCellEditor(JTextField theTextField) {
            super(theTextField);
            this.setClickCountToStart(1);
        }

        public Object getCellEditorValue() {
            if (this.textField.getText().length() == 0) {
                return new String("A");
            }
            return this.textField.getText();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (table == null || row < 0 || column < 0) {
                return null;
            }
            if (value instanceof String && (String)value != null) {
                this.textField.setText((String)value);
            } else {
                this.textField.setText("A");
            }
            if (isSelected || !isSelected) {
                this.textField.setBackground(new Color(255, 255, 128));
            }
            this.textField.setBorder(BorderFactory.createEmptyBorder());
            return this.textField;
        }

        public boolean stopCellEditing() {
            super.stopCellEditing();
            return true;
        }
    }
}

