/*
 * Decompiled with CFR 0.152.
 */
package avinteraction;

import avinteraction.InteractionModule;
import avinteraction.QuestionInterface;
import java.awt.Color;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class Question
extends JPanel
implements QuestionInterface {
    public static int questionCounter = 0;
    protected InteractionModule handler;
    protected JButton submitButton;
    protected JEditorPane feedbackView;
    protected JPanel mainPanel;
    protected JScrollPane feedbackScroller;
    protected JTextArea questionOutput;
    protected String feedbackText;
    protected String groupID;
    protected String objectID;
    protected String questionText;
    protected boolean correct = false;
    protected boolean guiBuilt = false;
    protected int achievedPoints;
    protected int points;
    protected int questionNumber = questionCounter++;

    Question() {
        this.feedbackView = new JEditorPane("text/html", "");
        this.feedbackView.setEditable(false);
        this.feedbackScroller = new JScrollPane(this.feedbackView, 20, 30);
        this.feedbackText = "";
    }

    public abstract String getComment();

    public abstract void makeGUI();

    public abstract void rebuildQuestion();

    public int getAchievedPoints() {
        return this.achievedPoints;
    }

    public boolean isCorrect() {
        return this.correct;
    }

    public void setFeedback(String feedback) {
        this.feedbackText = feedback;
        this.feedbackView.setText(InteractionModule.translateMessage("feedbackTemplate", new String[]{feedback}));
    }

    public void setFeedbackBlack() {
        this.feedbackView.setForeground(Color.BLACK);
    }

    public void setFeedbackRed() {
        this.feedbackView.setForeground(Color.RED);
    }

    public String getGroupID() {
        return this.groupID;
    }

    public boolean getGuiBuilt() {
        return this.guiBuilt;
    }

    public void setPoints(int pts) {
        this.points = pts;
    }

    public int getPoints() {
        return this.points;
    }

    public void setQuestion(String question) {
        this.questionText = question;
    }

    public void enableSubmit() {
        this.submitButton.setEnabled(true);
    }

    public boolean wasSubmitted() {
        return !this.submitButton.isEnabled();
    }

    protected void setHandler(InteractionModule module) {
        this.handler = module;
    }
}

