/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.primitives.MatrixPrimitive;
import animalscriptapi.primitives.generators.IntMatrixGenerator;
import animalscriptapi.properties.MatrixProperties;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;

public class IntMatrix
extends MatrixPrimitive {
    private int[][] data;
    protected IntMatrixGenerator generator;
    private MatrixProperties properties = null;
    private Node upperLeft = null;

    public IntMatrix(IntMatrixGenerator iag, Node upperLeftCorner, int[][] matrixData, String name, DisplayOptions display, MatrixProperties iap) {
        super(iag, display);
        if (upperLeftCorner == null) {
            throw new IllegalArgumentException("The coordinate of the upper left Node shouldn't be null!");
        }
        if (matrixData == null) {
            throw new IllegalArgumentException("Null matrix passed in to IntMatrix, named " + name);
        }
        this.upperLeft = upperLeftCorner;
        if (matrixData != null) {
            this.nrRows = matrixData.length;
            if (matrixData[0] != null) {
                this.nrCols = matrixData[0].length;
            }
        }
        this.data = matrixData;
        this.properties = iap;
        this.setName(name);
        this.generator = iag;
        this.generator.create(this);
    }

    private boolean checkForValidPosition(int row, int col, String methodName) {
        if (row < this.data.length && row >= 0 && col < this.getNrCols() && col >= 0) {
            return true;
        }
        StringBuilder sb = new StringBuilder("Invalid position [");
        sb.append(row).append("][").append(col).append("] in method ");
        sb.append(methodName).append(" of class IntMatrix");
        throw new IllegalArgumentException(sb.toString());
    }

    public int getElement(int row, int col) {
        if (this.checkForValidPosition(row, col, "getElement[" + row + "][" + col + "]")) {
            return this.data[row][col];
        }
        return 0;
    }

    public void put(int row, int col, int what, Timing t, Timing d) throws IndexOutOfBoundsException {
        if (this.checkForValidPosition(row, col, "put")) {
            this.data[row][col] = what;
            this.generator.put(this, row, col, what, t, d);
        }
    }

    public void swap(int sourceRow, int sourceCol, int targetRow, int targetCol, Timing t, Timing d) throws IndexOutOfBoundsException {
        if (this.checkForValidPosition(sourceRow, sourceCol, "swap param 1") && this.checkForValidPosition(targetRow, targetCol, "swap param 2")) {
            int tmp = this.data[sourceRow][sourceCol];
            this.data[sourceRow][sourceCol] = this.data[targetRow][targetCol];
            this.data[targetRow][targetCol] = tmp;
            this.generator.swap(this, sourceRow, sourceCol, targetRow, targetCol, t, d);
        }
    }

    public int[][] getData() {
        return this.data;
    }

    public int[] getRow(int row) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.getNrRows()) {
            throw new IndexOutOfBoundsException("Matrix has only row indices [0, " + (this.getNrRows() - 1) + ", but " + row + " was requested");
        }
        return this.data[row];
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    public MatrixProperties getProperties() {
        return this.properties;
    }

    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }

    public void highlightCell(int row, int col, Timing offset, Timing duration) {
        if (this.checkForValidPosition(row, col, "highlightCell")) {
            this.generator.highlightCell(this, row, col, offset, duration);
        }
    }

    public void highlightCellColumnRange(int row, int startCol, int endCol, Timing offset, Timing duration) {
        if (this.checkForValidPosition(row, startCol, "highlightCellColumnRange param 1") && this.checkForValidPosition(row, endCol, "highlightCellColumnRange param 2")) {
            this.generator.highlightCellColumnRange(this, row, startCol, endCol, offset, duration);
        }
    }

    public void highlightCellRowRange(int startRow, int endRow, int col, Timing offset, Timing duration) {
        if (this.checkForValidPosition(startRow, col, "highlightCellRowRange param 1") && this.checkForValidPosition(endRow, col, "highlightCellRowRange param 2")) {
            this.generator.highlightCellRowRange(this, startRow, endRow, col, offset, duration);
        }
    }

    public void unhighlightCell(int row, int col, Timing offset, Timing duration) {
        if (this.checkForValidPosition(row, col, "unhighlightCell")) {
            this.generator.unhighlightCell(this, row, col, offset, duration);
        }
    }

    public void unhighlightCellColumnRange(int row, int startCol, int endCol, Timing offset, Timing duration) {
        if (this.checkForValidPosition(row, startCol, "unhighlightCellColumnRange param 1") && this.checkForValidPosition(row, endCol, "unhighlightCellColumnRange param 2")) {
            this.generator.unhighlightCellColumnRange(this, row, startCol, endCol, offset, duration);
        }
    }

    public void unhighlightCellRowRange(int startRow, int endRow, int col, Timing offset, Timing duration) {
        if (this.checkForValidPosition(startRow, col, "unhighlightCellRowRange param 1") && this.checkForValidPosition(endRow, col, "unhighlightCellRowRange param 2")) {
            this.generator.unhighlightCellRowRange(this, startRow, endRow, col, offset, duration);
        }
    }

    public void highlightElem(int row, int col, Timing offset, Timing duration) {
        if (this.checkForValidPosition(row, col, "highlightElem")) {
            this.generator.highlightElem(this, row, col, offset, duration);
        }
    }

    public void highlightElemColumnRange(int row, int startCol, int endCol, Timing offset, Timing duration) {
        if (this.checkForValidPosition(row, startCol, "highlightElemColumnRange param 1") && this.checkForValidPosition(row, endCol, "highlightElemColumnRange param 2")) {
            this.generator.highlightElemColumnRange(this, row, startCol, endCol, offset, duration);
        }
    }

    public void highlightElemRowRange(int startRow, int endRow, int col, Timing offset, Timing duration) {
        if (this.checkForValidPosition(startRow, col, "highlightElemRowRange param 1") && this.checkForValidPosition(endRow, col, "highlightElemRowRange param 2")) {
            this.generator.highlightElemRowRange(this, startRow, endRow, col, offset, duration);
        }
    }

    public void unhighlightElem(int row, int col, Timing offset, Timing duration) {
        if (this.checkForValidPosition(row, col, "unhighlightElement")) {
            this.generator.unhighlightElem(this, row, col, offset, duration);
        }
    }

    public void unhighlightElemColumnRange(int row, int startCol, int endCol, Timing offset, Timing duration) {
        if (this.checkForValidPosition(row, startCol, "unhighlightElemColumnRange param 1") && this.checkForValidPosition(row, endCol, "unhighlightElemColumnRange param 2")) {
            this.generator.unhighlightElemColumnRange(this, row, startCol, endCol, offset, duration);
        }
    }

    public void unhighlightElemRowRange(int startRow, int endRow, int col, Timing offset, Timing duration) {
        if (this.checkForValidPosition(startRow, col, "unhighlightElemRowRange param 1") && this.checkForValidPosition(endRow, col, "unhighlightElemRowRange param 2")) {
            this.generator.unhighlightElemRowRange(this, startRow, endRow, col, offset, duration);
        }
    }
}

