/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.interactionsupport;

import animalscriptapi.interactionsupport.InteractiveQuestion;
import animalscriptapi.primitives.generators.Language;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleChoiceQuestion
extends InteractiveQuestion {
    public static final String INVALID_OPTION = "INVALID";
    protected int numberOfAnswerOptions = 0;
    protected String idOfCorrectAnswer = "INVALID";
    protected HashMap<String, String> answerOptions = new HashMap(11);
    protected HashMap<String, Integer> pointsForAnswer = new HashMap(11);

    public MultipleChoiceQuestion(Language lang, String id) {
        super(lang, id);
    }

    public String addAnswerOption(String option) {
        if (option != null && option.length() > 0) {
            String id = String.valueOf(++this.numberOfAnswerOptions);
            this.answerOptions.put(id, option);
            return id;
        }
        return INVALID_OPTION;
    }

    public String addAnswerOption(String option, boolean isCorrect, String feedbackString, int points) {
        String id = this.addAnswerOption(option);
        if (isCorrect) {
            this.setCorrectAnswerID(id);
        }
        this.setFeedbackForAnswerOption(id, feedbackString);
        this.setPointsForAnswer(id, points);
        return id;
    }

    public Set<String> getAnswerSet() {
        return this.answerOptions.keySet();
    }

    public String getAnswerString(String questionID) {
        return this.answerOptions.get(questionID);
    }

    public String getCorrectAnswerID() {
        return this.idOfCorrectAnswer;
    }

    public String getFeedbackForOption(String id) {
        return (String)this.feedback.get(id);
    }

    public int getPointsForOption(String id) {
        Integer nrPoints = this.pointsForAnswer.get(id);
        if (nrPoints != null) {
            return nrPoints;
        }
        return 0;
    }

    public void setCorrectAnswerID(String id) {
        if (this.answerOptions.containsKey(id)) {
            this.idOfCorrectAnswer = id;
            int pp = this.getPointsPossible();
            if (pp == 0) {
                pp = 1;
            }
            if (!this.pointsForAnswer.containsKey(id)) {
                this.pointsForAnswer.put(id, pp);
            }
        } else {
            throw new NoSuchElementException("There is no answer with ID " + id);
        }
    }

    public void setFeedbackForAnswerOption(String id, String feedbackString) {
        this.feedback.put(id, feedbackString);
    }

    public void setPointsForAnswer(String id, int points) {
        this.pointsForAnswer.put(id, points);
        if (points > this.pointsPossible) {
            this.pointsPossible = points;
        }
    }
}

