/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.examples;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.ConceptualStack;
import animalscriptapi.primitives.IntArray;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.properties.ArrayProperties;
import animalscriptapi.properties.SourceCodeProperties;
import animalscriptapi.properties.StackProperties;
import animalscriptapi.util.Coordinates;
import java.awt.Color;
import java.awt.Font;

public class StackQuickSort {
    private Language lang;
    ConceptualStack<String> cs;
    private static final String DESCRIPTION = "QuickSort w\u2030hlt ein Element aus der zu sortierenden Liste aus (Pivotelement) und zerlegt die Liste in zwei Teillisten, eine untere, die alle Elemente kleiner und eine obere, die alle Elemente gleich oder gr\u02c6\ufb02er dem Pivotelement enth\u2030lt.\nDazu wird zun\u2030chst ein Element von unten gesucht, das gr\u02c6\ufb02er als (oder gleichgro\ufb02 wie) das Pivotelement und damit f\u00b8r die untere Liste zu gro\ufb02 ist. Entsprechend wird von oben ein kleineres Element als das Pivotelement gesucht. Die beiden Elemente werden dann vertauscht und landen damit in der jeweils richtigen Liste.\nDer Vorgang wird fortgesetzt, bis sich die untere und obere Suche treffen. Damit sind die oben erw\u2030hnten Teillisten in einem einzigen Durchlauf entstanden. Suche und Vertauschung k\u02c6nnen in-place durchgef\u00b8hrt werden.\n\nDie noch unsortierten Teillisten werden \u00b8ber denselben Algorithmus in noch kleinere Teillisten zerlegt (z. B. mittels Rekursion) und, sobald nur noch Listen mit je einem Element vorhanden sind, wieder zusammengesetzt. Die Sortierung ist damit abgeschlossen.";
    private static final String SOURCE_CODE = "public void quickSort(int[] array, int l, int r)\n{\n  int i, j, pivot;\n  if (r>l)\n  {\n    pivot = array[r];\n    for (i = l; j = r - 1; i < j; )\n    {\n      while (array[i] <= pivot && j > i)\n        i++;\n      while (pivot < array[j] && j > i)\n        j--;\n      if (i < j)\n        swap(array, i, j);\n    }\n    if (pivot < array[i])\n      swap(array, i, r);\n    else\n      i=r;\n    quickSort(array, l, i - 1);\n    quickSort(array, i + 1, r);\n  }\n}";
    private int pointerCounter = 0;

    public StackQuickSort(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void sort(int[] a) {
        ArrayProperties arrayProps = new ArrayProperties();
        arrayProps.set("color", Color.BLACK);
        arrayProps.set("fillColor", Color.WHITE);
        arrayProps.set("filled", Boolean.TRUE);
        arrayProps.set("elementColor", Color.BLACK);
        arrayProps.set("elemHighlight", Color.RED);
        arrayProps.set("cellHighlight", Color.YELLOW);
        IntArray ia = this.lang.newIntArray(new Coordinates(20, 100), a, "intArray", null, arrayProps);
        this.lang.nextStep();
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font("Monospaced", 0, 12));
        scProps.set("highlightColor", Color.RED);
        scProps.set("color", Color.BLACK);
        SourceCode sc = this.lang.newSourceCode(new Coordinates(40, 140), "sourceCode", null, scProps);
        sc.addCodeLine("public void quickSort(int[] array, int l, int r)", null, 0, null);
        sc.addCodeLine("{", null, 0, null);
        sc.addCodeLine("int i, j, pivot;", null, 1, null);
        sc.addCodeLine("if (r>l)", null, 1, null);
        sc.addCodeLine("{", null, 1, null);
        sc.addCodeLine("pivot = array[r];", null, 2, null);
        sc.addCodeLine("for (i = l; j = r - 1; i < j; )", null, 2, null);
        sc.addCodeLine("{", null, 2, null);
        sc.addCodeLine("while (array[i] <= pivot && j > i)", null, 3, null);
        sc.addCodeLine("i++;", null, 4, null);
        sc.addCodeLine("while (pivot < array[j] && j > i)", null, 3, null);
        sc.addCodeLine("j--;", null, 4, null);
        sc.addCodeLine("if (i < j)", null, 3, null);
        sc.addCodeLine("swap(array, i, j);", null, 4, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("if (pivot < array[i])", null, 2, null);
        sc.addCodeLine("swap(array, i, r);", null, 3, null);
        sc.addCodeLine("else", null, 2, null);
        sc.addCodeLine("i=r;", null, 3, null);
        sc.addCodeLine(" quickSort(array, l, i - 1);", null, 2, null);
        sc.addCodeLine(" quickSort(array, i + 1, r);", null, 2, null);
        sc.addCodeLine(" }", null, 1, null);
        sc.addCodeLine("}", null, 0, null);
        this.lang.nextStep();
        StackProperties sp = new StackProperties();
        sp.set("color", Color.BLUE);
        sp.set("dividingLineColor", Color.ORANGE);
        sp.set("cellHighlight", Color.YELLOW);
        sp.set("alternateFilled", true);
        sp.set("alternateFillColor", Color.GREEN);
        sp.set("elemHighlight", Color.RED);
        this.cs = this.lang.newConceptualStack(new Coordinates(400, 160), null, "CStack", null, sp);
        this.lang.nextStep();
        ia.highlightCell(0, ia.getLength() - 1, null, null);
        try {
            this.cs.push("quicksort(0, " + (ia.getLength() - 1) + ")", null, null);
            this.lang.nextStep();
            this.quickSort(ia, sc, 0, ia.getLength() - 1);
            this.cs.pop(null, null);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
    }

    private void quickSort(IntArray array, SourceCode codeSupport, int l, int r) throws LineNotExistsException {
        codeSupport.highlight(0, 0, false);
        this.lang.nextStep();
        codeSupport.toggleHighlight(0, 0, false, 2, 0);
        ++this.pointerCounter;
        ArrayMarkerProperties arrayIMProps = new ArrayMarkerProperties();
        arrayIMProps.set("label", "i");
        arrayIMProps.set("color", Color.BLACK);
        ArrayMarker iMarker = this.lang.newArrayMarker(array, 0, "i" + this.pointerCounter, null, arrayIMProps);
        ++this.pointerCounter;
        ArrayMarkerProperties arrayJMProps = new ArrayMarkerProperties();
        arrayJMProps.set("label", "j");
        arrayJMProps.set("color", Color.BLACK);
        ArrayMarker jMarker = this.lang.newArrayMarker(array, 0, "j" + this.pointerCounter, null, arrayJMProps);
        this.lang.nextStep();
        codeSupport.toggleHighlight(2, 0, false, 3, 0);
        ++this.pointerCounter;
        ArrayMarkerProperties arrayPMProps = new ArrayMarkerProperties();
        arrayPMProps.set("label", "pivot");
        arrayPMProps.set("color", Color.BLUE);
        ArrayMarker pivotMarker = this.lang.newArrayMarker(array, 0, "pivot" + this.pointerCounter, null, arrayPMProps);
        this.lang.nextStep();
        codeSupport.unhighlight(3, 0, false);
        if (r > l) {
            this.lang.nextStep();
            codeSupport.highlight(5, 0, false);
            int pivot = array.getData()[r];
            pivotMarker.move(r, null, null);
            this.lang.nextStep();
            codeSupport.unhighlight(5, 0, false);
            int i = l;
            int j = r - 1;
            while (i < j) {
                codeSupport.highlight(6, 0, false);
                iMarker.move(i, null, null);
                jMarker.move(j, null, null);
                this.lang.nextStep();
                codeSupport.toggleHighlight(6, 0, false, 8, 0);
                while (array.getData()[i] <= pivot && j > i) {
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(8, 0, false, 9, 0);
                    iMarker.move(++i, null, null);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(9, 0, false, 8, 0);
                }
                this.lang.nextStep();
                codeSupport.toggleHighlight(8, 0, false, 10, 0);
                while (pivot < array.getData()[j] && j > i) {
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(10, 0, false, 11, 0);
                    jMarker.move(--j, null, null);
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(11, 0, false, 10, 0);
                }
                this.lang.nextStep();
                codeSupport.toggleHighlight(10, 0, false, 12, 0);
                if (i < j) {
                    this.lang.nextStep();
                    codeSupport.toggleHighlight(12, 0, false, 13, 0);
                    array.swap(i, j, null, null);
                }
                this.lang.nextStep();
                codeSupport.toggleHighlight(13, 0, false, 12, 0);
            }
            codeSupport.toggleHighlight(6, 0, false, 13, 0);
            this.lang.nextStep();
            if (pivot < array.getData()[i]) {
                codeSupport.toggleHighlight(15, 0, false, 16, 0);
                array.swap(i, r, null, null);
                pivotMarker.move(i, null, null);
                this.lang.nextStep();
                codeSupport.unhighlight(16, 0, false);
            } else {
                i = r;
                codeSupport.toggleHighlight(15, 0, false, 18, 0);
                iMarker.move(r, null, null);
                this.lang.nextStep();
                codeSupport.unhighlight(18, 0, false);
            }
            array.highlightElem(i, null, null);
            this.lang.nextStep();
            codeSupport.highlight(19, 0, false);
            this.lang.nextStep();
            codeSupport.unhighlight(19, 0, false);
            array.unhighlightCell(i, r, null, null);
            this.cs.push("quicksort(" + l + ", " + (i - 1) + ")", null, null);
            this.quickSort(array, codeSupport, l, i - 1);
            this.cs.pop(null, null);
            this.lang.nextStep();
            array.highlightCell(l, r, null, null);
            codeSupport.highlight(20, 0, false);
            this.lang.nextStep();
            codeSupport.unhighlight(20, 0, false);
            array.unhighlightCell(l, i, null, null);
            this.cs.push("quicksort(" + (i + 1) + ", " + r + ")", null, null);
            this.quickSort(array, codeSupport, i + 1, r);
            this.cs.pop(null, null);
        }
        this.lang.nextStep();
        codeSupport.highlight(21, 0, false);
        this.lang.nextStep();
        codeSupport.highlight(22, 0, false);
        this.lang.nextStep();
        array.unhighlightCell(l, r, null, null);
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Quicksort (pivot=last)";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public static void main(String[] args) {
        AnimalScript l = new AnimalScript("Quicksort Animation with Stack", "Dima Vronskyi", 640, 480);
        StackQuickSort s = new StackQuickSort(l);
        int[] a = new int[]{7, 3, 2, 4, 1, 13, 52, 13, 5, 1};
        s.sort(a);
        System.out.println(l);
    }
}

