/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.interactionsupport.DocumentationLink;
import animalscriptapi.interactionsupport.InteractiveElement;
import animalscriptapi.interactionsupport.MultipleChoiceQuestion;
import animalscriptapi.interactionsupport.MultipleSelectionQuestion;
import animalscriptapi.interactionsupport.TrueFalseQuestion;
import animalscriptapi.interactionsupport.generators.InteractiveElementGenerator;
import java.util.Set;

public class AnimalJHAVETextInteractionGenerator
extends AnimalGenerator
implements InteractiveElementGenerator {
    private boolean startQuestionsPlaced = false;

    public AnimalJHAVETextInteractionGenerator(AnimalScript as) {
        super(as);
    }

    public void createTFQuestion(TrueFalseQuestion q) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("TFQUESTION \"").append(q.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createInteractiveElementCode(InteractiveElement element) {
        if (!this.startQuestionsPlaced) {
            this.lang.addLine("STARTQUESTIONS");
            this.startQuestionsPlaced = true;
        }
        if (element instanceof TrueFalseQuestion) {
            this.createTFQuestionCode((TrueFalseQuestion)element);
        } else if (element instanceof MultipleChoiceQuestion) {
            this.createMCQuestionCode((MultipleChoiceQuestion)element);
        } else if (element instanceof MultipleSelectionQuestion) {
            this.createMSQuestionCode((MultipleSelectionQuestion)element);
        }
    }

    public void createTFQuestionCode(TrueFalseQuestion tfQuestion) {
        StringBuilder sb = new StringBuilder(255);
        sb.append("TFQUESTION \"").append(tfQuestion.getID());
        sb.append("\"\n\"").append(tfQuestion.getPrompt());
        sb.append("\"\nENDTEXT\nANSWER\n");
        sb.append(tfQuestion.getAnswerStatus() ? "T" : "F");
        sb.append("\nENDANSWER");
        this.lang.addLine(sb);
    }

    public void createMCQuestionCode(MultipleChoiceQuestion mcQuestion) {
        StringBuilder sb = new StringBuilder(255);
        sb.append("MCQUESTION \"").append(mcQuestion.getID());
        sb.append("\"\n\"").append(mcQuestion.getPrompt());
        sb.append("\"\nENDTEXT\n");
        Set<String> answerKeys = mcQuestion.getAnswerSet();
        for (String key : answerKeys) {
            String prompt = mcQuestion.getAnswerString(key);
            if (prompt == null) continue;
            sb.append("\"").append(prompt).append("\"\nENDCHOICE\n");
        }
        sb.append("ANSWER\n").append(mcQuestion.getCorrectAnswerID());
        sb.append("\nENDANSWER");
        this.lang.addLine(sb);
    }

    public void createMSQuestionCode(MultipleSelectionQuestion msQuestion) {
        StringBuilder sb = new StringBuilder(255);
        sb.append("MSQUESTION \"").append(msQuestion.getID());
        sb.append("\"\n\"").append(msQuestion.getPrompt());
        sb.append("\"\nENDTEXT\n");
        Set<String> answerKeys = msQuestion.getAnswerSet();
        for (String key : answerKeys) {
            String prompt = msQuestion.getAnswerString(key);
            if (prompt == null) continue;
            sb.append("\"").append(prompt).append("\"\nENDCHOICE\n");
            sb.append("ANSWER\n").append(msQuestion.getCorrectnessStatus(key)).append("\n");
        }
        sb.append("ENDANSWER");
        this.lang.addLine(sb);
    }

    public void createDocumentationLink(DocumentationLink docuLink) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("DOCUMENTATION \"").append(docuLink.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createMCQuestion(MultipleChoiceQuestion mcQuestion) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("MCQUESTION \"").append(mcQuestion.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createMSQuestion(MultipleSelectionQuestion msQuestion) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("MCQUESTION \"").append(msQuestion.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void finalizeInteractiveElements() {
    }
}

