/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.IntMatrix;
import animalscriptapi.primitives.generators.IntMatrixGenerator;
import animalscriptapi.properties.MatrixProperties;
import animalscriptapi.util.Timing;
import java.awt.Color;

public class AnimalIntMatrixGenerator
extends AnimalGenerator
implements IntMatrixGenerator {
    private static int count = 1;

    public AnimalIntMatrixGenerator(AnimalScript as) {
        super(as);
    }

    public void create(IntMatrix aMatrix) {
        if (this.isNameUsed(aMatrix.getName()) || aMatrix.getName().equals("")) {
            aMatrix.setName("IntMatrix" + count);
            ++count;
        }
        this.lang.addItem(aMatrix);
        this.lang.nextStep();
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("grid \"").append(aMatrix.getName()).append("\" ");
        def.append(AnimalGenerator.makeNodeDef(aMatrix.getUpperLeft()));
        int nrRows = aMatrix.getNrRows();
        int nrCols = aMatrix.getNrCols();
        def.append(" lines ").append(nrRows).append(" columns ");
        def.append(nrCols).append(' ');
        MatrixProperties matrixProps = aMatrix.getProperties();
        if (matrixProps.get("color") != null) {
            def.append("color ");
            def.append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("color")).getRed(), ((Color)matrixProps.get("color")).getGreen(), ((Color)matrixProps.get("color")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("elementColor") != null) {
            def.append("textColor ").append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("elementColor")).getRed(), ((Color)matrixProps.get("elementColor")).getGreen(), ((Color)matrixProps.get("elementColor")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("fillColor") != null) {
            def.append("fillColor ").append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("fillColor")).getRed(), ((Color)matrixProps.get("fillColor")).getGreen(), ((Color)matrixProps.get("fillColor")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("elemHighlight") != null) {
            def.append("highlightTextColor ");
            def.append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("elemHighlight")).getRed(), ((Color)matrixProps.get("elemHighlight")).getGreen(), ((Color)matrixProps.get("elemHighlight")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("cellHighlight") != null) {
            def.append("highlightBackColor ");
            def.append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("cellHighlight")).getRed(), ((Color)matrixProps.get("cellHighlight")).getGreen(), ((Color)matrixProps.get("cellHighlight")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("depth") != null) {
            def.append("depth ");
            def.append(matrixProps.get("depth"));
            def.append(" ");
        }
        this.lang.addLine(def);
        int row = 0;
        while (row < nrRows) {
            int col = 0;
            while (col < nrCols) {
                StringBuilder sb = new StringBuilder(128);
                sb.append("setGridValue \"").append(aMatrix.getName());
                sb.append("[").append(row).append("][").append(col);
                sb.append("]\" \"").append(aMatrix.getElement(row, col));
                sb.append("\"");
                if (row == nrRows - 1 && col == nrCols - 1) {
                    sb.append(" refresh");
                }
                this.lang.addLine(sb.toString());
                ++col;
            }
            ++row;
        }
    }

    private void finishDefinition(StringBuilder sb, Timing delay, Timing duration) {
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay));
        this.lang.addLine(sb.toString());
    }

    public void put(IntMatrix intMatrix, int row, int col, int what, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("setGridValue \"").append(intMatrix.getName()).append("[");
        sb.append(row).append("][").append(col).append("]\" \"");
        sb.append(what).append("\" refresh ");
        this.finishDefinition(sb, delay, duration);
    }

    public void swap(IntMatrix intMatrix, int sourceRow, int sourceCol, int targetRow, int targetCol, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("swapGridValues \"").append(intMatrix.getName()).append("[");
        sb.append(sourceRow).append("][").append(sourceCol);
        sb.append("]\" and \"").append(intMatrix.getName()).append("[");
        sb.append(targetRow).append("][").append(targetCol).append("]\" refresh ");
        this.finishDefinition(sb, delay, duration);
    }

    public void highlightCell(IntMatrix intMatrix, int row, int col, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("highlightGridCell \"").append(intMatrix.getName());
        sb.append("[").append(row).append("][").append(col).append("]\" ");
        this.finishDefinition(sb, offset, duration);
    }

    public void highlightCellColumnRange(IntMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        if (startCol == 0 && endCol == intMatrix.getNrCols() - 1) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("highlightGridCell \"").append(intMatrix.getName());
            sb.append("[").append(row).append("][]\" ");
            this.finishDefinition(sb, offset, duration);
        } else {
            int col = startCol;
            while (col <= endCol) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("highlightGridCell \"").append(intMatrix.getName());
                sb.append("[").append(row).append("][").append(col).append("]\" ");
                this.finishDefinition(sb, offset, duration);
                ++col;
            }
        }
    }

    public void highlightCellRowRange(IntMatrix intMatrix, int startRow, int endRow, int col, Timing offset, Timing duration) {
        if (startRow == 0 && endRow == intMatrix.getNrRows() - 1) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("highlightGridCell \"").append(intMatrix.getName());
            sb.append("[][").append(col).append("]\" ");
            this.finishDefinition(sb, offset, duration);
        } else {
            int row = startRow;
            while (row <= endRow) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("highlightGridCell \"").append(intMatrix.getName());
                sb.append("[").append(row).append("][").append(col).append("]\" ");
                this.finishDefinition(sb, offset, duration);
                ++row;
            }
        }
    }

    public void highlightElem(IntMatrix intMatrix, int row, int col, Timing offset, Timing duration) {
        this.highlightCell(intMatrix, row, col, offset, duration);
    }

    public void highlightElemColumnRange(IntMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        this.highlightCellColumnRange(intMatrix, row, startCol, endCol, offset, duration);
    }

    public void highlightElemRowRange(IntMatrix intMatrix, int startRow, int endRow, int col, Timing offset, Timing duration) {
        this.highlightCellColumnRange(intMatrix, startRow, endRow, col, offset, duration);
    }

    public void unhighlightCell(IntMatrix intMatrix, int row, int col, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("unhighlightGridCell \"").append(intMatrix.getName());
        sb.append("[").append(row).append("][").append(col).append("]\" ");
        this.finishDefinition(sb, offset, duration);
    }

    public void unhighlightCellColumnRange(IntMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        if (startCol == 0 && endCol == intMatrix.getNrCols() - 1) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("unhighlightGridCell \"").append(intMatrix.getName());
            sb.append("[").append(row).append("][]\" ");
            this.finishDefinition(sb, offset, duration);
        } else {
            int col = startCol;
            while (col <= endCol) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("unhighlightGridCell \"").append(intMatrix.getName());
                sb.append("[").append(row).append("][").append(col).append("]\" ");
                this.finishDefinition(sb, offset, duration);
                ++col;
            }
        }
    }

    public void unhighlightCellRowRange(IntMatrix intMatrix, int startRow, int endRow, int col, Timing offset, Timing duration) {
        if (startRow == 0 && endRow == intMatrix.getNrRows() - 1) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("unhighlightGridCell \"").append(intMatrix.getName());
            sb.append("[][").append(col).append("]\" ");
            this.finishDefinition(sb, offset, duration);
        } else {
            int row = startRow;
            while (row <= endRow) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("unhighlightGridCell \"").append(intMatrix.getName());
                sb.append("[").append(row).append("][").append(col).append("]");
                this.finishDefinition(sb, offset, duration);
                ++row;
            }
        }
    }

    public void unhighlightElem(IntMatrix intMatrix, int row, int col, Timing offset, Timing duration) {
        this.unhighlightCell(intMatrix, row, col, offset, duration);
    }

    public void unhighlightElemColumnRange(IntMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        this.unhighlightCellColumnRange(intMatrix, row, startCol, endCol, offset, duration);
    }

    public void unhighlightElemRowRange(IntMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        this.unhighlightCellRowRange(intMatrix, row, startCol, endCol, offset, duration);
    }
}

