/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animal.main.Animal;
import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.primitives.ConceptualQueue;
import animalscriptapi.primitives.Group;
import animalscriptapi.primitives.Polyline;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.ConceptualQueueGenerator;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.PolylineProperties;
import animalscriptapi.properties.RectProperties;
import animalscriptapi.properties.TextProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Hidden;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;
import java.awt.Color;
import java.awt.Font;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimalConceptualQueueGenerator<T>
extends AnimalGenerator
implements ConceptualQueueGenerator<T> {
    private static int count = 1;
    private Node upperLeft;
    private LinkedList<Primitive> rectangles;
    private LinkedList<Primitive> texts;
    private TextProperties tp;
    private RectProperties rp;
    private int tailX = -1;
    private int ulx;
    private int uly;
    private int fontSize;
    private int heightOffset;
    private Text tailText;
    private Text frontText;
    private Rect tailRect;
    private Rect frontRect;
    private Group rectanglesToMove;
    private Group textsToMove;
    private Polyline pLine;
    private Object fontObject;
    private boolean hidden;
    private boolean hiddenProp;
    private boolean hiddenPLine;
    private boolean highlightedTailRect;
    private boolean highlightedTailText;
    private boolean alternateFilled;
    private boolean odd;
    private final int widthOffset = 2;

    public AnimalConceptualQueueGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(ConceptualQueue<T> cq) {
        if (this.isNameUsed(cq.getName()) || cq.getName() == "") {
            cq.setName("ConceptualQueue" + count);
            ++count;
        }
        this.upperLeft = cq.getUpperLeft();
        if (this.upperLeft instanceof Coordinates) {
            this.ulx = ((Coordinates)this.upperLeft).getX();
            this.uly = ((Coordinates)this.upperLeft).getY();
        }
        Integer queueDepth = (Integer)cq.getProperties().get("depth");
        this.tp = new TextProperties();
        this.tp.set("color", cq.getProperties().get("elementColor"));
        if (queueDepth.compareTo(Integer.MAX_VALUE) < 0) {
            this.tp.set("depth", queueDepth);
        } else {
            this.tp.set("depth", queueDepth - 1);
        }
        this.tp.set("centered", true);
        this.fontObject = cq.getProperties().get("font");
        this.fontSize = ((Font)this.fontObject).getSize();
        this.heightOffset = this.fontSize / 2;
        this.tp.set("font", this.fontObject);
        this.tp.set("hidden", this.hiddenProp);
        PolylineProperties plp = new PolylineProperties();
        plp.set("color", cq.getProperties().get("color"));
        plp.set("bwArrow", true);
        plp.set("depth", cq.getProperties().get("depth"));
        this.hiddenProp = (Boolean)cq.getProperties().get("hidden");
        this.hidden = cq.getDisplayOptions() instanceof Hidden;
        plp.set("hidden", this.hiddenProp);
        Node[] vertices = new Node[]{new Coordinates(this.ulx, this.uly + this.heightOffset + this.heightOffset / 2), new Coordinates(this.ulx + 40, this.uly + this.heightOffset + this.heightOffset / 2)};
        this.lang.newPolyline(vertices, "", cq.getDisplayOptions(), plp);
        Node[] vertices2 = new Node[]{new Coordinates(this.ulx + 40, this.uly + this.heightOffset + this.heightOffset / 2), new Coordinates(this.ulx + 80, this.uly + this.heightOffset + this.heightOffset / 2)};
        this.pLine = this.lang.newPolyline(vertices2, "", cq.getDisplayOptions(), plp);
        this.pLine.hide();
        this.hiddenPLine = true;
        this.rp = new RectProperties();
        this.rp.set("color", cq.getProperties().get("color"));
        this.rp.set("depth", (Integer)this.tp.get("depth") + 1);
        this.alternateFilled = (Boolean)cq.getProperties().get("alternateFilled");
        this.rp.set("filled", true);
        this.rp.set("hidden", this.hiddenProp);
        this.rectangles = new LinkedList();
        this.texts = new LinkedList();
        List content = cq.getInitContent();
        if (content != null) {
            ListIterator li = content.listIterator();
            while (li.hasNext()) {
                this.enqueue(cq, li.next(), null, null);
            }
        }
    }

    @Override
    public void dequeue(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.frontText.hide(delay);
        this.frontRect.hide(delay);
        this.texts.removeFirst();
        this.rectangles.removeFirst();
        String text = this.frontText.getText();
        int width = Animal.getStringWidth(text, (Font)this.fontObject) + 4;
        this.pLine.moveBy("translate", -width, 0, delay, duration);
        if (!this.texts.isEmpty()) {
            this.frontRect = (Rect)this.rectangles.getFirst();
            this.frontText = (Text)this.texts.getFirst();
            this.textsToMove = this.lang.newGroup(this.texts, "");
            this.rectanglesToMove = this.lang.newGroup(this.rectangles, "");
            this.textsToMove.moveBy("translate", -width, 0, delay, duration);
            this.rectanglesToMove.moveBy("translate", -width, 0, delay, duration);
            this.tailX -= width;
        } else {
            this.frontRect = null;
            this.frontText = null;
            this.tailX = -1;
            this.pLine.hide(delay);
            this.hiddenPLine = true;
        }
    }

    @Override
    public void enqueue(ConceptualQueue<T> cq, T elem, Timing delay, Timing duration) {
        String text = elem.toString();
        int width = Animal.getStringWidth(text, (Font)this.fontObject) + 4;
        if (this.tailText != null && this.highlightedTailText) {
            this.unhighlightTailElem(cq, delay, duration);
        }
        if (this.tailRect != null && this.highlightedTailRect) {
            this.unhighlightTailCell(cq, delay, duration);
        }
        if (this.tailX == -1) {
            this.tailX = this.ulx + 40;
        }
        this.rp.set("fillColor", this.odd && this.alternateFilled ? cq.getProperties().get("alternateFillColor") : Color.WHITE);
        this.tailText = this.lang.newText(new Coordinates(this.tailX + width / 2, this.uly), text, "", this.hidden ? new Hidden() : delay, this.tp);
        this.tailRect = this.lang.newRect(new Coordinates(this.tailX, this.uly), new Coordinates(this.tailX + width, this.uly + this.fontSize + this.heightOffset), "", this.hidden ? new Hidden() : delay, this.rp);
        this.pLine.moveBy("translate", width, 0, delay, duration);
        if (this.hiddenPLine && !this.hidden && !this.hiddenProp) {
            this.pLine.show(delay);
            this.hiddenPLine = false;
        }
        this.tailX += width;
        if (this.frontText == null) {
            this.frontText = this.tailText;
        }
        if (this.frontRect == null) {
            this.frontRect = this.tailRect;
        }
        this.odd = !this.odd;
        this.texts.add(this.tailText);
        this.rectangles.add(this.tailRect);
    }

    @Override
    public void front(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.highlightFrontCell(cq, delay, duration);
        this.highlightFrontElem(cq, delay, duration);
    }

    @Override
    public void highlightFrontCell(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.frontRect.changeColor("fillColor", (Color)cq.getProperties().get("cellHighlight"), delay, duration);
    }

    @Override
    public void highlightFrontElem(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.frontText.changeColor("color", (Color)cq.getProperties().get("elemHighlight"), delay, duration);
    }

    @Override
    public void highlightTailCell(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.tailRect.changeColor("fillColor", (Color)cq.getProperties().get("cellHighlight"), delay, duration);
        this.highlightedTailRect = true;
    }

    @Override
    public void highlightTailElem(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.tailText.changeColor("color", (Color)cq.getProperties().get("elemHighlight"), delay, duration);
        this.highlightedTailText = true;
    }

    @Override
    public void isEmpty(ConceptualQueue<T> cq, Timing delay, Timing duration) {
    }

    @Override
    public void tail(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.highlightTailCell(cq, delay, duration);
        this.highlightTailElem(cq, delay, duration);
    }

    @Override
    public void unhighlightFrontCell(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.frontRect.changeColor("fillColor", this.alternateFilled && !this.odd ? (Color)this.rp.get("fillColor") : Color.WHITE, delay, duration);
    }

    @Override
    public void unhighlightFrontElem(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.frontText.changeColor("color", (Color)this.tp.get("color"), delay, duration);
    }

    @Override
    public void unhighlightTailCell(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.tailRect.changeColor("fillColor", this.alternateFilled && !this.odd ? (Color)this.rp.get("fillColor") : Color.WHITE, delay, duration);
        this.highlightedTailRect = false;
    }

    @Override
    public void unhighlightTailElem(ConceptualQueue<T> cq, Timing delay, Timing duration) {
        this.tailText.changeColor("color", (Color)this.tp.get("color"), delay, duration);
        this.highlightedTailText = false;
    }
}

