/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.misc.MessageDisplay;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import translator.AnimalTranslator;

public class ScalableGraphics
extends Graphics {
    private Graphics g = null;
    private double mag = 1.0;
    private Hashtable<Font, Font> fontList = new Hashtable(20);
    private Hashtable<Font, Font> inverseFontList = new Hashtable(20);

    public void setGraphics(Graphics aGraphicsContext) {
        this.g = aGraphicsContext;
    }

    public void setMagnification(double magnification) {
        this.mag = magnification;
        this.fontList.clear();
        this.inverseFontList.clear();
    }

    public double getMagnification() {
        return this.mag;
    }

    private int get(int coord) {
        if (this.mag == 1.0) {
            return coord;
        }
        if (this.mag == 0.0) {
            MessageDisplay.errorMsg("Magnification is 0", 16);
        }
        return (int)Math.round((double)coord * this.mag);
    }

    private int unget(int coord) {
        if (this.mag == 1.0) {
            return coord;
        }
        return (int)Math.round((double)coord / this.mag);
    }

    int[] getPoints(int[] points) {
        if (this.mag == 1.0) {
            return points;
        }
        int[] result = new int[points.length];
        int a = 0;
        while (a < points.length) {
            result[a] = this.get(points[a]);
            ++a;
        }
        return result;
    }

    public void translate(int x, int y) {
        this.g.translate(x, y);
    }

    public void setXORMode(Color c1) {
        this.g.setXORMode(c1);
    }

    public void setPaintMode() {
        this.g.setPaintMode();
    }

    public void setFont(Font font) {
        if (this.mag == 1.0) {
            this.g.setFont(font);
        } else {
            Font f = this.fontList.get(font);
            if (f == null) {
                f = new Font(font.getName(), font.getStyle(), this.get(font.getSize()));
                this.fontList.put(font, f);
                this.inverseFontList.put(f, font);
            }
            this.g.setFont(f);
        }
    }

    public void setColor(Color c) {
        this.g.setColor(c);
    }

    public void setClip(int x, int y, int width, int height) {
        this.g.setClip(this.get(x), this.get(y), this.get(width), this.get(height));
    }

    public void setClip(Shape clip) {
        this.g.setClip(clip);
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.g.getFontMetrics(f);
    }

    public Font getFont() {
        Font originalFont = this.g.getFont();
        if (this.mag == 1.0) {
            return originalFont;
        }
        Font f = this.inverseFontList.get(originalFont);
        if (f == null) {
            f = new Font(originalFont.getName(), originalFont.getStyle(), this.unget(originalFont.getSize()));
            this.fontList.put(f, originalFont);
            this.inverseFontList.put(originalFont, f);
        }
        return f;
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public Rectangle getClipBounds() {
        Rectangle r = this.g.getClipBounds();
        return new Rectangle(this.unget(r.x), this.unget(r.y), this.unget(r.width), this.unget(r.height));
    }

    public Shape getClip() {
        return this.g.getClip();
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.fillRoundRect(this.get(x), this.get(y), this.get(width), this.get(height), this.get(arcWidth), this.get(arcHeight));
    }

    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(this.get(x), this.get(y), this.get(width), this.get(height));
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.g.fillPolygon(this.getPoints(xPoints), this.getPoints(yPoints), nPoints);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.g.fillOval(this.get(x), this.get(y), this.get(width), this.get(height));
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.fillArc(this.get(x), this.get(y), this.get(width), this.get(height), startAngle, arcAngle);
    }

    public void drawString(AttributedCharacterIterator str, int x, int y) {
        this.g.drawString(str, this.get(x), this.get(y));
    }

    public void drawString(String str, int x, int y) {
        this.g.drawString(str, this.get(x), this.get(y));
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g.drawRoundRect(this.get(x), this.get(y), this.get(width), this.get(height), this.get(arcWidth), this.get(arcHeight));
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.g.drawPolyline(this.getPoints(xPoints), this.getPoints(yPoints), nPoints);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.g.drawPolygon(this.getPoints(xPoints), this.getPoints(yPoints), nPoints);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.g.drawOval(this.get(x), this.get(y), this.get(width), this.get(height));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(this.get(x1), this.get(y1), this.get(x2), this.get(y2));
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.g.drawImage(img, this.get(dx1), this.get(dy1), this.get(dx2), this.get(dy2), sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.g.drawImage(img, this.get(dx1), this.get(dy1), this.get(dx2), this.get(dy2), sx1, sy1, sx2, sy2, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.g.drawImage(img, this.get(x), this.get(y), this.get(width), this.get(height), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.g.drawImage(img, this.get(x), this.get(y), observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.g.drawImage(img, this.get(x), this.get(y), this.get(width), this.get(height), observer);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.g.drawImage(img, this.get(x), this.get(y), bgcolor, observer);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.drawArc(this.get(x), this.get(y), this.get(width), this.get(height), startAngle, arcAngle);
    }

    public void dispose() {
        this.g.dispose();
    }

    public Graphics create() {
        return this.g.create();
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g.copyArea(this.get(x), this.get(y), this.get(width), this.get(height), this.get(dx), this.get(dy));
    }

    public void clipRect(int x, int y, int width, int height) {
        this.g.clipRect(this.get(x), this.get(y), this.get(width), this.get(height));
    }

    public void clearRect(int x, int y, int width, int height) {
        this.g.clearRect(this.get(x), this.get(y), this.get(width), this.get(height));
    }

    public String toString() {
        return AnimalTranslator.translateMessage("sgToString", new Object[]{this.getClass().getName(), this.getMagnification()});
    }
}

