/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.animator.Animator;
import animal.api.AnimalStepListener;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.main.AnimationCanvas;
import animal.main.AnimationState;
import animal.main.Link;
import animalscript.core.AnimalScriptParser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class AnimationController
implements ActionListener {
    AnimalScriptParser aSP = null;
    AnimalConfiguration animalConfig;
    Animation animation;
    AnimationCanvas animationCanvas;
    AnimationState ani;
    boolean pause;
    boolean forwardMode;
    boolean slideShowMode;
    double ticks;
    double speed = 1.0;
    Timer timer;
    JFrame frame;
    private JButton play;
    private List<AnimalStepListener> animalStepListeners = new LinkedList<AnimalStepListener>();

    public AnimationController(Animation anim, AnimationCanvas canvas, AnimationState animState) {
        this.setAnimationCanvas(canvas);
        this.setAnimation(anim);
        this.setAnimationState(animState);
    }

    public void addAnimalStepListener(AnimalStepListener listener) {
        this.animalStepListeners.add(listener);
    }

    public void removeAnimalStepListener(AnimalStepListener listener) {
        this.animalStepListeners.remove(listener);
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation newAnim) {
        this.animation = newAnim;
        this.setAnimationState(new AnimationState(this.animation));
        this.getAnimationState().reset();
        int stepNr = this.getAnimationState().getStep();
        if (stepNr == 0) {
            stepNr = this.getAnimationState().getFirstRealStep();
        }
        this.getAnimationState().setStep(stepNr, true);
    }

    public AnimationState getAnimationState() {
        return this.ani;
    }

    public void setAnimationState(AnimationState animState) {
        this.ani = animState;
        this.getAnimationCanvas().setObjects(this.ani.getCurrentObjects());
        this.setStep(this.ani.getFirstRealStep(), true);
    }

    public AnimationCanvas getAnimationCanvas() {
        return this.animationCanvas;
    }

    public void setAnimationCanvas(AnimationCanvas canvas) {
        this.animationCanvas = canvas;
    }

    public void setStep(int step, boolean immediate) {
        this.forwardMode = true;
        int next = 0;
        step = this.ani.getAnimation().verifyStep(step);
        if (this.ani != null) {
            this.ani.setStep(step, !immediate);
        }
        if (immediate) {
            this.animationCanvas.repaintNow();
            next = Integer.MAX_VALUE;
        } else {
            next = this.nextStep();
            if (next != Integer.MAX_VALUE) {
                step = next;
            }
        }
        for (AnimalStepListener listener : this.animalStepListeners) {
            listener.stepSet(step, immediate);
        }
    }

    public int nextStep() {
        this.forwardMode = true;
        int step = this.ani.getStep();
        Vector<Animator> animators = this.ani.getCurrentAnimators();
        long time = System.currentTimeMillis();
        int initTicks = (int)Math.round(this.ticks);
        int a = 0;
        while (a < animators.size()) {
            animators.elementAt(a).init(this.ani, time, initTicks);
            ++a;
        }
        boolean finished = false;
        while (!finished) {
            finished = true;
            time = System.currentTimeMillis();
            this.ticks += this.speed;
            int a2 = 0;
            while (a2 < animators.size()) {
                Animator animator = animators.elementAt(a2);
                if (animator == null) continue;
                animator.action(time, this.ticks);
                if (animator.hasFinished()) {
                    animators.removeElementAt(a2);
                    continue;
                }
                finished = false;
                ++a2;
            }
            this.animationCanvas.repaintNow();
        }
        Link l = this.ani.getAnimation().getLink(step);
        if (this.slideShowMode && !this.pause) {
            int delay = l.getTime();
            if (delay == 0) {
                delay = Animal.getSlideShowDelay();
            }
            if (this.timer == null) {
                this.timer = new Timer(delay, this);
            } else {
                this.timer.setDelay(delay);
            }
            this.timer.setRepeats(false);
            this.timer.start();
            return l.getNextStep();
        }
        switch (l.getMode()) {
            case 1: {
                return Integer.MAX_VALUE;
            }
            case 2: {
                if (!this.pause) {
                    if (this.timer == null) {
                        this.timer = new Timer(l.getTime(), this);
                    } else {
                        this.timer.setDelay(l.getTime());
                    }
                    this.timer.setRepeats(false);
                    this.timer.start();
                    return l.getNextStep();
                }
                this.pause = false;
                return Integer.MAX_VALUE;
            }
            case 4: {
                JOptionPane.showMessageDialog(null, l.getClickPrompt());
                return Integer.MAX_VALUE;
            }
        }
        return Integer.MAX_VALUE;
    }

    public void pause() {
        this.pause = true;
        this.slideShowMode = false;
    }

    public void stepBackward() {
        this.slideShowMode = false;
        if (this.ani.getPrevStep() != 0) {
            this.setStep(this.ani.getPrevStep(), true);
        }
    }

    public void stepForward() {
        this.slideShowMode = false;
        this.setStep(this.ani.getNextStep(), false);
    }

    public void play() {
        this.slideShowMode = true;
        this.forwardMode = true;
        this.pause = false;
        this.setStep(this.ani.getNextStep(), false);
    }

    public void reversePlay() {
        this.slideShowMode = true;
        this.forwardMode = false;
        this.pause = false;
        this.setStep(this.ani.getStep(), false);
    }

    public void gotoFrame(int aFrame) {
        if (aFrame == 0) {
            aFrame = 1;
        }
        this.setStep(aFrame, true);
    }

    public void stop() {
        this.pause();
        this.setStep(this.ani.getFirstRealStep(), true);
    }

    public boolean getSlideShowMode() {
        return this.slideShowMode;
    }

    public void setSlideShowMode(boolean mode) {
        this.slideShowMode = mode;
    }

    public void zoom(double level) {
        this.animationCanvas.setMagnification(level);
    }

    public double getZoom() {
        return this.animationCanvas.getMagnification();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.play) {
            this.stepForward();
        }
        if (actionEvent.getSource() == this.timer && !this.pause) {
            int nextStep = Integer.MAX_VALUE;
            nextStep = this.forwardMode ? this.ani.getNextStep() : this.ani.getPrevStep();
            if (this.forwardMode && nextStep != Integer.MAX_VALUE) {
                this.setStep(nextStep, false);
            }
        }
    }
}

