/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.animator.Rotation;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTText;
import animal.handler.GraphicObjectHandler;
import animal.misc.MSMath;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextHandler
extends GraphicObjectHandler {
    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        if (obj instanceof Point) {
            result.addElement("translate");
        }
        if (obj instanceof Color) {
            result.addElement("color");
        }
        if (obj instanceof Rotation) {
            result.addElement("rotate");
        }
        if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        String what;
        PTText text = null;
        if (ptgo instanceof PTText) {
            text = (PTText)ptgo;
        }
        if ((what = e.getPropertyName()).equalsIgnoreCase("translate")) {
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            text.translate(diff.x, diff.y);
        } else if (what.equalsIgnoreCase("color")) {
            text.setColor((Color)e.getNewValue());
        } else if (what.equalsIgnoreCase("rotate")) {
            Rotation r = (Rotation)e.getNewValue();
            text.rotate(r.getAngle(), r.getCenter());
        } else {
            super.propertyChange(ptgo, e);
        }
    }
}

