/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.graphics.PTClosedEllipseSegment;
import animal.graphics.PTGraphicObject;
import animal.handler.GraphicObjectHandler;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import translator.AnimalTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosedEllipseSegmentHandler
extends GraphicObjectHandler {
    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        if (!(ptgo instanceof PTClosedEllipseSegment)) {
            return result;
        }
        if (obj instanceof Point) {
            result.addElement("translate");
        }
        if (obj instanceof Color) {
            result.addElement("color");
            result.addElement("fillColor");
            result.addElement("colors: color, fillColor");
        }
        if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
        }
        if (obj instanceof String) {
            result.addElement("fill");
            result.addElement("unfill");
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        String what;
        PTClosedEllipseSegment shape = null;
        if (ptgo instanceof PTClosedEllipseSegment) {
            shape = (PTClosedEllipseSegment)ptgo;
        }
        if ("translate".equalsIgnoreCase(what = e.getPropertyName())) {
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            shape.translate(diff.x, diff.y);
        } else if (what.equalsIgnoreCase("color")) {
            shape.setColor((Color)e.getNewValue());
        } else if (what.equalsIgnoreCase("fillColor")) {
            shape.setFillColor((Color)e.getNewValue());
        } else if (what.startsWith("colors:")) {
            StringTokenizer stringTokenizer = new StringTokenizer(what, ":, ");
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String currentToken = stringTokenizer.nextToken();
                if (currentToken.equalsIgnoreCase("color")) {
                    shape.setColor((Color)e.getNewValue());
                    continue;
                }
                if (currentToken.equalsIgnoreCase("fillColor")) {
                    shape.setFillColor((Color)e.getNewValue());
                    continue;
                }
                MessageDisplay.message("unparsedHandlerToken", new String[]{AnimalTranslator.translateMessage("polylineColor"), currentToken});
            }
        } else if (what.equalsIgnoreCase("fill")) {
            shape.setFilled(true);
        } else if (what.equalsIgnoreCase("unfill")) {
            shape.setFilled(false);
        } else {
            super.propertyChange(ptgo, e);
        }
    }
}

