/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.exchange.AnimationExporter;
import animal.exchange.AnimationImporter;
import animal.exchange.AnimationPrintJob;
import animal.gui.AnimalMainWindow;
import animal.gui.AnimalScriptInputWindow;
import animal.gui.DrawWindow;
import animal.main.Animal;
import animal.main.Animation;
import animal.main.AnimationWindow;
import animal.misc.MessageDisplay;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MainToolBarController
implements ActionListener {
    private Animal animal;

    public MainToolBarController(Animal animalInstance) {
        this.animal = animalInstance;
    }

    public void actionPerformed(ActionEvent event) {
        String command;
        if (this.animal == null) {
            this.animal = Animal.get();
        }
        if ((command = event.getActionCommand()).equals("input")) {
            AnimalScriptInputWindow siw = this.animal.getScriptInputWindow();
            siw.setVisible(true);
        } else if ("new".equals(command)) {
            this.animal.newFile();
        } else if ("open".equals(command)) {
            AnimationImporter.importAnimation();
        } else if ("repository".equals(command)) {
            this.animal.openRepository();
        } else if ("reload".equals(command)) {
            this.animal.reloadFile();
        } else if (!"input".equals(command)) {
            if ("print".equals(command)) {
                new AnimationPrintJob(this.animal);
            } else if ("runStep".equals(command) || "animWin".equals(command)) {
                AnimationWindow animWin = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true);
                animWin.setVisible(true);
                animWin.startOfAnimation();
            } else if ("drawWin".equals(command)) {
                DrawWindow drawWin = AnimalMainWindow.getWindowCoordinator().getDrawWindow(true);
                drawWin.setVisible(true);
            } else if ("save".equals(command)) {
                Animation currentAnimation = this.animal.getAnimation();
                if (currentAnimation != null) {
                    AnimationExporter.saveAnimation(currentAnimation);
                }
            } else if ("saveAs".equals(command)) {
                Animation currentAnimation = this.animal.getAnimation();
                if (currentAnimation != null) {
                    AnimationExporter.exportAnimation(currentAnimation);
                }
            } else {
                MessageDisplay.errorMsg("nothingAssoc", command, 4);
            }
        }
    }
}

