/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.MainMenuBar;
import animal.gui.MainToolBar;
import animal.gui.WindowCoordinator;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.AnimalFrame;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import translator.AnimalTranslator;
import translator.ExtendedAction;
import translator.ResourceLocator;

public class AnimalMainWindow
extends AnimalFrame
implements WindowListener {
    private static JTextArea outputArea;
    private static final long serialVersionUID = 4339204989666063741L;
    public static WindowCoordinator WINDOW_COORDINATOR;
    private Animal animalInstance;
    protected Vector<String> languages = null;
    public Hashtable<String, ExtendedAction> actions = new Hashtable(47);
    private JMenu languageMenu = null;
    private static final String DEFAULT_LANGUAGES_FILENAME = "languages.default";
    private static final String LANGUAGES_FILENAME = "languages.dat";
    private static ResourceLocator resourceLocator;
    private static JToolBar toolBar;
    private static JMenuBar menuBar;

    static {
        resourceLocator = ResourceLocator.getResourceLocator();
        toolBar = null;
        menuBar = null;
    }

    public AnimalMainWindow(Animal animalParam, XProperties propsParam, boolean appletMode, boolean debugMode) {
        super(animalParam, propsParam, appletMode);
        this.animalInstance = animalParam == null ? Animal.get() : animalParam;
        WINDOW_COORDINATOR = new WindowCoordinator(this.animalInstance, this);
        this.setAnimalLocale(Animal.getCurrentLocale());
        String versionInfo = AnimalConfiguration.getDefaultConfiguration().getVersionLine("briefVersionInfoLine");
        this.setTitle("Animal Control Center [" + versionInfo + "]");
        outputArea = new JTextArea();
        this.workContainer().add("Center", new JScrollPane(outputArea));
        outputArea.setEditable(false);
        MessageDisplay.initialize(outputArea, debugMode, this.props);
        toolBar = new MainToolBar("Animal", this.animalInstance);
        this.workContainer().add("North", toolBar);
        menuBar = new MainMenuBar("menuBar", this, this.animalInstance);
        this.setJMenuBar(menuBar);
        this.ensureSensibleBounds(this.props);
        this.addWindowListener(this);
    }

    public void ensureSensibleBounds(XProperties propsParam) {
        int h;
        int w;
        int y;
        int x = propsParam.getIntProperty("animal.x", 100);
        if (x < 0) {
            x = 10;
        }
        if ((y = propsParam.getIntProperty("animal.y", 100)) < 0) {
            y = 10;
        }
        if ((w = propsParam.getIntProperty("animal.width", 480)) < 200) {
            w = 480;
        }
        if ((h = propsParam.getIntProperty("animal.height", 320)) < 50) {
            h = 320;
        }
        this.setBounds(x, y, w, h);
    }

    public void generateLanguageMenu() {
        String baseCode = null;
        XProperties languageProperties = this.retrieveLanguageDefinitions();
        String[] entries = languageProperties.getKeysWithSuffix(".label");
        int nrElems = entries.length;
        if (this.languages == null) {
            this.languages = new Vector(20);
        }
        this.languages.removeAllElements();
        int i = 0;
        while (i < nrElems) {
            baseCode = entries[i].substring(0, entries[i].indexOf(46));
            String localeString = languageProperties.getProperty(String.valueOf(baseCode) + ".locale");
            this.addLanguageSupportEntry(localeString, languageProperties.getProperty(String.valueOf(baseCode) + ".label"), languageProperties.getProperty(String.valueOf(baseCode) + ".icon"), languageProperties.getProperty(String.valueOf(baseCode) + ".toolTipText"));
            ++i;
        }
    }

    public static JTextArea getOutputArea() {
        return outputArea;
    }

    public static JToolBar getToolBar() {
        return toolBar;
    }

    public static JMenuBar menuBar() {
        return menuBar;
    }

    public void addLanguageSupportEntry(String localeString, String label, String iconName, String toolTipText) {
        String languageKey;
        StringTokenizer stok = new StringTokenizer(localeString, " _");
        String baseCode = stok.nextToken();
        Locale targetLocale = new Locale(baseCode, stok.nextToken());
        if (toolTipText == null) {
            toolTipText = label;
        }
        if (!this.languages.contains(languageKey = String.valueOf(label) + ";" + localeString + ";" + iconName + ";" + toolTipText)) {
            this.languages.addElement(languageKey);
        }
        ExtendedAction helper = new ExtendedAction(label, iconName, toolTipText, "setAnimalLocale", this, new Object[]{targetLocale}, AnimalTranslator.getTranslator());
        this.actions.put(localeString, helper);
        if (this.languageMenu == null) {
            this.languageMenu = AnimalTranslator.getGUIBuilder().generateJMenu("locale", null);
        }
        this.languageMenu.add(helper);
    }

    public void updateLanguageMenu() {
        this.languageMenu.removeAll();
        this.generateLanguageMenu();
    }

    public void removeLanguageSupportEntry(String languageKey) {
        if (this.actions.containsKey(languageKey)) {
            this.languages.removeElement(this.actions.get(languageKey));
            this.actions.remove(languageKey);
        }
        this.updateLanguageMenu();
    }

    public void addLanguage(String languageKey) {
        if (!this.languages.contains(languageKey)) {
            this.languages.addElement(languageKey);
        }
    }

    public boolean supportsLanguage(String languageKey) {
        return this.languages.contains(languageKey);
    }

    public String[] getLanguageKeys() {
        if (this.languages == null) {
            this.languages = new Vector(20);
        }
        if (this.languages.size() == 0) {
            this.languages.addElement("English;en US;en_US.gif;Translate system into English");
        }
        int nrElems = this.languages.size();
        String[] keys = new String[nrElems];
        int i = 0;
        while (i < nrElems) {
            keys[i] = this.languages.elementAt(i);
            ++i;
        }
        return keys;
    }

    public XProperties retrieveLanguageDefinitions() {
        XProperties localProps = null;
        try {
            Properties defaultProps = new Properties();
            InputStream is = resourceLocator.getResourceStream(DEFAULT_LANGUAGES_FILENAME, runsInApplet, baseURL);
            if (is != null) {
                defaultProps.load(new BufferedInputStream(is));
                is.close();
            }
            localProps = new XProperties(defaultProps);
            is = resourceLocator.getResourceStream(LANGUAGES_FILENAME, runsInApplet, baseURL);
            if (is != null) {
                localProps.load(new BufferedInputStream(is));
                is.close();
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("langSupportKeyLoadFailed", new String[]{DEFAULT_LANGUAGES_FILENAME}, 8);
        }
        return new XProperties(localProps);
    }

    public void setAnimalLocale(Locale targetLocale) {
        AnimalTranslator.setTranslatorLocale(targetLocale);
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
        MessageDisplay.message(AnimalTranslator.translateMessage("thanksAndBye", AnimalConfiguration.getDefaultConfiguration().getVersionLine("versionInfoLine")));
        this.animal.requestAnimationSave();
        System.exit(0);
    }

    public void windowClosing(WindowEvent arg0) {
        MessageDisplay.message(AnimalTranslator.translateMessage("thanksAndBye", AnimalConfiguration.getDefaultConfiguration().getVersionLine("versionInfoLine")));
        this.animal.requestAnimationSave();
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    public static WindowCoordinator getWindowCoordinator() {
        return WINDOW_COORDINATOR;
    }
}

