/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.graphics.PTGraphicObject;
import animal.graphics.meta.FillablePrimitive;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;

public abstract class PolygonalShape
extends PTGraphicObject
implements FillablePrimitive {
    protected Color fillColor;
    protected Point firstNode = null;
    protected boolean isFilled = false;

    public String nodeToString(Point node) {
        StringBuilder sb = new StringBuilder(32);
        if (node != null) {
            sb.append("(").append(node.x).append(",").append(node.y).append(") ");
        }
        return sb.toString();
    }

    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = AnimalConfiguration.getDefaultConfiguration().getDefaultColor(this.getType(), "fillColor", Color.BLACK);
        }
        return this.fillColor;
    }

    public Point getFirstNode() {
        if (this.firstNode == null) {
            this.firstNode = new Point(10, 10);
        }
        return this.firstNode;
    }

    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.isFilled = config.getDefaultBooleanValue(primitiveName, "filled", false);
        this.fillColor = config.getDefaultColor(primitiveName, "fillColor", Color.BLACK);
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color c) {
        this.fillColor = c != null ? c : Color.BLACK;
    }

    public void setFilled(boolean filled) {
        this.isFilled = filled;
    }

    public void setFirstNode(int x, int y) {
        if (this.firstNode == null) {
            this.firstNode = new Point(x, y);
        } else {
            this.firstNode.x = x;
            this.firstNode.y = y;
        }
    }

    public void setFirstNode(Point node) {
        if (node == null) {
            this.setFirstNode(0, 0);
        } else {
            this.setFirstNode(node.x, node.y);
        }
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".fillColor", this.getFillColor());
        defaultProperties.put(String.valueOf(this.getType()) + ".filled", this.isFilled());
        defaultProperties.put(String.valueOf(this.getType()) + ".node1", this.getFirstNode());
    }

    protected void cloneCommonFeaturesInto(PolygonalShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setFilled(this.isFilled());
        targetShape.setFillColor(this.createColor(this.getFillColor()));
        targetShape.setFirstNode(this.getFirstNode().x, this.getFirstNode().y);
    }

    public void discard() {
        this.firstNode = null;
        this.color = null;
        this.fillColor = null;
        super.discard();
    }
}

