/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.graphics.meta.ArcBasedShape;
import animal.graphics.meta.FillablePrimitive;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;

public abstract class ClosedArcBasedShape
extends ArcBasedShape
implements FillablePrimitive {
    protected Color fillColor;
    protected boolean isFilled;

    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        this.center = new Point(0, 0);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.isFilled = config.getDefaultBooleanValue(primitiveName, "filled", false);
        this.fillColor = config.getDefaultColor(primitiveName, "fillColor", Color.BLACK);
    }

    public void cloneCommonFeaturesInto(ClosedArcBasedShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setFilled(this.isFilled());
        targetShape.setFillColor(this.createColor(this.getFillColor()));
    }

    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = Color.BLACK;
        }
        return this.fillColor;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFilled(boolean filled) {
        this.isFilled = filled;
    }

    public void setFillColor(Color targetFillColor) {
        this.fillColor = targetFillColor;
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".filled", this.isFilled());
        defaultProperties.put(String.valueOf(this.getType()) + ".fillColor", this.getFillColor());
    }
}

