/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PTPoint;
import animal.graphics.PTPolygon;
import animal.graphics.meta.ArrowablePrimitive;
import animal.graphics.meta.OpenLineBasedShape;
import animal.misc.MSMath;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTPolyline
extends OpenLineBasedShape
implements MoveBase,
ArrowablePrimitive {
    public static final String TYPE_LABEL = "Polyline";
    private Vector<PTPoint> nodes = new Vector(50, 10);
    private static final long serialVersionUID = 5793164474737251118L;

    public PTPolyline() {
        this(new PTPoint[0]);
    }

    public PTPolyline(int[] xCoords, int[] yCoords) {
        this.initializeWithDefaults(this.getType());
        if (xCoords != null && yCoords != null && xCoords.length == yCoords.length) {
            int nrNodes = xCoords.length;
            int nodeNr = 0;
            while (nodeNr < nrNodes) {
                this.addNode(new PTPoint(xCoords[nodeNr], yCoords[nodeNr]));
                ++nodeNr;
            }
        }
    }

    public PTPolyline(Point[] edges) {
        this.initializeWithDefaults(this.getType());
        int i = 0;
        while (i < edges.length) {
            this.addNode(new PTPoint(edges[i]));
            ++i;
        }
    }

    public PTPolyline(PTPoint[] edges) {
        this.initializeWithDefaults(this.getType());
        int i = 0;
        while (i < edges.length) {
            this.addNode(edges[i]);
            ++i;
        }
    }

    @Override
    public int getFileVersion() {
        return 5;
    }

    public PTPoint getNode(int index) {
        if (index >= 0 && index < this.nodes.size()) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    public void addNode(PTPoint node) {
        this.nodes.addElement(node);
    }

    public void addNode(Point node) {
        this.nodes.addElement(new PTPoint(node));
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void rotate(double angle) {
        int maxIndex = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < maxIndex) {
            this.nodes.elementAt(node_nr).rotate(angle);
            ++node_nr;
        }
    }

    public void rotate(double angle, PTPoint center) {
        int maxIndex = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < maxIndex) {
            if (this.nodes.elementAt(node_nr) != null) {
                this.nodes.elementAt(node_nr).rotate(angle, center);
            }
            ++node_nr;
        }
    }

    public void scale(double scale_x, double scale_y) {
        int maxIndex = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < maxIndex) {
            if (this.nodes.elementAt(node_nr) != null) {
                this.nodes.elementAt(node_nr).scale(scale_x, scale_y);
            }
            ++node_nr;
        }
    }

    public void shear(double shear_x, double shear_y) {
        int maxIndex = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < maxIndex) {
            if (this.nodes.elementAt(node_nr) != null) {
                this.nodes.elementAt(node_nr).shear(shear_x, shear_y);
            }
            ++node_nr;
        }
    }

    public int getDifferentNodesCount() {
        int c = this.nodes.size();
        if (c > 0 && this.nodes.elementAt(0) == this.nodes.elementAt(c - 1)) {
            return c - 1;
        }
        return c;
    }

    @Override
    public void translate(int delta_x, int delta_y) {
        int maxIndex = this.getDifferentNodesCount();
        int node_nr = 0;
        while (node_nr < maxIndex) {
            if (this.nodes.elementAt(node_nr) != null) {
                this.nodes.elementAt(node_nr).translate(delta_x, delta_y);
            }
            ++node_nr;
        }
    }

    public void translate(int aNum, int delta_x, int delta_y) {
        this.nodes.elementAt(aNum).translate(delta_x, delta_y);
    }

    public void translate(boolean[] moveTheseOnly, int deltaX, int deltaY) {
        int maxIndex = this.getDifferentNodesCount();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            if (this.nodes.elementAt(nodeNr) != null && moveTheseOnly[nodeNr]) {
                this.nodes.elementAt(nodeNr).translate(deltaX, deltaY);
            }
            ++nodeNr;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(120);
        result.append("PTPolyline ");
        if (this.getObjectName() != null) {
            result.append("\"").append(this.getObjectName()).append("\" ");
        }
        result.append("{ ");
        int limit = this.nodes.size();
        int i = 0;
        while (i < limit) {
            result.append(this.nodes.elementAt(i).toString()).append(i < limit - 1 ? ", " : "");
            ++i;
        }
        result.append(" }");
        return result.toString();
    }

    public Vector<PTPoint> getNodes() {
        return this.nodes;
    }

    public void setNodes(Vector<PTPoint> newNodes) {
        this.nodes = newNodes;
    }

    public void setNode(int index, PTPoint p) {
        if (index >= this.nodes.size()) {
            this.addNode(p);
        } else if (index == 0) {
            this.nodes.setElementAt(p, 0);
            this.nodes.setElementAt(p, this.nodes.size() - 1);
        } else {
            this.nodes.setElementAt(p, index);
        }
    }

    void removeNodes() {
        if (this.nodes == null) {
            this.nodes = new Vector(20, 10);
        } else {
            this.nodes.clear();
        }
    }

    public void removeNode(int index) {
        this.nodes.removeElementAt(index);
    }

    public Polygon toPolygon() {
        int numNodes = this.nodes.size();
        int[] xpoints = new int[numNodes + 1];
        int[] ypoints = new int[numNodes + 1];
        Point oldP = null;
        int counter = 0;
        int i = 0;
        while (i < numNodes) {
            Point p = this.getNode(i).toPoint();
            if (!p.equals(oldP)) {
                xpoints[counter] = p.x;
                ypoints[counter] = p.y;
                ++counter;
            }
            oldP = p;
            ++i;
        }
        return new Polygon(xpoints, ypoints, counter);
    }

    @Override
    public void paint(Graphics g) {
        if (this.getNodeCount() > 1) {
            Polygon poly = this.toPolygon();
            int numNodes = poly.npoints;
            if (numNodes > 1) {
                g.setColor(this.getColor());
                g.drawPolyline(poly.xpoints, poly.ypoints, numNodes);
                if (this.hasBWArrow()) {
                    this.drawArrow(g, false);
                }
                if (this.hasFWArrow()) {
                    this.drawArrow(g, true);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawArrow(Graphics g, boolean forward) {
        block2: {
            nc = this.getNodeCount() - 1;
            startPoint = this.getNode(forward != false ? nc : 0).toPoint();
            next = forward != false ? nc - 1 : 1;
            nextPoint = null;
            if (!forward) ** GOTO lbl11
            while (next >= 0 && startPoint.equals(nextPoint = this.getNode(next).toPoint())) {
                --next;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                ++next;
lbl11:
                // 2 sources

                ** while (next <= nc && startPoint.equals((Object)(nextPoint = this.getNode((int)next).toPoint())))
            }
        }
        PTPolyline.drawArrow(g, startPoint, nextPoint);
    }

    @Override
    public Object clone() {
        PTPolyline targetShape = new PTPolyline();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTPolyline targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.nodes = new Vector(this.nodes.size());
        for (PTPoint node : this.nodes) {
            targetShape.addNode((PTPoint)node.clone());
        }
    }

    public PTPolygon convertToPolygon() {
        PTPolygon targetShape = new PTPolygon();
        for (PTPoint node : this.getNodes()) {
            targetShape.addNode(node);
        }
        targetShape.setDepth(this.getDepth());
        targetShape.setObjectName(this.getObjectName());
        Color c = this.getColor();
        targetShape.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue()));
        targetShape.setNum(this.getNum(false));
        return targetShape;
    }

    @Override
    public int getLength() {
        int result = 0;
        int i = 0;
        while (i < this.getNodeCount() - 1) {
            result += MSMath.dist(this.getNode(i).toPoint(), this.getNode(i + 1).toPoint());
            ++i;
        }
        return result;
    }

    @Override
    public Point getPointAtLength(int length) {
        int i = 0;
        while (i < this.getNodeCount() - 1) {
            Point b;
            Point a = this.getNode(i).toPoint();
            int lineLength = MSMath.dist(a, b = this.getNode(i + 1).toPoint());
            if (lineLength >= length) {
                float percent = 1.0f * (float)length / (float)lineLength;
                return new Point((int)((float)a.x + (float)(b.x - a.x) * percent), (int)((float)a.y + (float)(b.y - a.y) * percent));
            }
            length -= lineLength;
            ++i;
        }
        return this.getNode(0).toPoint();
    }

    @Override
    public void useAsMoveBase() {
        this.setFWArrow(true);
        this.setBWArrow(false);
    }

    @Override
    public boolean operationRequiresSpecialSelector(String operation) {
        return operation != null && operation.indexOf("Nodes") != -1;
    }

    @Override
    public String baseOperationName(String methodName) {
        if (methodName.endsWith("...")) {
            return methodName.substring(0, methodName.indexOf(46));
        }
        if (methodName.indexOf("Nodes") != 0) {
            return methodName.substring(0, methodName.indexOf(32));
        }
        return methodName;
    }

    @Override
    public boolean enableMultiSelectionFor(String operation) {
        return operation != null && operation.indexOf("Nodes") != -1;
    }

    public boolean compatibleMethod(String method) {
        return method != null && method.indexOf("Nodes") != -1;
    }

    @Override
    public Rectangle getBoundingBox() {
        if (this.getNodeCount() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = new Rectangle(this.getNode(0).toPoint());
        int i = 1;
        while (i < this.getNodeCount()) {
            Point p = this.getNode(i).toPoint();
            r = SwingUtilities.computeUnion(p.x, p.y, 0, 0, r);
            ++i;
        }
        return r;
    }

    @Override
    public void discard() {
        this.nodes.removeAllElements();
        this.nodes = null;
        super.discard();
    }
}

