/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTArray;
import animal.graphics.PTText;
import java.awt.Font;

public class PTDoubleArray
extends PTArray {
    public static final String TYPE_LABEL = "DoubleArray";

    public PTDoubleArray() {
        this.initializeWithDefaults(this.getType());
        int targetSize = this.getSize();
        if (targetSize == 0) {
            targetSize = 10;
        }
        this.init(targetSize);
    }

    public PTDoubleArray(int nrEntries) {
        this();
        this.init(nrEntries);
    }

    public PTDoubleArray(double[] x) {
        this(x.length);
        int i = 0;
        while (i < x.length) {
            this.enterValue(i, x[i]);
            ++i;
        }
    }

    public Object clone() {
        PTDoubleArray targetShape = new PTDoubleArray();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public int enterValue(int index, double val) {
        if (index >= 0 && index < this.entry.length) {
            this.entry[index].setText(String.valueOf(val));
            int delta = index == 0 ? this.cellWidth(0) - this.entryPos[0] : this.cellWidth(index) - this.getBoundingBox((int)index).width;
            int i = index;
            while (i < this.entry.length) {
                if (i == index) {
                    this.resizeCell(i, delta, false);
                } else {
                    this.translate(i, delta, 0, true, true);
                }
                this.entryPos[i] = this.entryPos[i] + delta;
                ++i;
            }
            return 0;
        }
        return -1;
    }

    public double getValue(int index) {
        if (index >= 0 && index < this.entry.length) {
            return Double.parseDouble(this.entry[index].getText());
        }
        return 0.0;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public int getFileVersion() {
        return 3;
    }

    public void enterStringValueAt(int index, String text) {
        double value = 0.0;
        try {
            value = Double.parseDouble(text);
            this.enterValue(index, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected PTText createInternalValue(int cellPosition, Font targetFont) {
        return new PTText(String.valueOf(String.valueOf(cellPosition)) + ".0", targetFont);
    }
}

