/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PTPoint;
import animal.graphics.meta.ClosedArcBasedShape;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTCircle
extends ClosedArcBasedShape
implements MoveBase,
Cloneable {
    public static final String TYPE_LABEL = "Circle";
    private int radius;
    private static final long serialVersionUID = 4711724437159551059L;

    public int getFileVersion() {
        return 1;
    }

    public PTCircle() {
        this.initializeWithDefaults(this.getType());
    }

    public void paint(Graphics g) {
        if (this.center == null) {
            return;
        }
        g.setColor(this.color);
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fillArc(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2, 0, 360);
        }
        g.setColor(this.color);
        if (!this.color.equals(this.getFillColor())) {
            g.drawArc(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2, 0, 360);
        }
    }

    public void rotate(double angle) {
        PTPoint centerNode = new PTPoint(this.center);
        centerNode.rotate(angle);
        this.center = centerNode.toPoint();
    }

    public void rotate(double angle, PTPoint centerPoint) {
        this.translate(-centerPoint.getX(), -centerPoint.getY());
        this.rotate(angle);
        this.translate(centerPoint.getX(), centerPoint.getY());
    }

    public void translate(int x, int y) {
        this.center.translate(x, y);
    }

    public void useAsMoveBase() {
        this.setFilled(false);
    }

    public int getAngle(Point p) {
        int xdist = p.x - this.center.x;
        int ydist = p.y - this.center.y;
        if (this.radius == 0) {
            return -1;
        }
        int angle = (int)(MSMath.getAngle(this.center, new Point(this.center.x + xdist * 100 / this.radius, this.center.y + ydist * 100 / this.radius)) * 180.0 / Math.PI);
        if (angle < 0) {
            angle += 360;
        }
        return angle;
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2);
    }

    public Point getCenter() {
        if (this.center == null) {
            this.center = new Point(10, 10);
        }
        return this.center;
    }

    public int getLength() {
        return 360;
    }

    public Point getPointAtLength(int alpha) {
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)this.center.x + (double)this.radius * Math.cos(x)), (int)((double)this.center.y - (double)this.radius * Math.sin(x)));
    }

    public int getRadius() {
        return this.radius;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setCenter(Point centerNode) {
        this.center = centerNode;
    }

    public void setCenter(int x, int y) {
        this.center = new Point(x, y);
    }

    public void setRadius(int r) {
        this.radius = r;
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
    }

    public Object clone() {
        PTCircle targetShape = new PTCircle();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTCircle targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setCenter(this.getCenter().x, this.getCenter().y);
        targetShape.setRadius(this.radius);
    }

    public void discard() {
        this.fillColor = null;
        super.discard();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PTCircle ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("center= (");
        sb.append(this.center.x).append(", ").append(this.center.y).append("), radius=");
        sb.append(this.radius);
        return sb.toString();
    }
}

