/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTMatrix;
import java.awt.Font;
import java.io.PrintWriter;

public abstract class PTMatrixExporter
extends PTGraphicObjectExporter {
    public void exportTo(PrintWriter pw, PTGraphicObject ptgo) {
        int c;
        PTMatrix matrix = (PTMatrix)ptgo;
        this.exportCommonStartAttributesTo(pw, matrix);
        this.exportNode(pw, matrix.getLocation());
        pw.print(" rowCount ");
        pw.print(matrix.getRowCount());
        pw.print(" columnsPerRow ");
        int row = 0;
        while (row < matrix.getRowCount()) {
            pw.print(matrix.getColumnCount(row));
            pw.print(" ");
            ++row;
        }
        pw.print("data {");
        int r = 0;
        while (r < matrix.getRowCount()) {
            pw.print("(");
            c = 0;
            while (c < matrix.getColumnCount(r)) {
                pw.print(this.getDataAt(r, c, matrix));
                if (c < matrix.getColumnCount(r) - 1) {
                    pw.print(" ");
                }
                ++c;
            }
            pw.print(")");
            if (r < matrix.getRowCount() - 1) {
                pw.print(" ");
            }
            ++r;
        }
        pw.print("}");
        pw.print(" cellStatus {");
        r = 0;
        while (r < matrix.getRowCount()) {
            pw.print("(");
            c = 0;
            while (c < matrix.getColumnCount(r)) {
                pw.print(matrix.getCellStatus(r, c));
                if (c < matrix.getColumnCount(r) - 1) {
                    pw.print(" ");
                }
                ++c;
            }
            pw.print(")");
            if (r < matrix.getRowCount() - 1) {
                pw.print(" ");
            }
            ++r;
        }
        pw.print("}");
        this.exportColor(pw, matrix.getColor(), " color");
        this.exportColor(pw, matrix.getFillColor(), "fillColor");
        this.exportColor(pw, matrix.getHighlightColor(), "highlightColor");
        this.exportColor(pw, matrix.getElemHighlightColor(), "elemHighlightColor");
        this.exportColor(pw, matrix.getTextColor(), "textColor");
        pw.print(" fillStatus ");
        pw.print(matrix.isFilled() ? 1 : 0);
        pw.print(" margins ");
        pw.print(String.valueOf(matrix.getMargin(0)) + " ");
        pw.print(String.valueOf(matrix.getMargin(1)) + " ");
        pw.print(String.valueOf(matrix.getMargin(2)) + " ");
        pw.print(matrix.getMargin(3));
        pw.print(" textAlignment \"");
        pw.print((Object)matrix.getTextAlignment());
        pw.print("\" rowAlignment \"");
        pw.print((Object)((Object)matrix.getRowAlignment()) + "\" ");
        Font font = matrix.getFont();
        pw.print(font.getName());
        pw.print(" style ");
        pw.print(font.getStyle());
        pw.print(" size ");
        pw.print(font.getSize());
        this.exportCommonEndAttributesTo(pw, matrix);
    }

    abstract String getDataAt(int var1, int var2, PTMatrix var3);
}

