/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectExporter;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTRectangle;
import animal.graphics.PTText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.PrintWriter;

public class PTBoxPointerExporter
extends PTGraphicObjectExporter {
    public void exportTo(PrintWriter pw, PTGraphicObject ptgo) {
        PTBoxPointer boxPointer = (PTBoxPointer)ptgo;
        PTPoint node = null;
        PTPolyline tmpPointer = null;
        pw.print(boxPointer.getFileVersion());
        pw.print(" object ");
        pw.print(boxPointer.getNum(false));
        Color color = boxPointer.getColor();
        pw.print(" BoxPointer color (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") fillColor (");
        color = boxPointer.getTextBox().getFillColor();
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") pointerAreaColor (");
        color = boxPointer.getPointerArea().getColor();
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") pointerFillColor (");
        color = boxPointer.getPointerArea().getFillColor();
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") textBox { ");
        PTRectangle box = boxPointer.getTextBox();
        int x = box.getFirstNode().x;
        int y = box.getFirstNode().y;
        Point dummy = new Point(x, y);
        this.exportNode(pw, dummy);
        dummy.setLocation(x + box.getWidth(), y);
        this.exportNode(pw, dummy);
        dummy.setLocation(x + box.getWidth(), y + box.getHeight());
        this.exportNode(pw, dummy);
        dummy.setLocation(x, y + box.getHeight());
        this.exportNode(pw, dummy);
        dummy.setLocation(x, y);
        this.exportNode(pw, dummy);
        pw.print(" } pointerArea {");
        box = boxPointer.getPointerArea();
        x = box.getFirstNode().x;
        y = box.getFirstNode().y;
        dummy.setLocation(x, y);
        this.exportNode(pw, dummy);
        dummy.setLocation(x + box.getWidth(), y);
        this.exportNode(pw, dummy);
        dummy.setLocation(x + box.getWidth(), y + box.getHeight());
        this.exportNode(pw, dummy);
        dummy.setLocation(x, y + box.getHeight());
        this.exportNode(pw, dummy);
        dummy.setLocation(x, y);
        this.exportNode(pw, dummy);
        pw.print("} pointerPosition ");
        pw.print(boxPointer.getPointerPosition());
        pw.print(" pointers {");
        PTPolyline[] pointers = boxPointer.getPointers();
        if (pointers != null) {
            int n = pointers.length;
            int i = 0;
            while (i < n) {
                tmpPointer = pointers[i];
                int m = tmpPointer.getNodeCount();
                pw.print(" { ");
                int j = 0;
                while (j < m) {
                    node = tmpPointer.getNode(j);
                    pw.print("(");
                    pw.print(node.getX());
                    pw.print(", ");
                    pw.print(node.getY());
                    pw.print(") ");
                    ++j;
                }
                pw.print("}");
                ++i;
            }
        }
        pw.print(" } text: \"");
        pw.print(PTText.escapeText(boxPointer.getTextComponent().getText()));
        color = boxPointer.getTextComponent().getColor();
        pw.print("\" textColor (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(")");
        Font font = boxPointer.getTextComponent().getFont();
        pw.print(" Font {\"");
        pw.print(font.getName());
        pw.print("\" ");
        pw.print(font.getStyle());
        pw.print(" ");
        pw.print(font.getSize());
        pw.print(" }");
        pw.print(" depth ");
        pw.println(boxPointer.getDepth());
    }
}

