/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.exchange.AnimationExporter;
import animal.exchange.tikz.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.gui.GraphicVector;
import animal.gui.GraphicVectorEntry;
import animal.main.AnimationState;
import animal.misc.MessageDisplay;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;

public class TikZExporter
extends AnimationExporter {
    private Hashtable<String, PTGraphicObjectExporter> tikzExporters;

    public boolean exportAnimationTo(String fileName) {
        BufferedOutputStream oStream = null;
        try {
            oStream = new BufferedOutputStream(new FileOutputStream(fileName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDisplay.errorMsg(fileNotFoundException.getMessage(), 4);
        }
        if (oStream == null) {
            return false;
        }
        return this.exportAnimationTo(oStream);
    }

    public boolean exportAnimationTo(OutputStream oStream) {
        PrintWriter writer = new PrintWriter(oStream);
        AnimationState animState = new AnimationState(this.animationToExport);
        GraphicVector objectsAtStep = null;
        int currentStep = animState.getFirstRealStep();
        PTGraphicObjectExporter currentExporter = null;
        while (animState.getNextStep() != Integer.MAX_VALUE) {
            animState.setStep(currentStep, true);
            if (this.exportSteps[currentStep]) {
                GraphicVectorEntry[] objects;
                writer.println();
                writer.print("% animation step: ");
                writer.println(currentStep);
                writer.println("\\begin{tikzpicture}");
                objectsAtStep = animState.getCurrentObjects();
                GraphicVectorEntry[] graphicVectorEntryArray = objects = objectsAtStep.convertToArray();
                int n = 0;
                int n2 = graphicVectorEntryArray.length;
                while (n < n2) {
                    GraphicVectorEntry currentObject = graphicVectorEntryArray[n];
                    PTGraphicObject ptgo = currentObject.getGraphicObject();
                    String className = ptgo.getClass().getName();
                    currentExporter = this.retrieveExporterForClassName(className);
                    if (currentExporter != null) {
                        currentExporter.exportTo(writer, ptgo);
                    } else {
                        writer.println("%" + ptgo.toString());
                    }
                    ++n;
                }
                writer.println("\\end{tikzpicture}");
            }
            currentStep = animState.getNextStep();
        }
        try {
            writer.close();
            oStream.close();
        }
        catch (IOException ioException) {
            System.err.println("An Error occured trying to close the stream");
        }
        return true;
    }

    private PTGraphicObjectExporter retrieveExporterForClassName(String className) {
        if (this.tikzExporters.containsKey(className)) {
            System.err.println("\tretrieved exporter: " + this.tikzExporters.get(className).getClass().getName());
            return this.tikzExporters.get(className);
        }
        StringBuilder handlerName = new StringBuilder("animal.exchange.tikz.");
        handlerName.append(className.substring(className.lastIndexOf(46) + 1));
        handlerName.append("Exporter");
        System.err.println("\t\tneed to retrieve handler " + handlerName.toString());
        Class<?> c = null;
        PTGraphicObjectExporter handler = null;
        try {
            c = Class.forName(handlerName.toString());
            handler = (PTGraphicObjectExporter)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (handler != null) {
            System.err.println("\t\treceived " + handler.getClass().getName());
            this.tikzExporters.put(className, handler);
        }
        return handler;
    }

    public String getDefaultExtension() {
        return "tex";
    }

    public String getFormatDescription() {
        return "TikZ LaTeX format";
    }

    public String getMIMEType() {
        return "text/tex-tikz";
    }

    public void init(String format) {
        super.init(format);
        this.tikzExporters = new Hashtable(73);
        this.exportCapabilities = 13;
    }
}

