/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.graphics.GraphicEditor;
import animal.graphics.PTArc;
import animal.main.Animal;
import animal.misc.ColorChooserAction;
import animal.misc.TextUtilities;
import java.awt.Color;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public abstract class AbstractTextEditor
extends GraphicEditor {
    protected JTextField textField;
    protected JComboBox fontName;
    protected JComboBox fontSize;
    protected JCheckBox bold;
    protected JCheckBox italic;
    protected ColorChooserAction textColorChooser;

    public Box generateTextOperationsBox(TranslatableGUIElement generator, String borderKey) {
        Box textEntryBox = generator.generateBorderedBox(3, borderKey);
        this.textField = new JTextField(16);
        this.textField.addActionListener(this);
        textEntryBox.add(this.textField);
        Box textEditBox = new Box(2);
        Action theAction = TextUtilities.findTextFieldAction("cut-to-clipboard");
        textEditBox.add(generator.generateActionButton("AbstractTextEditor.cut", null, theAction));
        theAction = TextUtilities.findTextFieldAction("copy-to-clipboard");
        textEditBox.add(generator.generateActionButton("AbstractTextEditor.copy", null, theAction));
        theAction = TextUtilities.findTextFieldAction("paste-from-clipboard");
        textEditBox.add(generator.generateActionButton("AbstractTextEditor.paste", null, theAction));
        textEntryBox.add(textEditBox);
        return textEntryBox;
    }

    public Box generateTextComponentBox(TranslatableGUIElement generator) {
        Box textBox = generator.generateBorderedBox(3, "AbstractTextEditor.textCompBL");
        textBox.add(this.generateTextOperationsBox(generator, "AbstractTextEditor.textBL"));
        textBox.add(this.generateFontAndStyleBox(generator, "AbstractTextEditor.fontBL"));
        Box textColorBox = generator.generateBorderedBox(2, "textColorBL");
        textColorBox.add(generator.generateJLabel("GenericEditor.colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTArc)this.getCurrentObject()).getTextComponent().getColor();
        this.textColorChooser = this.createColorChooser("textColor", "AbstractTextEditor.textColor", initialColor);
        textColorBox.add(new ExtendedActionButton(this.textColorChooser, 84));
        textBox.add(textColorBox);
        return textBox;
    }

    public Box generateFontAndStyleBox(TranslatableGUIElement generator, String borderKey) {
        Box fontBox = generator.generateBorderedBox(3, borderKey);
        Box fontNameBox = new Box(2);
        fontNameBox.add(AnimalTranslator.getGUIBuilder().generateJLabel("GenericEditor.nameLabel"));
        String[] fonts = Animal.GLOBAL_FONTS;
        this.fontName = new JComboBox();
        int j = 0;
        while (j < fonts.length) {
            this.fontName.addItem(fonts[j]);
            ++j;
        }
        this.fontName.addActionListener(this);
        fontNameBox.add(this.fontName);
        fontBox.add(fontNameBox);
        Box fontSizeBox = new Box(2);
        fontSizeBox.add(generator.generateJLabel("AbstractTextEditor.fontSizeLabel"));
        this.fontSize = new JComboBox();
        this.fontSize.setEditable(true);
        this.fontSize.addItem("8");
        this.fontSize.addItem("10");
        this.fontSize.addItem("12");
        this.fontSize.addItem("14");
        this.fontSize.addItem("16");
        this.fontSize.addItem("24");
        this.fontSize.setSelectedItem("12");
        this.fontSize.addActionListener(this);
        fontSizeBox.add(this.fontSize);
        fontBox.add(fontSizeBox);
        Box fontTypeBox = new Box(2);
        fontTypeBox.add(generator.generateJLabel("AbstractTextEditor.fontStyleLabel"));
        this.italic = generator.generateJCheckBox("italic", null, this);
        this.italic.setHorizontalAlignment(0);
        fontTypeBox.add(this.italic);
        this.bold = generator.generateJCheckBox("bold", null, this);
        this.bold.setHorizontalAlignment(0);
        fontTypeBox.add(this.bold);
        fontBox.add(fontTypeBox);
        return fontBox;
    }
}

