/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.Editor;
import animal.editor.MethodSelectionListener;
import java.util.Vector;

public abstract class SpecialSelector {
    protected Editor parentEditor;
    protected String baseMethodName;
    protected boolean allowMultipleSelection = false;
    protected String effectiveMethodName;
    protected Vector<MethodSelectionListener> listeners = new Vector(20);

    public SpecialSelector(Editor callingEditor, String methodBaseName, boolean enableMultipleMode) {
        this.setParentEditor(callingEditor);
        this.setBaseMethodName(methodBaseName);
        this.setMultipleSelectionMode(enableMultipleMode);
    }

    public void addMethodSelectionListener(MethodSelectionListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeMethodSelectionListener(MethodSelectionListener listener) {
        if (listener != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void setParentEditor(Editor callingEditor) {
        this.parentEditor = callingEditor;
    }

    public void setBaseMethodName(String methodBaseName) {
        this.baseMethodName = methodBaseName;
    }

    public void setMultipleSelectionMode(boolean enableMultipleMode) {
        this.allowMultipleSelection = enableMultipleMode;
    }

    public String getEffectiveMethodName() {
        return this.effectiveMethodName;
    }

    protected void notifyListeners(String newMethodName) {
        for (MethodSelectionListener listener : this.listeners) {
            listener.addMethodSelection(newMethodName);
            listener.selectMethodSelection(newMethodName);
        }
    }
}

