/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.graphics.PTGraphicObject;
import animal.graphics.meta.IndexableContentContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedContentChooser
implements ActionListener {
    private PTGraphicObject[] objects;
    public static final String INDEXED_CONTENT_CHOOSER_KIND_OF_OBJECT_LABEL = "kindOfObjectLabel";
    public static final String INDEXED_CONTENT_CHOOSER_METHOD_LABEL = "AnimatorEditor.methodLabel";
    public static final String INDEXED_CONTENT_CHOOSER_NO_METHOD_ENTRY = "AnimatorEditor.noAppropriateMethod";
    private Box contentBox;
    private Box indexBox;
    private boolean showOnlyObjectsWithMethods = false;
    protected JComboBox kindOfObjectCB;
    protected JComboBox methodCB;
    protected Vector<JComboBox> dimensionCBs;
    private Vector<JLabel> dimensionLabels;
    protected Hashtable<String, IndexableObjectInformation> indexableObjects;
    private Hashtable<String, String> translationOfIndexableObjects;

    public IndexedContentChooser(String boxLabel) {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.contentBox = generator.generateBorderedBox(3, boxLabel);
        Box kindOfObjectBox = new Box(2);
        kindOfObjectBox.add(generator.generateJLabel(INDEXED_CONTENT_CHOOSER_KIND_OF_OBJECT_LABEL));
        this.kindOfObjectCB = new JComboBox();
        this.kindOfObjectCB.addActionListener(this);
        kindOfObjectBox.add(this.kindOfObjectCB);
        this.contentBox.add(kindOfObjectBox);
        Box methodBox = new Box(2);
        methodBox.add(generator.generateJLabel(INDEXED_CONTENT_CHOOSER_METHOD_LABEL));
        this.methodCB = new JComboBox();
        this.methodCB.addActionListener(this);
        methodBox.add(this.methodCB);
        this.contentBox.add(methodBox);
        this.indexBox = new Box(3);
        this.contentBox.add(this.indexBox);
        this.indexableObjects = new Hashtable();
        this.translationOfIndexableObjects = new Hashtable();
        this.dimensionCBs = new Vector();
        this.dimensionLabels = new Vector();
    }

    public void setData(PTGraphicObject[] objects, Vector<String> methods) {
        this.setObjects(objects);
        this.setMethods(methods);
    }

    protected void setObjects(PTGraphicObject[] objects) {
        if (objects != this.objects) {
            this.objects = objects;
            this.updateKindOfObjectData();
        }
    }

    private void updateKindOfObjectData() {
        if (this.objects != null && this.objects.length > 0 && this.allObjectsAreIndexableContentContainer()) {
            this.createSetOfIndexableObjects();
            this.createIndexTrees();
            this.initializeKindOfObjectBoxModel();
        } else {
            this.kindOfObjectCB.setModel(new DefaultComboBoxModel());
        }
    }

    private void initializeKindOfObjectBoxModel() {
        DefaultComboBoxModel<String> kindOfObjectModel = new DefaultComboBoxModel<String>();
        IndexableObjectInformation tmpInfo2 = null;
        for (IndexableObjectInformation tmpInfo2 : this.indexableObjects.values()) {
            if (this.showOnlyObjectsWithMethods && (tmpInfo2.getMethodModel() == null || tmpInfo2.getMethodModel().getSize() <= 0)) continue;
            String identifierTranslation = AnimalTranslator.translateMessage(tmpInfo2.getIdentifier());
            this.translationOfIndexableObjects.put(identifierTranslation, tmpInfo2.getIdentifier());
            kindOfObjectModel.addElement(identifierTranslation);
        }
        this.kindOfObjectCB.setModel(kindOfObjectModel);
        if (this.kindOfObjectCB.getModel().getSize() > 0) {
            this.kindOfObjectCB.setSelectedIndex(0);
        }
    }

    private void createIndexTrees() {
        IndexableObjectInformation tmpInfo2 = null;
        for (IndexableObjectInformation tmpInfo2 : this.indexableObjects.values()) {
            this.createIndexInformation(tmpInfo2);
        }
    }

    private void createIndexInformation(IndexableObjectInformation tmpInfo) {
        boolean equalAmountOfDimensions = true;
        String[] dimensionIdentifiers = ((IndexableContentContainer)((Object)this.objects[0])).getDimensionIdentifiers(tmpInfo.getIdentifier());
        int i = 1;
        while (i < this.objects.length) {
            if (dimensionIdentifiers.length != ((IndexableContentContainer)((Object)this.objects[i])).getDimensionIdentifiers(tmpInfo.getIdentifier()).length) {
                equalAmountOfDimensions = false;
            }
            ++i;
        }
        if (!equalAmountOfDimensions) {
            this.indexableObjects.remove(tmpInfo.getIdentifier());
        } else {
            Vector<Integer> indices = new Vector<Integer>(dimensionIdentifiers.length);
            DimensionData root = new DimensionData(dimensionIdentifiers[0], AnimalTranslator.translateMessage(dimensionIdentifiers[0]));
            this.createDimensionDataTree(root, dimensionIdentifiers, 0, indices, tmpInfo.getIdentifier());
            tmpInfo.setPrimaryDimension(root);
        }
    }

    private void createDimensionDataTree(DimensionData root, String[] dimensionIdentifiers, int depth, Vector<Integer> indices, String kindOfObject) {
        int dimensionLength = this.getDimensionLengthIntersection(kindOfObject, indices, root.getIdentifier());
        root.setIndexCount(dimensionLength);
        if (++depth < dimensionIdentifiers.length) {
            DimensionData[] subDimensionDataObjects = new DimensionData[dimensionLength];
            String translatedIdentifier = AnimalTranslator.translateMessage(dimensionIdentifiers[depth]);
            int i = 0;
            while (i < dimensionLength) {
                DimensionData tmpData;
                subDimensionDataObjects[i] = tmpData = new DimensionData(dimensionIdentifiers[depth], translatedIdentifier);
                indices.add(i);
                this.createDimensionDataTree(tmpData, dimensionIdentifiers, depth, indices, kindOfObject);
                indices.remove(indices.size() - 1);
                ++i;
            }
            root.setSubDimensions(subDimensionDataObjects);
        }
    }

    private int getDimensionLengthIntersection(String kindOfObject, Vector<Integer> indices, String dimensionIdentifier) {
        int length = ((IndexableContentContainer)((Object)this.objects[0])).getDimensionLength(kindOfObject, dimensionIdentifier, indices);
        int i = 1;
        while (i < this.objects.length) {
            if (((IndexableContentContainer)((Object)this.objects[i])).getDimensionLength(kindOfObject, dimensionIdentifier, indices) < length) {
                length = ((IndexableContentContainer)((Object)this.objects[i])).getDimensionLength(kindOfObject, dimensionIdentifier, indices);
            }
            ++i;
        }
        return length;
    }

    private void createSetOfIndexableObjects() {
        IndexableContentContainer tmpObject = (IndexableContentContainer)((Object)this.objects[0]);
        String[] tmpKindsOfObject = tmpObject.getKindsOfObjects();
        int i = 1;
        while (i < this.objects.length) {
            tmpKindsOfObject = this.intersect(tmpKindsOfObject, ((IndexableContentContainer)((Object)this.objects[i])).getKindsOfObjects());
            ++i;
        }
        this.indexableObjects.clear();
        i = 0;
        while (i < tmpKindsOfObject.length) {
            this.indexableObjects.put(tmpKindsOfObject[i], new IndexableObjectInformation(tmpKindsOfObject[i]));
            ++i;
        }
    }

    public String[] intersect(String[] a, String[] b) {
        Vector<String> tmpValues = new Vector<String>();
        int i = 0;
        while (i < a.length) {
            boolean found = false;
            int j = 0;
            while (j < b.length) {
                if (b[j].equals(a[i])) {
                    found = true;
                }
                ++j;
            }
            if (found) {
                tmpValues.add(a[i]);
            }
            ++i;
        }
        String[] ret = new String[tmpValues.size()];
        return tmpValues.toArray(ret);
    }

    private boolean allObjectsAreIndexableContentContainer() {
        int i = 0;
        while (i < this.objects.length) {
            if (!(this.objects[i] instanceof IndexableContentContainer)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void setMethods(Vector<String> methods) {
        Hashtable objectMethods = new Hashtable();
        int i = 0;
        while (i < methods.size()) {
            String[] tokens = methods.get(i).split("\\s");
            if (tokens.length > 1 && this.indexableObjects.containsKey(tokens[0])) {
                String methodIdentifier = "";
                int j = 1;
                while (j < tokens.length) {
                    methodIdentifier = String.valueOf(methodIdentifier) + tokens[j];
                    if (j < tokens.length - 1) {
                        methodIdentifier = String.valueOf(methodIdentifier) + " ";
                    }
                    ++j;
                }
                if (objectMethods.containsKey(tokens[0])) {
                    ((HashSet)objectMethods.get(tokens[0])).add(methodIdentifier);
                } else {
                    HashSet<String> tmpSet = new HashSet<String>();
                    tmpSet.add(methodIdentifier);
                    objectMethods.put(tokens[0], tmpSet);
                }
            }
            ++i;
        }
        for (String objectIdentifier : this.indexableObjects.keySet()) {
            if (!objectMethods.containsKey(objectIdentifier)) continue;
            String[] tmpArray = new String[((HashSet)objectMethods.get(objectIdentifier)).size()];
            this.indexableObjects.get(objectIdentifier).setMethodIdentifiers(((HashSet)objectMethods.get(objectIdentifier)).toArray(tmpArray));
        }
        if (this.showOnlyObjectsWithMethods) {
            this.initializeKindOfObjectBoxModel();
        }
        this.setObjectWithMethods();
        if (this.kindOfObjectCB != null && this.kindOfObjectCB.getModel() != null && this.kindOfObjectCB.getModel().getSelectedItem() != null) {
            String selectedMethod = this.getSelectedMethod();
            this.setMethodsBox(this.getObjectInformation((String)this.kindOfObjectCB.getModel().getSelectedItem()).getIdentifier());
            if (selectedMethod != null) {
                this.methodCB.setSelectedItem(selectedMethod);
            }
        }
    }

    private void setObjectWithMethods() {
        String selectedObject;
        if (this.kindOfObjectCB != null && this.kindOfObjectCB.getModel() != null && ((selectedObject = this.getSelectedKindOfObject()) == null || this.indexableObjects.get(selectedObject).getMethodModel() == null || this.indexableObjects.get(selectedObject).getMethodModel().getSize() == 0)) {
            for (IndexableObjectInformation info : this.indexableObjects.values()) {
                if (info.getMethodModel() == null || info.getMethodModel().getSize() <= 0) continue;
                this.kindOfObjectCB.setSelectedItem(AnimalTranslator.translateMessage(info.identifier));
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.kindOfObjectCB) {
            this.setMethodsBox(this.getObjectInformation((String)this.kindOfObjectCB.getSelectedItem()).getIdentifier());
        } else if (e.getSource() == this.methodCB) {
            this.setIndexBoxes((String)this.kindOfObjectCB.getSelectedItem(), this.getSelectedMethod());
        } else {
            this.handleIndexChange(e);
        }
    }

    private void setIndexBoxes(String selectedObject, String selectedMethod) {
        IndexableObjectInformation tmpInfo = this.getObjectInformation(selectedObject);
        int dimensionCount = tmpInfo.getDimensionCount();
        if (this.dimensionCBs == null) {
            this.dimensionCBs = new Vector();
        }
        if (this.dimensionLabels == null) {
            this.dimensionLabels = new Vector();
        }
        int toAdd = dimensionCount - this.dimensionCBs.size();
        int i = 0;
        while (i < toAdd) {
            JComboBox tmpCB = new JComboBox();
            tmpCB.addActionListener(this);
            this.dimensionCBs.add(tmpCB);
            ++i;
        }
        toAdd = dimensionCount - this.dimensionLabels.size();
        i = 0;
        while (i < toAdd) {
            this.dimensionLabels.add(new JLabel());
            ++i;
        }
        Vector<String> translatedDimensionIdentifiers = new Vector<String>();
        this.getObjectInformation(selectedObject).getPrimaryDimension().getTranslatedDimensionIdentifiers(translatedDimensionIdentifiers);
        int i2 = this.indexBox.getComponentCount();
        while (i2 < this.dimensionCBs.size()) {
            Box tmpBox = new Box(2);
            tmpBox.add(this.dimensionLabels.get(i2));
            tmpBox.add(this.dimensionCBs.get(i2));
            this.indexBox.add(tmpBox);
            ++i2;
        }
        i2 = 0;
        while (i2 < dimensionCount) {
            this.dimensionLabels.get(i2).setVisible(true);
            this.dimensionLabels.get(i2).setText(translatedDimensionIdentifiers.get(i2));
            this.dimensionCBs.get(i2).setVisible(true);
            ++i2;
        }
        i2 = dimensionCount;
        while (i2 < this.dimensionCBs.size()) {
            this.dimensionLabels.get(i2).setVisible(false);
            this.dimensionCBs.get(i2).setVisible(false);
            ++i2;
        }
        if (this.dimensionCBs.size() > 0 && this.dimensionCBs.get(0) != null) {
            this.dimensionCBs.get(0).setModel(tmpInfo.getPrimaryDimension().getComboBoxModel(0, new Vector<Integer>()));
            if (this.dimensionCBs.get(0).getModel().getSize() > 0) {
                this.dimensionCBs.get(0).setSelectedIndex(0);
            }
        }
    }

    protected IndexableObjectInformation getObjectInformation(String selectedObject) {
        return this.indexableObjects.get(this.translationOfIndexableObjects.get(selectedObject));
    }

    private void setMethodsBox(String selectedItem) {
        this.methodCB.removeActionListener(this);
        this.methodCB.setModel(this.indexableObjects.get(selectedItem).getMethodModel());
        this.methodCB.addActionListener(this);
        if (this.methodCB.getModel() != null && this.methodCB.getModel().getSize() > 0) {
            this.methodCB.setSelectedIndex(0);
        } else {
            this.methodCB.removeActionListener(this);
            String noMethod = AnimalTranslator.translateMessage(INDEXED_CONTENT_CHOOSER_NO_METHOD_ENTRY);
            String[] methodEntries = new String[]{noMethod};
            this.methodCB.setModel(new DefaultComboBoxModel<String>(methodEntries));
            this.hideIndexBoxes();
        }
    }

    private void hideIndexBoxes() {
        int i;
        if (this.dimensionCBs != null) {
            i = 0;
            while (i < this.dimensionCBs.size()) {
                this.dimensionCBs.get(i).setVisible(false);
                ++i;
            }
        }
        if (this.dimensionLabels != null) {
            i = 0;
            while (i < this.dimensionLabels.size()) {
                this.dimensionLabels.get(i).setVisible(false);
                ++i;
            }
        }
    }

    private void handleIndexChange(ActionEvent e) {
        Vector<Integer> chosenIndices = new Vector<Integer>();
        int i = 0;
        while (i < this.dimensionCBs.size()) {
            if (this.dimensionCBs.get(i).getModel().getSize() > 0 && this.dimensionCBs.get(i).getSelectedIndex() > -1) {
                chosenIndices.add(this.getSelectedIntValue(i));
            }
            if (this.dimensionCBs.get(i) == e.getSource()) {
                ++i;
                break;
            }
            ++i;
        }
        if (chosenIndices.size() == i) {
            this.updateDimensionBoxModels(chosenIndices);
        } else {
            this.clearBoxes(i);
        }
    }

    private void clearBoxes(int i) {
        while (i < this.dimensionCBs.size()) {
            this.dimensionCBs.get(i).setModel(new DefaultComboBoxModel());
            ++i;
        }
    }

    protected void updateDimensionBoxModels(Vector<Integer> chosenIndices) {
        int i = chosenIndices.size();
        IndexableObjectInformation tmpInfo = this.getObjectInformation((String)this.kindOfObjectCB.getSelectedItem());
        int indexChangeIndex = i;
        while (i < tmpInfo.getDimensionCount()) {
            this.dimensionCBs.get(i).removeActionListener(this);
            String selectedValue = (String)this.dimensionCBs.get(i).getSelectedItem();
            this.dimensionCBs.get(i).setModel(tmpInfo.getPrimaryDimension().getComboBoxModel(i, chosenIndices));
            if (selectedValue != null) {
                this.dimensionCBs.get(i).setSelectedItem(selectedValue);
            } else if (this.dimensionCBs.get(i).getModel().getSize() > 0) {
                this.dimensionCBs.get(i).setSelectedIndex(0);
            } else {
                i = tmpInfo.getDimensionCount();
            }
            chosenIndices.add(this.getSelectedIntValue(i));
            ++i;
        }
        while (indexChangeIndex < tmpInfo.getDimensionCount()) {
            this.dimensionCBs.get(indexChangeIndex).addActionListener(this);
            ++indexChangeIndex;
        }
    }

    protected Integer getSelectedIntValue(int i) {
        block3: {
            if (this.dimensionCBs != null && i >= 0 && i < this.dimensionCBs.size() && this.dimensionCBs.get(i).getModel().getSize() > 0) {
                String selectedString = (String)this.dimensionCBs.get(i).getSelectedItem();
                try {
                    return Integer.parseInt(selectedString);
                }
                catch (NumberFormatException e) {
                    if (!((String)this.dimensionCBs.get(i).getSelectedItem()).equals(AnimalTranslator.translateMessage("all"))) break block3;
                    return -1;
                }
            }
        }
        return null;
    }

    public Box getContentBox() {
        return this.contentBox;
    }

    public String getSelectedKindOfObject() {
        if (this.kindOfObjectCB.getSelectedItem() != null) {
            return this.getObjectInformation(this.kindOfObjectCB.getSelectedItem().toString()).getIdentifier();
        }
        return null;
    }

    public String getSelectedMethod() {
        IndexableObjectInformation tmpInfo;
        if (this.kindOfObjectCB != null && this.kindOfObjectCB.getSelectedItem() != null && (tmpInfo = this.getObjectInformation(this.kindOfObjectCB.getSelectedItem().toString())) != null) {
            return String.valueOf(tmpInfo.getIdentifier()) + " " + tmpInfo.getIdentifierOfSelectedMethod();
        }
        return "";
    }

    public Vector<Integer> getSelectedIndices() {
        Vector<Integer> returnValue = new Vector<Integer>();
        if (this.kindOfObjectCB.getSelectedItem() != null) {
            int i = 0;
            while (i < this.getObjectInformation(this.kindOfObjectCB.getSelectedItem().toString()).getDimensionCount()) {
                Integer tmp = this.getSelectedIntValue(i);
                if (tmp == null) {
                    return new Vector<Integer>();
                }
                returnValue.add(tmp);
                ++i;
            }
        }
        return returnValue;
    }

    public void updateIndexSets() {
        Vector<Integer> selectedIndices = this.getSelectedIndices();
        this.createIndexTrees();
        this.setIndexBoxes((String)this.kindOfObjectCB.getSelectedItem(), this.getSelectedMethod());
        int i = 0;
        while (i < selectedIndices.size()) {
            if (selectedIndices.get(i) != -1) {
                this.dimensionCBs.get(i).setSelectedItem(String.valueOf(selectedIndices.get(i)));
            } else {
                this.dimensionCBs.get(i).setSelectedItem(AnimalTranslator.translateMessage("all"));
            }
            ++i;
        }
    }

    public void setShowOnlyObjectsWithMethods(boolean value) {
        this.showOnlyObjectsWithMethods = value;
    }

    class IndexableObjectInformation {
        private String identifier;
        private String[] dimensions;
        private Hashtable<String, String> methodIdentifiers;
        private DefaultComboBoxModel methodModel;
        private DimensionData primaryDimension;

        public IndexableObjectInformation(String identifier) {
            this.identifier = identifier;
            this.methodModel = new DefaultComboBoxModel();
            this.methodIdentifiers = new Hashtable();
            this.dimensions = new String[0];
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String[] getDimensions() {
            return this.dimensions;
        }

        public ComboBoxModel getMethodModel() {
            return this.methodModel;
        }

        public DimensionData getPrimaryDimension() {
            return this.primaryDimension;
        }

        public int getDimensionCount() {
            if (this.dimensions == null) {
                return 0;
            }
            return this.dimensions.length;
        }

        public String getIdentifierOfSelectedMethod() {
            if (this.methodModel != null && this.methodModel.getSelectedItem() != null) {
                return this.methodIdentifiers.get(this.methodModel.getSelectedItem());
            }
            return null;
        }

        public void setMethodIdentifiers(String[] methodIdentifiers) {
            this.methodModel.removeAllElements();
            this.methodIdentifiers.clear();
            String[] translatedMethods = this.getTranslatedStrings(methodIdentifiers);
            int i = 0;
            while (i < translatedMethods.length) {
                this.methodModel.addElement(translatedMethods[i]);
                this.methodIdentifiers.put(translatedMethods[i], methodIdentifiers[i]);
                ++i;
            }
        }

        public void setPrimaryDimension(DimensionData primaryDimension) {
            this.primaryDimension = primaryDimension;
            Vector<String> dimensionIdentifiers = new Vector<String>(this.getDimensionCount());
            primaryDimension.getDimensionIdentifiers(dimensionIdentifiers);
            this.dimensions = dimensionIdentifiers.toArray(this.dimensions);
        }

        private String[] getTranslatedStrings(String[] values) {
            String[] ret = new String[values.length];
            int i = 0;
            while (i < ret.length) {
                ret[i] = AnimalTranslator.translateMessage(values[i]);
                ++i;
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DimensionData {
        public static final String DIMENSION_INDEX_ALL = "all";
        private String identifier;
        private String translatedIdentifier;
        private DimensionData[] subDimensionData;
        private DefaultComboBoxModel dimensionModel;
        private int indexCount = 0;

        public DimensionData(String identifier, String translatedIdentifier) {
            this.identifier = identifier;
            this.translatedIdentifier = translatedIdentifier;
            this.dimensionModel = new DefaultComboBoxModel();
        }

        public int getIndexCount() {
            return this.indexCount;
        }

        public void getDimensionIdentifiers(Vector<String> methodIdentifiers) {
            methodIdentifiers.add(this.translatedIdentifier);
            if (this.subDimensionData != null && this.subDimensionData.length > 0) {
                this.subDimensionData[0].getDimensionIdentifiers(methodIdentifiers);
            }
        }

        public void getTranslatedDimensionIdentifiers(Vector<String> methodIdentifiers) {
            methodIdentifiers.add(this.translatedIdentifier);
            if (this.subDimensionData != null && this.subDimensionData.length > 0) {
                this.subDimensionData[0].getDimensionIdentifiers(methodIdentifiers);
            }
        }

        public DimensionData getDimensionDataAt(int index) {
            if (this.subDimensionData != null && index >= 0 && index < this.subDimensionData.length) {
                return this.subDimensionData[index];
            }
            return null;
        }

        public DimensionData[] getDimensionData() {
            return this.subDimensionData;
        }

        public ComboBoxModel getComboBoxModel(int depth, Vector<Integer> indices) {
            if (depth < indices.size() + 1) {
                return this.getDimensionComboBoxModel(depth, 0, indices);
            }
            return null;
        }

        private ComboBoxModel getDimensionComboBoxModel(int depth, int actualDepth, Vector<Integer> indices) {
            if (depth == actualDepth) {
                return this.dimensionModel;
            }
            if (this.subDimensionData != null && this.subDimensionData.length > 0) {
                if (indices.get(actualDepth) == -1) {
                    return this.subDimensionData[0].getIntersectedComboBoxModel(depth, ++actualDepth, indices, this.subDimensionData);
                }
                if (indices.get(actualDepth) >= 0 && indices.get(actualDepth) < this.getIndexCount()) {
                    return this.subDimensionData[indices.get(actualDepth)].getDimensionComboBoxModel(depth, ++actualDepth, indices);
                }
            }
            return null;
        }

        private ComboBoxModel getIntersectedComboBoxModel(int depth, int actualDepth, Vector<Integer> indices, DimensionData[] neighbors) {
            if (depth == actualDepth) {
                return this.getIntersectedComboBoxModel(neighbors);
            }
            if (this.subDimensionData != null && this.subDimensionData.length > 0) {
                if (indices.get(actualDepth) == -1) {
                    return this.subDimensionData[0].getIntersectedComboBoxModel(depth, actualDepth + 1, indices, this.getSubdimensionNeighbors(neighbors, indices.get(actualDepth)));
                }
                if (indices.get(actualDepth) >= 0 && indices.get(actualDepth) < this.getIndexCount()) {
                    return this.subDimensionData[indices.get(actualDepth)].getIntersectedComboBoxModel(depth, actualDepth + 1, indices, this.getSubdimensionNeighbors(neighbors, indices.get(actualDepth)));
                }
            }
            return null;
        }

        private DimensionData[] getSubdimensionNeighbors(DimensionData[] neighbors, int index) {
            Vector<DimensionData> returnValues = new Vector<DimensionData>();
            if (index == -1) {
                int i = 0;
                while (i < neighbors.length) {
                    if (neighbors[i].getDimensionData() != null) {
                        DimensionData[] tmpDimensionData = neighbors[i].getDimensionData();
                        int j = 0;
                        while (j < tmpDimensionData.length) {
                            returnValues.add(tmpDimensionData[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < neighbors.length) {
                    if (neighbors[i].getDimensionDataAt(index) != null) {
                        returnValues.add(neighbors[i].getDimensionDataAt(index));
                    }
                    ++i;
                }
            }
            return (DimensionData[])returnValues.toArray();
        }

        private ComboBoxModel getIntersectedComboBoxModel(DimensionData[] neighbors) {
            TreeSet<String> values = new TreeSet<String>();
            values.addAll(this.getSelectableStrings());
            int i = 1;
            while (i < neighbors.length) {
                values.retainAll(neighbors[i].getSelectableStrings());
                ++i;
            }
            return new DefaultComboBoxModel<Object>(values.toArray());
        }

        private Set<String> getSelectableStrings() {
            HashSet<String> ret = new HashSet<String>();
            if (this.dimensionModel != null) {
                int i = 0;
                while (i < this.dimensionModel.getSize()) {
                    ret.add(this.dimensionModel.getElementAt(i).toString());
                    ++i;
                }
            }
            return ret;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIndexCount(int value) {
            this.indexCount = value;
            this.dimensionModel.removeAllElements();
            int i = 0;
            while (i < this.getIndexCount()) {
                this.dimensionModel.addElement(String.valueOf(i));
                ++i;
            }
            this.dimensionModel.addElement(AnimalTranslator.getTranslator().translateMessage(DIMENSION_INDEX_ALL));
            this.dimensionModel.setSelectedItem(this.dimensionModel.getElementAt(0));
        }

        public void setSubDimensions(DimensionData[] subDimensions) {
            this.subDimensionData = subDimensions;
        }

        public void disableIndexEntries(Vector<Integer> indices) {
            if (indices != null && indices.size() > 0) {
                this.deleteIndices(0, indices);
            }
        }

        private int deleteIndices(int i, Vector<Integer> indices) {
            if (indices.get(i) == -1) {
                int j = 0;
                while (j < this.getIndexCount()) {
                    if (this.subDimensionData == null || this.subDimensionData.length < 1 || this.subDimensionData[j].deleteIndices(i + 1, indices) < 1) {
                        this.deleteIndex(j);
                    }
                    ++j;
                }
            } else if (indices.get(i) >= 0 && indices.get(i) < this.getIndexCount() && (this.subDimensionData == null || this.subDimensionData.length < 1 || this.subDimensionData[indices.get(i)].deleteIndices(i + 1, indices) < 1)) {
                this.deleteIndex(indices.get(i));
            }
            if (this.dimensionModel.getSize() <= this.getIndexCount()) {
                this.deleteIndexAll();
            }
            return this.dimensionModel.getSize();
        }

        private void deleteIndexAll() {
            if (((String)this.dimensionModel.getElementAt(this.dimensionModel.getSize() - 1)).equals(AnimalTranslator.getTranslator().translateMessage(DIMENSION_INDEX_ALL))) {
                this.dimensionModel.removeElementAt(this.dimensionModel.getSize() - 1);
            }
        }

        private void deleteIndex(int i) {
            String searchString = String.valueOf(i);
            String toDelete = null;
            int j = 0;
            while (j < this.dimensionModel.getSize()) {
                if (searchString.equals((String)this.dimensionModel.getElementAt(j))) {
                    toDelete = (String)this.dimensionModel.getElementAt(j);
                }
                ++j;
            }
            if (toDelete != null) {
                this.dimensionModel.removeElement(toDelete);
            }
        }

        public void enableIndexEntries(Vector<Integer> indices) {
            if (indices != null && indices.size() > 0) {
                this.addIndices(0, indices);
            }
        }

        private void addIndices(int i, Vector<Integer> indices) {
            if (indices.get(i) >= -1 && indices.get(i) < this.getIndexCount()) {
                if (indices.get(i) == -1) {
                    int j = 0;
                    while (j < this.getIndexCount()) {
                        if (this.subDimensionData != null && this.subDimensionData.length >= this.getIndexCount()) {
                            this.subDimensionData[j].addIndices(i + 1, indices);
                        }
                        this.addIndex(j);
                        ++j;
                    }
                } else {
                    if (indices.get(i) >= 0 && indices.get(i) < this.getIndexCount() && this.subDimensionData != null && this.subDimensionData.length > indices.get(i)) {
                        this.subDimensionData[indices.get(i)].addIndices(i + 1, indices);
                    }
                    this.addIndex(indices.get(i));
                }
            }
            if (this.dimensionModel.getSize() == this.getIndexCount()) {
                this.addIndexAll();
            }
        }

        private void addIndexAll() {
            if (((String)this.dimensionModel.getElementAt(this.dimensionModel.getSize() - 1)).equals(AnimalTranslator.getTranslator().translateMessage(DIMENSION_INDEX_ALL))) {
                this.dimensionModel.removeElementAt(this.dimensionModel.getSize() - 1);
            } else {
                this.dimensionModel.addElement(AnimalTranslator.getTranslator().translateMessage(DIMENSION_INDEX_ALL));
            }
        }

        private void addIndex(int j) {
            int index = this.dimensionModel.getSize();
            int i = 0;
            while (i < this.dimensionModel.getSize()) {
                if (Integer.valueOf((String)this.dimensionModel.getElementAt(i)) >= j) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == this.dimensionModel.getSize()) {
                this.dimensionModel.addElement(String.valueOf(j));
            } else if (this.dimensionModel.getSize() < 1 || !this.dimensionModel.getElementAt(index).toString().equals(String.valueOf(j))) {
                this.dimensionModel.insertElementAt(String.valueOf(j), index);
            }
        }
    }
}

