/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.animator.Animator;
import animal.editor.LinkEditor;
import animal.editor.graphics.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.gui.GraphicVector;
import animal.gui.GraphicVectorEntry;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.main.Link;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditableObject;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public abstract class Editor
extends JDialog
implements Cloneable,
ActionListener {
    public static final String EDITOR_PATH = "animal.editor.";
    private static Vector<Editor> allEditors = new Vector();
    private int num = -1;
    private GridBagLayout gbl;
    protected JPanel basicPanel;
    protected AbstractButton okButton;
    protected AbstractButton applyButton;
    protected AbstractButton cancelButton;
    XProperties keyLUT;
    XProperties labelLUT;
    static XProperties defaultKeyLUT;
    static XProperties defaultLabelLUT;
    Box mainContentBox = null;
    HashMap<String, JComponent> components;
    private Editor primaryEditor = null;
    public JComboBox depthBox;
    public JTextField objectNameField;
    private EditableObject currentObject;

    protected Editor(JFrame parent) {
        super(parent);
        this.setTitle(String.valueOf(this.getName()) + " " + AnimalTranslator.translateMessage("GenericEditor.options"));
        this.gbl = new GridBagLayout();
        this.getContentPane().setLayout(new BorderLayout());
        this.components = new HashMap(50);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Object object = event.getSource();
                if (object == Editor.this) {
                    Editor.this.close();
                }
            }
        });
        this.installBoxLayout();
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            allEditors.addElement(this);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension thisSize = this.getSize();
            this.setSize(this.getPreferredSize());
            if (this.getLocation().x == 0 && this.getLocation().y == 0) {
                this.setLocation((screenSize.width - thisSize.width) / 2, (screenSize.height - thisSize.height) / 2);
            }
        } else {
            allEditors.removeElement(this);
        }
        super.setVisible(isVisible);
    }

    public abstract void repaintNow();

    protected String isOK() {
        return null;
    }

    protected boolean apply() {
        String error = this.isOK();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, AnimalTranslator.translateMessage("GenericEditor.editorError"), 0);
            return false;
        }
        EditableObject a = this.getCurrentObject();
        if (a != null) {
            this.storeAttributesInto(a);
        }
        if (a instanceof Animator && !Animation.get().containsAnimator((Animator)a)) {
            Animation.get().insertAnimator((Animator)a);
            AnimalMainWindow.getWindowCoordinator().getAnimationOverview(true).initList(true);
        } else {
            Animation.get().doChange();
            this.repaintNow();
        }
        if (a instanceof PTGraphicObject) {
            AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).setChanged();
        } else {
            Animation.get().doChange();
        }
        if (!(this instanceof GraphicEditor)) {
            this.getProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
        return true;
    }

    public void close() {
        EditableObject a = this.getCurrentObject();
        if (a != null) {
            a.resetEditor();
        }
        if (this instanceof GraphicEditor && this.isPrimaryEditor()) {
            AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).getDrawCanvas().setGraphicEditor(null);
        }
        this.setVisible(false);
        this.dispose();
        Set<Map.Entry<String, JComponent>> elementKeys = this.components.entrySet();
        Iterator<Map.Entry<String, JComponent>> keyIterator = elementKeys.iterator();
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        while (keyIterator.hasNext()) {
            Map.Entry<String, JComponent> currentKey = keyIterator.next();
            generator.unregisterComponent(currentKey.getKey(), currentKey.getValue());
        }
    }

    protected JComponent getEditorPanel(boolean useAll, boolean[] used) {
        return null;
    }

    protected JComponent getEditorPanel(XProperties theKeyLUT, XProperties theLabelLUT, ActionListener l, ItemListener i) {
        return this.getEditorPanel(true, null);
    }

    protected int getInt(TextEvent e, int defaultValue) {
        return this.getInt(((JTextComponent)e.getSource()).getText(), defaultValue);
    }

    protected int getInt(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException exc) {
            return defaultValue;
        }
    }

    protected double getDouble(String s, double defaultValue) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException exc) {
            return defaultValue;
        }
    }

    public void setInt(JTextComponent tc, int value) {
        tc.setText(String.valueOf(value));
    }

    public abstract void setProperties(XProperties var1);

    public abstract void getProperties(XProperties var1);

    public final String getName() {
        String name = this.getClass().getName();
        int start = name.lastIndexOf(46);
        name = name.substring(start + 1, name.indexOf("Editor"));
        return name;
    }

    public abstract Editor getSecondaryEditor(EditableObject var1);

    public Editor getPrimaryEditor() {
        if (this.primaryEditor == null) {
            this.primaryEditor = this;
        }
        return this.primaryEditor;
    }

    public boolean isPrimaryEditor() {
        return this.primaryEditor == null || this.primaryEditor == this;
    }

    public EditableObject getCurrentObject(boolean warning) {
        if (this.currentObject == null && warning) {
            MessageDisplay.errorMsg("GenericEditor.objectNull", new Object[]{this.getClass()});
        }
        return this.currentObject;
    }

    public EditableObject getCurrentObject() {
        return this.getCurrentObject(true);
    }

    protected void extractAttributesFrom(EditableObject go) {
        this.linkToEditor(go);
    }

    protected void storeAttributesInto(EditableObject go) {
        this.linkToEditor(go);
    }

    public void linkToEditor(EditableObject go) {
        this.currentObject = go;
        if (go != null) {
            if (this.primaryEditor == null) {
                this.primaryEditor = go.getEditor();
            }
            go.setEditor(this);
        }
        if (go != null && go != go.getEditor().getCurrentObject()) {
            MessageDisplay.errorMsg("GenericEditor.linkToEditorError", new Object[]{this.getClass()});
        }
    }

    public abstract EditableObject createObject();

    public void addLayer(JComponent layer) {
        if (this.basicPanel == null) {
            this.basicPanel = new JPanel();
            this.basicPanel.setLayout(new GridLayout(0, 1));
            this.getContentPane().add("Center", this.basicPanel);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 10, 0, 10);
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        this.gbl.setConstraints(layer, gbc);
        this.basicPanel.add(layer);
    }

    public void finish(JTabbedPane tp) {
        if (this instanceof GraphicEditor) {
            EditableObject o = this.getCurrentObject(false);
            TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
            JPanel depthPanel = generator.generateBorderedJPanel("GenericEditor.depthBL");
            depthPanel.add(AnimalTranslator.getGUIBuilder().generateJLabel("GenericEditor.depthPrompt"));
            this.depthBox = new JComboBox();
            int i = 0;
            while (i <= 16) {
                this.depthBox.addItem(String.valueOf(i));
                ++i;
            }
            int currentDepth = 0;
            this.depthBox.setEditable(true);
            this.depthBox.setSelectedItem(String.valueOf(currentDepth));
            this.depthBox.addActionListener(this);
            depthPanel.add(this.depthBox);
            if (tp != null) {
                tp.addTab(AnimalTranslator.translateMessage("GenericEditor.depth"), depthPanel);
                this.addLayer(tp);
            } else {
                this.addLayer(depthPanel);
            }
            JPanel namePanel = generator.generateBorderedJPanel("GenericEditor.nameBL");
            namePanel.add(AnimalTranslator.getGUIBuilder().generateJLabel("GenericEditor.nameLabel"));
            String name = o instanceof PTGraphicObject ? ((PTGraphicObject)o).getObjectName() : "";
            this.objectNameField = AnimalTranslator.getGUIBuilder().generateJTextField("objName", null, 16, name);
            namePanel.add(this.objectNameField);
            if (tp != null) {
                tp.addTab(AnimalTranslator.translateMessage("GenericEditor.name"), namePanel);
                this.addLayer(tp);
            } else {
                this.addLayer(namePanel);
            }
        }
        this.finish();
    }

    public void finishBoxes() {
        if (this instanceof GraphicEditor) {
            EditableObject o = this.getCurrentObject(false);
            TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
            Box depthBoxComponent = generator.generateBorderedBox(2, "GenericEditor.depthBL");
            depthBoxComponent.add(AnimalTranslator.getGUIBuilder().generateJLabel("GenericEditor.depthPrompt"));
            this.depthBox = new JComboBox();
            int i = 0;
            while (i <= 16) {
                this.depthBox.addItem(String.valueOf(i));
                ++i;
            }
            int currentDepth = 0;
            this.depthBox.setEditable(true);
            this.depthBox.setSelectedItem(String.valueOf(currentDepth));
            this.depthBox.addActionListener(this);
            depthBoxComponent.add(this.depthBox);
            this.addBox(depthBoxComponent);
            Box nameBox = generator.generateBorderedBox(2, "GenericEditor.nameBL");
            nameBox.add(AnimalTranslator.getGUIBuilder().generateJLabel("GenericEditor.nameLabel"));
            String name = o instanceof PTGraphicObject ? ((PTGraphicObject)o).getObjectName() : "";
            this.objectNameField = AnimalTranslator.getGUIBuilder().generateJTextField("objName", null, 16, name);
            nameBox.add(this.objectNameField);
            this.addBox(nameBox);
            this.components.put("GenericEditor.depthBL", depthBoxComponent);
            this.components.put("GenericEditor.nameBL", nameBox);
        }
        Box buttonBox = new Box(2);
        this.okButton = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.ok", null, false, this);
        buttonBox.add(this.okButton);
        this.applyButton = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.apply", null, false, this);
        buttonBox.add(this.applyButton);
        this.cancelButton = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.cancel", null, false, this);
        buttonBox.add(this.cancelButton);
        this.addBox(buttonBox);
        this.pack();
        this.components.put("GenericEditor.objName", this.objectNameField);
        this.components.put("GenericEditor.ok", this.okButton);
        this.components.put("GenericEditor.apply", this.applyButton);
        this.components.put("GenericEditor.cancel", this.cancelButton);
    }

    public void finish() {
        JPanel p = new JPanel();
        this.okButton = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.ok", null, false, this);
        p.add(this.okButton);
        this.applyButton = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.apply", null, false, this);
        p.add(this.applyButton);
        this.cancelButton = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.cancel", null, false, this);
        p.add(this.cancelButton);
        this.getContentPane().add("South", p);
        this.components.put("GenericEditor.ok", this.okButton);
        this.components.put("GenericEditor.apply", this.applyButton);
        this.components.put("GenericEditor.cancel", this.cancelButton);
        this.pack();
    }

    public void installBoxLayout() {
        this.mainContentBox = new Box(3);
        JScrollPane pane = new JScrollPane(this.mainContentBox, 20, 30);
        this.getContentPane().add(pane);
    }

    public void addBox(Box newBox) {
        if (this.mainContentBox == null) {
            System.err.println("MainContentBox was empty...?!?");
            this.installBoxLayout();
            this.getContentPane().add("Center", this.mainContentBox);
        }
        this.mainContentBox.add(newBox);
    }

    public ColorChooserAction generateAndAddColorChoiceEntry(Box colorBox, TranslatableGUIElement generator, Color initialColor, int keyCode) {
        colorBox.add(generator.generateJLabel("GenericEditor.colorLabel"));
        ColorChooserAction colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "textColor", AnimalTranslator.translateMessage("GenericEditor.chooseTextColor"), initialColor);
        colorBox.add(new ExtendedActionButton(colorChooser, keyCode));
        return colorChooser;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.apply()) {
                this.close();
            }
        } else if (e.getSource() == this.applyButton) {
            this.apply();
        } else if (e.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void setNum(int numericID) {
        this.num = numericID;
    }

    public int getNum() {
        return this.num;
    }

    public static void closeAllEditors() {
        int i = allEditors.size() - 1;
        while (i >= 0) {
            Editor e = allEditors.elementAt(i);
            if (!e.isPrimaryEditor()) {
                e.setVisible(false);
                e.dispose();
            }
            --i;
        }
    }

    public static void closeLinkEditors(int step, boolean target) {
        int i = allEditors.size() - 1;
        while (i >= 0) {
            Link l;
            Editor e = allEditors.elementAt(i);
            if (e instanceof LinkEditor && (l = (Link)e.getCurrentObject()) != null && (l.getStep() == step || target && l.getNextStep() == step)) {
                e.setVisible(false);
                e.dispose();
            }
            --i;
        }
    }

    public static PTGraphicObject getGraphicObject(int num) {
        GraphicVector objects = AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).getDrawCanvas().getObjects();
        GraphicVectorEntry gve = objects.getGVEByNum(num);
        if (gve != null) {
            return gve.go;
        }
        return Animation.get().getGraphicObject(num);
    }
}

