/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.main.AnimationState;
import animal.misc.MessageDisplay;
import java.beans.PropertyChangeEvent;

public abstract class TimedAnimator
extends Animator {
    public static final String DURATION_LABEL = "TimedAnimator.duration";
    public static final String OFFSET_LABEL = "TimedAnimator.offset";
    public static final String TIME_UNIT_LABEL = "TimedAnimator.useTicks";
    private static final long serialVersionUID = -6987994586122663241L;
    protected transient Object oldProperty = null;
    protected transient long startTimeOrTicks = 0L;

    public TimedAnimator() {
    }

    public TimedAnimator(int step, int objectNum, int totalTimeOrTicks, int timeOrTicksOffset, String method) {
        this(step, new int[]{objectNum}, totalTimeOrTicks, timeOrTicksOffset, method);
    }

    public TimedAnimator(int step, int[] objectNums, int totalTimeOrTicks, int timeOrTicksOffset, String method) {
        super(step, objectNums);
        this.setDuration(totalTimeOrTicks);
        this.setOffset(timeOrTicksOffset);
        this.setMethod(method);
    }

    public TimedAnimator(int step, int[] objectNums, int totalTimeOrTicks, String method) {
        this(step, objectNums, totalTimeOrTicks, 0, method);
    }

    public void copyTimingFrom(TimedAnimator animator) {
        this.setOffset(animator.getOffset());
        this.setDuration(animator.getDuration());
        this.setUnitIsTicks(animator.isUnitIsTicks());
    }

    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.startTimeOrTicks = this.isUnitIsTicks() ? Math.round(ticks) : time;
        this.oldProperty = this.getProperty(0.0);
    }

    public void action(long time, double ticks) {
        if (this.hasFinished()) {
            return;
        }
        double elapsed = (this.isUnitIsTicks() ? ticks : (double)time) - (double)this.startTimeOrTicks - (double)this.getOffset();
        double factor = elapsed / (double)this.getDuration();
        if (this.getDuration() == 0 && elapsed >= 0.0 || factor >= 1.0) {
            this.execute();
        } else {
            if (factor < 0.0) {
                return;
            }
            Object newProperty = this.getProperty(factor);
            int a = 0;
            while (a < this.objects.length) {
                if (this.objects[a] != null) {
                    this.objects[a].propertyChange(new PropertyChangeEvent(this, this.getMethod(), this.oldProperty, newProperty));
                }
                ++a;
            }
            this.oldProperty = newProperty;
        }
    }

    public void execute() {
        super.execute();
        if (this.oldProperty == null) {
            this.oldProperty = this.getProperty(0.0);
        }
        Object newProperty = this.getProperty(1.0);
        if (this.objects != null && this.objects.length > 0) {
            int a = 0;
            while (a < this.objects.length) {
                if (this.objects[a] != null) {
                    this.objects[a].propertyChange(new PropertyChangeEvent(this, this.getMethod(), this.oldProperty, newProperty));
                }
                ++a;
            }
        } else {
            MessageDisplay.errorMsg("noObjectsSetException", new Object[]{String.valueOf(this.getStep()), String.valueOf(this.getAnimatorName()) + " -- " + this.toString()});
        }
    }

    public int getDuration() {
        return this.getProperties().getIntProperty(DURATION_LABEL, 0);
    }

    public int getFileVersion() {
        return 2;
    }

    public String getMethod() {
        return this.getProperties().getProperty("method");
    }

    public int getOffset() {
        return this.getProperties().getIntProperty(OFFSET_LABEL, 0);
    }

    public abstract Object getProperty(double var1);

    public long getStartTimeOrTicks() {
        return this.startTimeOrTicks;
    }

    public boolean isUnitIsTicks() {
        return this.getProperties().getBoolProperty(TIME_UNIT_LABEL, true);
    }

    public void setDuration(int total) {
        this.getProperties().put(DURATION_LABEL, total);
    }

    public void setMethod(String method) {
        this.getProperties().put("method", method);
    }

    public void setOffset(int offset) {
        this.getProperties().put(OFFSET_LABEL, offset);
    }

    public void setUnitIsTicks(boolean useTicks) {
        this.getProperties().put(TIME_UNIT_LABEL, useTicks);
    }

    public void discard() {
        this.setMethod(null);
        this.oldProperty = null;
        super.discard();
    }

    public String toString() {
        StringBuilder showMe = new StringBuilder(super.toString());
        showMe.append(" within ").append(this.getDuration()).append(" ");
        showMe.append(this.isUnitIsTicks() ? "ticks" : "ms");
        if (this.getOffset() != 0) {
            showMe.append(" starting after ").append(this.getOffset());
            showMe.append(" ").append(this.isUnitIsTicks() ? "ticks" : "ms");
        }
        return showMe.toString();
    }
}

