/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.PerformableAction;
import animal.animator.QuestionAction;
import animal.main.Animal;
import animal.misc.MessageDisplay;
import animal.misc.MultipleChoiceInterface;
import java.util.Hashtable;

public class MultipleChoiceQuestionAction
extends QuestionAction
implements PerformableAction {
    private static final long serialVersionUID = -2375728076191469987L;
    public static final String TYPE_LABEL = "MultipleChoiceQuestion";
    int answerCounter = 0;
    private Hashtable<String, String> answers = new Hashtable(17);
    private boolean constructed = false;
    int correctAnswerIndex = 0;
    private MultipleChoiceInterface handler = null;

    public MultipleChoiceQuestionAction() {
        this("none");
    }

    public MultipleChoiceQuestionAction(String theTitle) {
        this.setType(2);
        this.setTitle(theTitle);
        this.handler = (MultipleChoiceInterface)Animal.getInteractionHandler().getHandlerFor(1, theTitle);
    }

    public void addAnswer(String answerText) {
        ++this.answerCounter;
        this.answers.put(String.valueOf(this.answerCounter), answerText);
        this.handler.SetPossibleAnswer(answerText.trim());
    }

    public void setCorrectAnswer(int nrOfCorrectAnswer) {
        if (this.correctAnswerIndex <= this.answers.size()) {
            this.correctAnswerIndex = nrOfCorrectAnswer;
        } else {
            MessageDisplay.errorMsg("invalidCorrectAnswerException", new Object[]{String.valueOf(this.correctAnswerIndex), String.valueOf(this.answers.size())});
        }
        this.handler.SetCorrectAnswer(nrOfCorrectAnswer - 1);
    }

    public void perform() {
        Animal.getInteractionHandler().initialize(this.handler, this.constructed, this.getQuestionText());
        this.constructed = true;
        Animal.getInteractionHandler().performQuestionOperation(this.handler);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("Multiple Choice question: '").append(this.getQuestionText());
        int nrAnswers = this.answers.size();
        sb.append("' answers: [").append(nrAnswers).append("]: {");
        int i = 1;
        while (i <= nrAnswers) {
            sb.append("{ ").append(i).append(". '").append(this.answers.get(String.valueOf(i))).append("'}");
            ++i;
        }
        sb.append("} correct: ").append(this.correctAnswerIndex);
        return sb.toString();
    }
}

