/*
 * Decompiled with CFR 0.152.
 */
package algorithm.compression;

import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShannonFanoAlgo {
    public static void compress(String[] text) {
        String input = "";
        int i = 0;
        while (i < text.length) {
            input = String.valueOf(input) + text[i];
            ++i;
        }
        int[] list = new int[256];
        int i2 = 0;
        while (i2 < text.length) {
            int n = new Integer(text[i2].charAt(0));
            list[n] = list[n] + 1;
            ++i2;
        }
        Vector<Letter> letters = new Vector<Letter>(0, 1);
        int most = -1;
        int mostIndex = -1;
        int numberOfLetters = 0;
        int i3 = 0;
        while (i3 < 256) {
            if (list[i3] != 0) {
                ++numberOfLetters;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < numberOfLetters) {
            most = -1;
            mostIndex = -1;
            int j = 0;
            while (j < list.length) {
                if (list[j] > 0 && list[j] > most) {
                    most = list[j];
                    mostIndex = j;
                }
                ++j;
            }
            letters.add(new Letter("" + (char)mostIndex, most));
            list[mostIndex] = 0;
            ++i3;
        }
        Partition partition = new Partition(letters);
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash = ShannonFanoAlgo.fillHash(hash, partition, "");
        String result = "";
        int i4 = 0;
        while (i4 < text.length) {
            result = String.valueOf(result) + hash.get(text[i4]) + " ";
            ++i4;
        }
        System.out.println(result);
    }

    public static Hashtable<String, String> fillHash(Hashtable<String, String> hash, Partition p, String currentBits) {
        if (p.value != null) {
            hash.put(p.value, currentBits);
        } else {
            hash = ShannonFanoAlgo.fillHash(hash, p.left, String.valueOf(currentBits) + "0");
            hash = ShannonFanoAlgo.fillHash(hash, p.right, String.valueOf(currentBits) + "1");
        }
        return hash;
    }

    public static void main(String[] args) {
        ShannonFanoAlgo.compress(new String[]{"H", "A", "L", "L", "O", "A", "B", "C"});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Partition {
        private Partition left;
        private Partition right;
        private String value;

        public Partition(Vector<Letter> letters) {
            if (letters.size() == 1) {
                this.value = letters.elementAt(0).letter;
            } else {
                int sum = 0;
                int i = 0;
                while (i < letters.size()) {
                    sum += letters.elementAt(i).frequency;
                    ++i;
                }
                float half = (float)sum / 2.0f;
                int count = 0;
                int index = 0;
                float difference = half;
                int i2 = 0;
                while (i2 < letters.size()) {
                    if (!(Math.abs(half - ((float)count + (float)letters.elementAt(i2).frequency)) < difference)) break;
                    difference = Math.abs(half - (float)(count += letters.elementAt(i2).frequency));
                    index = i2++;
                }
                Vector<Letter> l = new Vector<Letter>(0, 1);
                Vector<Letter> r = new Vector<Letter>(0, 1);
                int i3 = 0;
                while (i3 < letters.size()) {
                    if (i3 <= index) {
                        l.add(letters.elementAt(i3));
                    } else {
                        r.add(letters.elementAt(i3));
                    }
                    ++i3;
                }
                this.left = new Partition(l);
                this.right = new Partition(r);
            }
        }
    }

    public static class Letter {
        private String letter;
        private int frequency;

        public Letter(String letter, int frequency) {
            this.letter = letter;
            this.frequency = frequency;
        }
    }
}

