/*
 * Decompiled with CFR 0.152.
 */
package algorithm.compression;

import java.util.TreeSet;

public class HuffmanAlgo {
    public static void compress(String[] text) {
        String input = "";
        int i = 0;
        while (i < text.length) {
            input = String.valueOf(input) + text[i];
            ++i;
        }
        input = input.toUpperCase();
        int[] list = new int[256];
        int i2 = 0;
        while (i2 < text.length) {
            int n = new Integer(text[i2].charAt(0));
            list[n] = list[n] + 1;
            ++i2;
        }
        TreeSet<Node> nodes = new TreeSet<Node>();
        int i3 = 0;
        while (i3 < list.length) {
            if (list[i3] > 0) {
                nodes.add(new Node((char)i3, list[i3]));
            }
            ++i3;
        }
        while (nodes.size() > 1) {
            Node small = (Node)nodes.first();
            nodes.remove(small);
            Node small2 = (Node)nodes.first();
            nodes.remove(small2);
            nodes.add(new Node(small, small2));
        }
        String result = "";
        int i4 = 0;
        while (i4 < input.length()) {
            result = String.valueOf(result) + ((Node)nodes.first()).getBits(input.charAt(i4));
            result = String.valueOf(result) + " ";
            ++i4;
        }
        System.out.println(result);
    }

    public static void main(String[] args) {
        HuffmanAlgo.compress(new String[]{"I", "N", "F", "O", "R", "M", "A", "T", "I", "K"});
    }

    public static class Node
    implements Comparable {
        int sum;
        char letter;
        public Node left;
        public Node right;

        public Node(char letter, int sum) {
            this.letter = letter;
            this.sum = sum;
        }

        public Node(Node left, Node right) {
            this.letter = left.letter < right.letter ? left.letter : right.letter;
            this.sum = left.sum + right.sum;
            this.left = left;
            this.right = right;
        }

        public String getBits(char letter) {
            if (this.letter == letter && this.left == null && this.right == null) {
                return "";
            }
            if (this.left == null && this.right == null) {
                return null;
            }
            if (this.left.getBits(letter) != null) {
                return "0" + this.left.getBits(letter);
            }
            if (this.right.getBits(letter) != null) {
                return "1" + this.right.getBits(letter);
            }
            return null;
        }

        public int compareTo(Object o) {
            if (this.sum < ((Node)o).sum) {
                return -1;
            }
            if (this.sum > ((Node)o).sum) {
                return 1;
            }
            if (this.letter < ((Node)o).letter) {
                return -1;
            }
            if (this.letter > ((Node)o).letter) {
                return 1;
            }
            return 0;
        }
    }
}

