/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.util.Locale;

public class ShellSortEN
extends SortingAlgorithm
implements Generator {
    private static final String DESCRIPTION = "This algorithm performs Shell Sort.\nThe sequence chosen is 1, 4, 13, ...\n where h(n+1) = h(n) * 3 +1";
    private static final String HEADER_TEXT = "text \"f1-01\" \"Shell Sort\" at (120,50) color black font SansSerif size 32 bold\n{\n  text \"f1-02a\" \"Insertion Sort is slow, because it can only move elements\" at (20,100) color black font SansSerif size 24\n  text \"f1-02b\" \"one position to the right with each step.\" at (20,130) color black font SansSerif size 24\n}\n{\n  text \"f1-03a\" \"Shellsort tries to move elements faster to their final position\" at (20,170) color black font SansSerif size 24\n  text \"f1-03b\" \"by using leaps.\" at (20,200) color black font SansSerif size 24\n}\n{\n  text \"f1-04a\" \"The data is h-sorted in each step. A set of data is\" at (20,240) color black font SansSerif size 24\n  text \"f1-04b\" \"h-sorted, if selecting every h-th element starting at position 0,..., h-1\" at (20,270) color black font SansSerif size 24\n  text \"f1-04c\" \"will always yield a sorted data set.\" at (20,300) color black font SansSerif size 24\n}\n{\n  text \"f1-05a\" \"Therefore, a h-sorted array consists of h independently sorted\" at (20,340) color black font SansSerif size 24\n  text \"f1-05b\" \"data sets interleaved in one array\" at (20,370) color black font SansSerif size 24\n}\n{\n  text \"f1-06a\" \"To sort the data, Shell Sort performs a set of h-sorting steps\" at (20,410) color black font SansSerif size 24\n  text \"f1-06b\" \"for decreasing values of h, until it finally performs h-sorting for h==1.\" at (20,440) color black font SansSerif size 24\n  text \"f1-06c\" \"h==1 essentially equals Insertion Sort.\" at (20,470) color black font SansSerif size 24\n}\ntext \"f1-07a\" \"The set of values to use for h is also called the increment order.\" at (20,510) color black font SansSerif size 24\nhideAll\ntext \"f2-01\" \"Verbal Description\" at (120,50) color black font SansSerif size 32 bold\n{\n  text \"f2-02a\" \"It can be proved, that h[i+1]=3*h[i]+1 yields good results.\" at (20,100) color black font SansSerif size 24\n  text \"f2-02b\" \"Using this, the algorithm can be adapted as follows:\" at (20,130) color black font SansSerif size 24\n}\ntext \"f2-03\" \"1. while h<=n/9, set h=3*h+1\" at (20,200) color black font SansSerif size 24\ntext \"f2-04\" \"2. Set i=h\" at (20,240) color black font SansSerif size 24\ntext \"f2-05a\" \"3. Store Element a[i] in a variable v, and store i in j\" at (20,280) color black font SansSerif size 24\ntext \"f2-06\" \"4. While j>h ist and a[j-h]>v, set a[j]=a[j-h] and j=j-h\" at (20,350) color black font SansSerif size 24\ntext \"f2-07\" \"5. Set a[j]=v\" at (20,390) color black font SansSerif size 24\ntext \"f2-08\" \"6. Increment i. If i<n, continue with step 3\" at (20,430) color black font SansSerif size 24\ntext \"f2-09\" \"7. Set h=h/3 (integer division!). If h>0, continue with step 2\" at (20,470) color black font SansSerif size 24\n";
    private static final String SOURCE_CODE = "public void shellSort(int[] array) {\n  int i, j, dist, v;\n  for (dist = 1; dist < array.length / 9; dist = dist * 3 +1) ;\n  for (; dist > 0; dist /= 3) {\n    for (i = dist; i < array.length; i++) {\n      v = array[i];\n     j = i;\n      while (j >= dist && v < array[j - dist]) {\n        array[j] = array[j-dist]\n        j = j - dist;\n      }\n     array[j] = v;\n   }\n  }\n}";

    public void sort(int[] a) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Shell Sort Animation\"\n");
        this.sb.append("author \"Jens Falk <Jens.Falk@epost.de>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.targetArray = this.createIntArray("array");
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.toggleStep();
        this.codeSupport.highlightCode(0);
        this.toggleStep();
        this.codeSupport.switchCodeLine(0, 1);
        this.jMarker = this.createArrayMarker(this.targetArray, 0, "j");
        this.toggleStep();
        this.codeSupport.switchCodeLine(1, 2);
        int oldDist = -1;
        this.sb.append("  text \"dist\" \"dist:\" offset (40, 20) from \"array\" E");
        int dist = 1;
        while (dist < a.length / 9) {
            this.toggleStep();
            if (oldDist != -1) {
                this.sb.append("  hide \"dist").append(oldDist).append("\"");
            }
            this.sb.append("  text \"dist").append(dist).append("\" offset (10, 0)");
            this.sb.append(" from \"dist\" baseline");
            oldDist = dist;
            dist = 3 * dist + 1;
        }
        this.toggleStep();
        this.codeSupport.switchCodeLine(2, 3);
        while (dist > 0) {
            this.toggleStep();
            if (dist != oldDist) {
                this.sb.append("  hide \"dist").append(oldDist).append("\"\n");
            }
            oldDist = dist;
            this.codeSupport.switchCodeLine(3, 4);
            int i = dist;
            while (i < this.targetArray.getLength()) {
                if (this.iMarker == null) {
                    this.iMarker = this.createArrayMarker(this.targetArray, i, "i");
                } else {
                    this.iMarker.moveArrayIndex(i);
                }
                ++this.nrAssigns;
                this.toggleStep();
                this.codeSupport.switchCodeLine(4, 5);
                int v = this.targetArray.getElementAt(i);
                this.targetArray.highlightArrayCell(i);
                this.toggleStep();
                this.codeSupport.switchCodeLine(5, 6);
                this.targetArray.unhighlightArrayElement(i);
                int j = i;
                if (this.jMarker == null) {
                    this.jMarker = this.createArrayMarker(this.targetArray, j, "j");
                } else {
                    this.jMarker.moveArrayIndex(j);
                }
                this.toggleStep();
                this.codeSupport.switchCodeLine(6, 7);
                while (j >= dist && v < this.targetArray.getElementAt(j - dist)) {
                    this.toggleStep();
                    this.codeSupport.switchCodeLine(7, 8);
                    ++this.nrComparisons;
                    ++this.nrAssigns;
                    this.targetArray.putElement(this.targetArray.getElementAt(j - dist), j);
                    this.targetArray.highlightArrayCell(j);
                    this.targetArray.unhighlightArrayCell(j - 1);
                    this.toggleStep();
                    this.codeSupport.switchCodeLine(8, 9);
                    this.jMarker.moveArrayIndex(j -= dist);
                    this.toggleStep();
                    this.codeSupport.switchCodeLine(9, 7);
                }
                this.toggleStep();
                this.codeSupport.switchCodeLine(7, 11);
                ++this.nrComparisons;
                ++this.nrAssigns;
                this.targetArray.putElement(v, j);
                this.targetArray.highlightArrayElement(j);
                this.toggleStep();
                this.codeSupport.switchCodeLine(11, 4);
                this.targetArray.unhighlightArrayElement(j);
                ++i;
            }
            this.endStep();
            this.codeSupport.switchCodeLine(4, 3);
            dist /= 3;
        }
        this.codeSupport.unhighlightCode(3);
        this.toggleStep();
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00fchrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Shell Sort (English)";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

