/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.util.Locale;
import net.algoanim.aads.AnimatedIntArrayMarker;

public class InsertionSortGdI2
extends SortingAlgorithm
implements Generator {
    private static final String DESCRIPTION = "Dieser Generator sortiert das vom Nutzer eingegebene Array mittels Insertion Sort.Der Algorithmus entnimmt der unsortierten Eingabemenge ein beliebiges (z.B. das erste) Element und f\u00fcgt es an richtiger Stelle in die (anfangs leere) Ausgabemenge ein. Das Verfahren arbeitet also in-place. Geht man in der Reihenfolge der urspr\u00fcnglichen Menge vor, so ist es jedoch (etwa im Gegensatz zu Selection Sort) stabil. Wird auf einem Array gearbeitet, so m\u00fcssen die Elemente nach dem neu eingef\u00fcgten Element verschoben werden. Dies ist die eigentlich teure Operation von Insertionsort, da das Finden der richtigen Einf\u00fcgeposition \u00fcber eine bin\u00e4re Suche vergleichsweise effizient erfolgen kann.";
    private static final String HEADER_TEXT = "text \"f1-01\" \"Insertion Sort\" at (120,50) color black font SansSerif size 32 bold\n{\n  text \"f1-02a\" \"Sortieren durch Einf\u00fcgen, auch als Insertion Sort bezeichnet, fuegt\" at (20,100) color black font SansSerif size 24\n  text \"f1-02b\" \"der Reihe nach Elemente in eine bereits sortierte (Teil-)Liste ein,\" at (20,130)\n  text \"f1-02c\" \"die anfangs leer ist.\" at (20,160)\n}\n{\n  text \"f1-03a\" \"Damit ist das Vorgehen dem Sortieren von Spielkarten \u00e4hnlich: in\" at (20,200)\n  text \"f1-03b\" \"jedem Schritt wird eine neue Spielkarte zwischen die bereits\" at (20,230)\n  text \"f1-03c\" \"sortierten Karten einf\u00fcgt.\" at (20,260)\n}\nlabel \"Insertion Sort \u00dcbersicht\"\nhideAll\ntext \"f2-01\" \"Der Algorithmus in Worten\" at (120,50) color black font SansSerif size 32 bold\ntext \"f2-02\" \"1. Setze i=1\" at (20,100) color black font SansSerif size 24\ntext \"f2-03\" \"2. Setze j=i und speichere a[i] in einer Variablen temp\" at (20,140)\n{\n  text \"f2-04a\" \"3. Solange j>0 und v kleiner als a[j-1] ist,\" at (20,180)\n  text \"f2-04b\" \"   kopiere a[j-1] an Position a[j] und setze j = j - 1\" at (20,210)\n}\ntext \"f2-05\" \"4. F\u00fcge Element temp an die Position j ein\" at (20,250)\n{\n  text \"f2-06a\" \"5. Falls i kleiner als n ist, erh\u00f6he i um eins und fahre\" at (20,290)\n  text \"f2-06b\" \"    fort mit Schritt 2\" at (20,320)\n}\nlabel \"Insertion Sort Pseudocode\"\n";
    private static final String SOURCE_CODE = "public void insertionSort(int[] array){ // sort by Insertion Sort\n  int i, j, temp;\n  for (i=1; i<array.length; i++) {\n    j = i;\n    temp = array[i]; // store current element\n    while (j > 0 && array[j - 1] > temp) {\n      array[j] = array[j - 1]; // copy smaller value over current\n      j = j - 1; // step to next element\n    }\n    array[j] = temp; // re-insert current value in proper position\n  }\n}";

    public void sort(int[] array) {
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Insertion Sort Animation\"\n");
        this.sb.append("author \"Dr. Guido Roessling <roessling@acm.org>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.targetArray = this.createIntArray("array");
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.endStep();
        this.addLabel(this.sb, "Initialisierung");
        this.codeSupport.highlightCode(0);
        this.toggleStep();
        this.codeSupport.switchCodeLine(0, 1);
        int temp = -1;
        this.iMarker = new AnimatedIntArrayMarker(this.targetArray, 0, "i", this.sb, "i");
        this.jMarker = new AnimatedIntArrayMarker(this.targetArray, 0, "j", this.sb, "j");
        this.sb.append("  text \"temp\" \"temp:\" offset (0, 20) from \"array\" SW size 14\n");
        this.toggleStep();
        this.codeSupport.unhighlightCode(1);
        int i = 1;
        while (i < array.length) {
            this.codeSupport.switchCodeLine(i != 1 ? 9 : 1, 2);
            this.targetArray.incrementAssignments();
            this.targetArray.incrementComparisons();
            this.iMarker.moveArrayIndex(i);
            this.targetArray.highlightArrayCell(i - 1);
            this.addLabel(this.sb, "Sortieren bis Position " + i);
            this.toggleStep();
            this.codeSupport.highlightCode(3);
            this.codeSupport.highlightCode(2, true, true);
            this.jMarker.moveArrayIndex(i);
            this.toggleStep();
            this.codeSupport.switchCodeLine(3, 4);
            if (i > 1) {
                this.sb.append("  hide \"tmp").append(i - 1).append("\n");
            }
            temp = this.targetArray.getElementAt(i);
            this.sb.append("  text \"tmp").append(i).append("\" \"").append(temp);
            this.sb.append("\" offset (10, 0) from \"temp\" baseline end\n");
            this.toggleStep();
            this.codeSupport.switchCodeLine(4, 5);
            while (this.jMarker.getCurrentIndex() > 0 && this.targetArray.getElementAt(this.jMarker.getCurrentIndex() - 1) > temp) {
                this.targetArray.incrementComparisons(2);
                int j = this.jMarker.getCurrentIndex();
                this.toggleStep();
                this.targetArray.highlightArrayElement(j - 1);
                this.codeSupport.highlightCode(5, true, true);
                this.codeSupport.highlightCode(6);
                this.targetArray.putElement(this.targetArray.getElementAt(j - 1), j, 10, 5);
                this.toggleStep();
                this.codeSupport.switchCodeLine(6, 7);
                this.targetArray.unhighlightArrayElement(j);
                this.jMarker.moveArrayIndex(j - 1);
                this.targetArray.unhighlightArrayElement(j - 1);
                this.toggleStep();
                this.codeSupport.switchCodeLine(7, 5);
            }
            this.targetArray.incrementComparisons();
            this.toggleStep();
            this.codeSupport.switchCodeLine(5, 9);
            this.targetArray.putElement(temp, this.jMarker.getCurrentIndex(), 10, 0);
            this.sb.append("  color \"tmp").append(i).append("\" red");
            this.targetArray.highlightArrayCell(0, i);
            this.addLabel(this.sb, "Einf\u00fcgen Element f\u00fcr Array [0," + i + "]");
            this.toggleStep();
            ++i;
        }
        this.targetArray.incrementComparisons();
        this.targetArray.incrementAssignments();
        this.codeSupport.unhighlightCode(9);
        this.codeSupport.unhighlightCode(2);
        this.nrAssigns = this.targetArray.getNrAssignments();
        this.nrComparisons = this.targetArray.getNrComparisons();
        this.startStep();
        this.endAnimGeneration();
        this.endStep();
        this.addLabel(this.sb, "Aufwand");
        this.sb.append(this.generateEnglishSummary(this.targetArray.getNrComparisons(), this.targetArray.getNrAssignments()));
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Insertion Sort (GdI 2)";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

