/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.primitives.ArrayPrimitive;
import animalscriptapi.primitives.generators.StringArrayGenerator;
import animalscriptapi.properties.ArrayProperties;
import animalscriptapi.util.ArrayDisplayOptions;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;

public class StringArray
extends ArrayPrimitive {
    private String[] data;
    protected StringArrayGenerator generator;
    private ArrayProperties properties = null;
    private Node upperLeft = null;

    public StringArray(StringArrayGenerator sag, Node upperLeftCorner, String[] arrayData, String name, ArrayDisplayOptions display, ArrayProperties iap) {
        super(sag, display);
        if (upperLeftCorner == null) {
            throw new IllegalArgumentException("The coordinate of the upper left Node shouldn't be null!");
        }
        this.upperLeft = upperLeftCorner;
        this.length = arrayData.length;
        this.data = arrayData;
        this.properties = iap;
        this.setName(name);
        this.generator = sag;
        this.generator.create(this);
    }

    public void put(int where, String what, Timing t, Timing d) throws IndexOutOfBoundsException {
        if (where >= this.data.length || where < 0) {
            throw new IndexOutOfBoundsException("Array has min Size 0 and max Size " + this.data.length);
        }
        this.data[where] = what;
        this.generator.put(this, where, what, t, d);
    }

    public void swap(int what, int with, Timing t, Timing d) throws IndexOutOfBoundsException {
        if (what >= this.data.length || what < 0 || with >= this.data.length || with < 0) {
            throw new IndexOutOfBoundsException("Array has min Size 0 and max Size " + this.data.length);
        }
        String tmp = this.data[what];
        this.data[what] = this.data[with];
        this.data[with] = tmp;
        this.generator.swap(this, what, with, t, d);
    }

    public String[] getData() {
        String[] copy = new String[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            copy[i] = this.data[i];
            ++i;
        }
        return copy;
    }

    public String getData(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Array has min Size 0 and max Size " + this.data.length);
        }
        return this.data[i];
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    public ArrayProperties getProperties() {
        return this.properties;
    }

    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }

    public void highlightCell(int position, Timing offset, Timing duration) {
        if (position >= 0 && position < this.getLength()) {
            this.generator.highlightCell(this, position, offset, duration);
        }
    }

    public void highlightCell(int from, int to, Timing offset, Timing duration) {
        if (from <= to && from >= 0 && from < this.getLength() && to >= 0 && to < this.getLength()) {
            this.generator.highlightCell(this, from, to, offset, duration);
        }
    }

    public void unhighlightCell(int position, Timing offset, Timing duration) {
        if (position >= 0 && position < this.getLength()) {
            this.generator.unhighlightCell(this, position, offset, duration);
        }
    }

    public void unhighlightCell(int from, int to, Timing offset, Timing duration) {
        if (from <= to && from >= 0 && from < this.getLength() && to >= 0 && to < this.getLength()) {
            this.generator.unhighlightCell(this, from, to, offset, duration);
        }
    }

    public void highlightElem(int position, Timing offset, Timing duration) {
        if (position >= 0 && position < this.getLength()) {
            this.generator.highlightElem(this, position, offset, duration);
        }
    }

    public void highlightElem(int from, int to, Timing offset, Timing duration) {
        if (from <= to && from >= 0 && from < this.getLength() && to >= 0 && to < this.getLength()) {
            this.generator.highlightElem(this, from, to, offset, duration);
        }
    }

    public void unhighlightElem(int position, Timing offset, Timing duration) {
        if (position >= 0 && position < this.getLength()) {
            this.generator.unhighlightElem(this, position, offset, duration);
        }
    }

    public void unhighlightElem(int from, int to, Timing offset, Timing duration) {
        if (from <= to && from >= 0 && from < this.getLength() && to >= 0 && to < this.getLength()) {
            this.generator.unhighlightElem(this, from, to, offset, duration);
        }
    }
}

