/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.exceptions.IllegalDirectionException;
import animalscriptapi.primitives.generators.GeneratorInterface;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;
import java.awt.Color;

public abstract class Primitive {
    protected GeneratorInterface gen = null;
    private DisplayOptions display;
    private String name = "";

    protected Primitive(GeneratorInterface g, DisplayOptions d) {
        this.gen = g;
        this.setDisplayOptions(d);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName != null) {
            this.name = newName;
        }
    }

    public DisplayOptions getDisplayOptions() {
        return this.display;
    }

    private void setDisplayOptions(DisplayOptions displayOptions) {
        this.display = displayOptions;
    }

    public void exchange(Primitive q) {
        this.gen.exchange(this, q);
    }

    public void rotate(Primitive around, int degrees, Timing t, Timing d) {
        this.gen.rotate(this, around, degrees, t, d);
    }

    public void rotate(Node center, int degrees, Timing t, Timing d) {
        this.gen.rotate(this, center, degrees, t, d);
    }

    public void changeColor(String colorType, Color newColor, Timing t, Timing d) {
        this.gen.changeColor(this, colorType, newColor, t, d);
    }

    public void moveVia(String direction, String moveType, Primitive via, Timing delay, Timing duration) throws IllegalDirectionException {
        this.gen.moveVia(this, direction, moveType, via, delay, duration);
    }

    public void moveBy(String moveType, int dx, int dy, Timing delay, Timing duration) {
        this.gen.moveBy(this, moveType, dx, dy, delay, duration);
    }

    public void moveTo(String direction, String moveType, Node target, Timing delay, Timing duration) throws IllegalDirectionException {
        this.gen.moveTo(this, direction, moveType, target, delay, duration);
    }

    public void show(Timing t) {
        this.gen.show(this, t);
    }

    public void show() {
        this.show(null);
    }

    public void hide(Timing t) {
        this.gen.hide(this, t);
    }

    public void hide() {
        this.hide(null);
    }
}

