/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.generators.ListElementGenerator;
import animalscriptapi.properties.ListElementProperties;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListElement
extends Primitive {
    private ListElementProperties properties;
    private ListElementGenerator generator = null;
    private ListElement prev;
    private Node upperLeft;
    private int pointers;
    private LinkedList<Object> ptrLocations;

    public ListElement(ListElementGenerator leg, Node upperLeftCorner, int nrPointers, LinkedList<Object> pointerLocations, ListElement prevElement, String name, DisplayOptions display, ListElementProperties lp) {
        super(leg, display);
        this.properties = lp;
        this.upperLeft = upperLeftCorner;
        this.prev = prevElement;
        this.setPointers(nrPointers);
        this.generator = leg;
        this.setName(name);
        this.generator.create(this);
    }

    private void setPointers(int nrPointers) {
        this.pointers = nrPointers >= 0 && nrPointers < 256 ? nrPointers : 0;
    }

    public int getPointers() {
        return this.pointers;
    }

    public void setPointerLocations(LinkedList<Object> pointerLocations) {
        this.ptrLocations = pointerLocations;
    }

    public LinkedList<Object> getPointerLocations() {
        return this.ptrLocations;
    }

    public ListElementProperties getProperties() {
        return this.properties;
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    public ListElement getPrev() {
        return this.prev;
    }

    public void link(ListElement target, int linkno, Timing offset, Timing duration) {
        if (linkno <= this.pointers && linkno >= 0) {
            this.generator.link(this, target, linkno, offset, duration);
        }
    }

    public void unlink(int linkno, Timing offset, Timing duration) {
        if (linkno <= this.pointers && linkno >= 0) {
            this.generator.unlink(this, linkno, offset, duration);
        }
    }

    @Override
    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }
}

